alias demo_1 {
    drawrect -nrf @demo $rgb(96,96,96) 0 0 0 320 180

    var %text %dm.p1.text
    var %tot $len(%text)
    var %cnt %dm.p1.text.offset
    var %xmain %dm.p1.text.x
    while (%cnt <= %tot) {
        var %xpos $calc(%xmain + (%cnt * 24))
        if (%xpos < 320) {
            if (%xpos > -64) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    var %y $calc(($cos($calc((%dm.c / 4) + (%cnt * 8))).deg * 24) + (%dm.p1.rsplit.y - 64))
                    drawtext -nro @demo 0 "lucida console" 32 $calc(%xpos + 1) $calc(%y + 1) %chr
                    drawtext -nro @demo $rgb(255,255,255) "lucida console" 32 %xpos %y %chr
                }
            }
            else {
                inc %dm.p1.text.offset
            }
        }
        else {
            break
        }
        inc %cnt
    }

    ddec dm.p1.text.x .2

    ;;----- rasterline split

    var %y %dm.p1.rsplit.y
    drawline -nr @demo $rgb(80,80,80) 1 0 %y 320 %y
    drawline -nr @demo $rgb(70,70,70) 1 0 $calc(%y + 1) 320 $calc(%y + 1)
    drawline -nr @demo $rgb(60,60,60) 1 0 $calc(%y + 2) 320 $calc(%y + 2)
    drawline -nr @demo $rgb(50,50,50) 1 0 $calc(%y + 3) 320 $calc(%y + 3)
    drawrect -nrf @demo $rgb(35,35,35) 0 0 $calc(%y + 4) 320 190

    if (%y < 96) {
        dinc dm.p1.rsplit.y .1
    }
    var %pic $qt($scriptdirimg\nordlicht-logo.png)

    if (%dm.p1.text.x < -2100) {
        var %cnt 1
        while (%cnt <= 77) {
            var %x $calc($sin($calc((%dm.c / 4) + (%cnt * 3.5))).deg * 16)
            drawpic -ncs @demo %x $calc(100 + %cnt) %dm.p1.logo.fade.in 1 0 %cnt %dm.p1.logo.fade.in 2 %pic
            inc %cnt 2
        }
        dinc dm.p1.logo.fade.in .1
    }

    if (%dm.c > 28500) {
        drawrect -nrf @demo $rgb(96,96,96) 0 0 0 320 %y
        dinc dm.p1.rsplit.y .1
    }
    ;;------

    noop $dmDrawFrame(demo_1)

    if (%dm.c > 29500) {
        .signal -n dmSelectPart 2
        return
    }
}

alias demo_2 {
    var %str Space for 100 visitors!,party room with bar!,dedicated sleeping area!,decent PA system!,Two bigscreens!,Outdoor area w/ grill!,Free BBQ/Breakfast!,Lan & Internet access!,DJ sets & performances!,And more!
    var %font Impact
    var %text $gettok(%str, %dm.test.index, 44)
    var %sin $calc(($cos($calc((%dm.c / 8) + 180)).deg * 15) + 17)
    var %text.w $width(%text, %font, %sin)
    var %text.h $height(%text, %font, %sin)
    drawrect -nrf @dm.p1.b1 $rgb(96,96,96) 0 0 0 320 320
    drawtext -nr @dm.p1.b1 0 %font %sin $calc(161 - (%text.w / 2)) $calc(161 - (%text.h / 2)) %text
    drawtext -nr @dm.p1.b1 $rgb(255,255,255) %font %sin $calc(160 - (%text.w / 2)) $calc(160 - (%text.h / 2)) %text
    drawrot -nrcb @dm.p1.b1 $rgb(96,96,96)  $calc($sin($calc(%dm.c / 16)).deg * 730) 0 0 320 320
    drawcopy -nr @dm.p1.b1 0 70 320 180 @demo 0 0 320 180
    var %table 3089,5866,8674,11700,14462,17301,20249,23120,26006,28985
    if ((%dm.c > $gettok(%table, %dm.test.index, 44)) && (%dm.test.index < 10)) {
        inc %dm.test.index
    }
    if (%dm.c > 29000) {
        drawrect -nrf @demo $rgb(35,35,35) 0 0 0 320 180
        var %font Impact
        var %size 110
        var %text BREAK!
        var %text.x $calc(160 - ($width(%text, %font, %size) / 2))
        var %text.y $calc(90 - ($height(%text, %font, %size) / 2))
        drawtext -nr @demo 0 %font %size $calc(%text.x + 1) $calc(%text.y + 1) %text
        drawtext -nr @demo $rgb(255,255,255) %font %size %text.x %text.y %text
        drawrot -nrcb @demo $rgb(35,35,35) -15 0 0 320 180
    }
    noop $dmDrawFrame(demo_2)
    if (%dm.c > 29500) {
        .signal -n dmSelectPart Rainzoom
        halt
    }
}

alias demo_rainzoom {
    ;;rotozoom out
    drawrot -cm @dm.rainzoom.b1 -5 0 0 340 200
    drawrot -fm @dm.rainzoom.b1 1 0 0 340 200
    drawcopy -m @dm.rainzoom.b1 0 0 340 200 @dm.rainzoom.b1 -15 -10 360 227

    ;;draw the dot moving in a sine-y way
    var %s $calc(($sin($calc(%dm.c / 1000)) + 1) * 10 + 5)
    var %c $calc(128 + 127 * $sin($calc(%dm.c / 300)))
    var %c2 $calc(128 + 90 * $sin($calc(%dm.c / 500)))
    var %c3 $calc(128 + 90 * $sin($calc(%dm.c / 900)))
    drawdot -r @dm.rainzoom.b1 $rgb(%c,%c2,%c3) %s $calc($sin($calc(%dm.c / 450)) * 50 + 170 + %s / 2) $calc(110 + %s / 2)

    ;;copy buffer to screen
    drawcopy @dm.rainzoom.b1 0 10 320 180 @demo 0 0


    var %table 460,920,1380,1840,2300,2760,3220,3680,4140,4600,5060,5520,5980,6440,6900,7360,7820,8280,8740,9200,9660,10120,10580,11040,11500,11960,12420,12880,13340,13800,14260,14720,15180,15640,16100,16560,17020,17480,17940,18400,18860,19320,19780,20240,20700,21160,21620,22080,22540,23000,23460,23920,24380,24840,25300,25760,26220,26680,27140,27600,28060,28520,28980
    if (%dm.c > $gettok(%table, %dm.p4.index, 44)) {
        inc %dm.p4.index
    }
    var %font Impact
    var %size 48
    var %text $gettok(%dm.p4.nametable, %dm.p4.index, 58)
    if ($chr(%text) != 160) {
        var %text.x $calc(160 - ($width(%text, %font, %size) / 2))
        var %text.y $calc(90 - ($height(%text, %font, %size) / 2))
       ; drawtext -nr @demo $rgb(255,255,255)  %font %size $calc(%text.x + 1) $calc(%text.y + 1) %text
       ; drawtext -nr @demo $rgb(255,255,255)  %font %size $calc(%text.x - 1) $calc(%text.y - 1) %text
        drawtext -nr @demo 0 %font %size %text.x %text.y %text
    }

    ;;transition out
    if (%dm.c > 14000) {
        var %cnt 0
        dinc dm.rainzoom.barout .05

        while (%cnt < 6) {
            drawrect -nrf @demo 0 0 0 $calc(%cnt * 30) 320 %dm.rainzoom.barout
            inc %cnt
        }
    }


    dmDrawFrame demo_rainzoom
    if (%dm.c > 14800) {
        signal -n dmSelectPart plasmabars
        return
    }
}

alias demo_plasmabars {
    var %c2 $calc(%dm.c / 8)
    var %ctab.1 4991232 7880960 9918737 11760423 13405766 15183467 16699028 13684944 16699028 15183467 13405766 11760423 9918737 7880960 4991232 7880960 9918737 11760423 13405766 15183467 16699028 13684944 16699028 15183467 13405766 11760423 9918737 7880960 4991232 7880960 9918737 11760423 13405766 15183467 16699028 13684944 16699028 15183467 13405766 11760423 9918737 7880960 4991232 7880960 9918737 11760423 13405766 15183467 16699028 13684944 16699028 15183467 13405766 11760423 9918737 7880960 4991232
    var %ctab.2 3932229 6947194 8853656 10630322 11620287 13071060 14522087 16238079 13684944 16238079 14522087 13071060 11620287 10630322 8853656 6947194 3932229 6947194 8853656 10630322 11620287 13071060 14522087 16238079 13684944 16238079 14522087 13071060 11620287 10630322 8853656 6947194 3932229 6947194 8853656 10630322 11620287 13071060 14522087 16238079 13684944 16238079 14522087 13071060 11620287 10630322 8853656 6947194 3932229
    var %ctab.3 1853952 2909450 4226842 5543469 7188293 9030498 10871169 13237928 13684944 13237928 10871169 9030498 7188293 5543469 4226842 2909450 1853952 2909450 4226842 5543469 7188293 9030498 10871169 13237928 13684944 13237928 10871169 9030498 7188293 5543469 4226842 2909450 1853952 2909450 4226842 5543469 7188293 9030498 10871169 13237928 13684944 13237928 10871169 9030498 7188293 5543469 4226842 2909450 1853952
    var %ctab %ctab. [ $+ [ %dm.p2.ctab.active ] ]
    var %sin.m $calc($sin(%c2).deg * 192)
    var %cos.m $calc($cos(%c2).deg * 128)
    var %c/8 $calc(%dm.c / 8)
    var %x 60
    while (%x < 120) {
        drawline -nr @demo $gettok(%ctab, $calc((($sin($calc((%x * 8))).deg * %sin.m + $sin($calc((%x * (%x / 16)) + %c/8)).deg * %cos.m) / (($cos($calc(%dm.c / 48)).deg * 16) + 24)) + (($sin(%c2).deg * 10) + 20)), 32) 1 -2 %x 322 %x
        inc %x
    }
    var %str1 ``` `` ` `` ```:Offering you:Oldschool:Newschool:Photo:Grave:Executable:Tracked:Streaming:Oldschool:Size:Newschool:Wild
    var %text1 $gettok(%str1, $calc(%dm.p2.index + 1), 58)
    ;; draw bitmap font
    drawrect -nrf @dm.p2.b1 0 0 0 0 320 180
    var %len1 $len(%text1)
    var %x1 $calc(160 - (%len1 * 13))
    var %cnt 1
    while (%cnt <= %len1) {
        var %chr $right($left(%text1, %cnt), 1)
        if ($asc(%chr) !isin 32,160) {
            drawpic -nrsc @dm.p2.b1 $calc(%x1 + ((%cnt - 1) * 26)) 60 24 24 $qt($+($scriptdirimg\chr2\,%chr,.png))
        }
        inc %cnt
    }
    var %str1 ` `` ``` `` `:these compos:Graphics:Graphics:graphy:Digger:Music:Music:Music:Demo:Restricted:Demo:Demo
    var %text1 $gettok(%str1, $calc(%dm.p2.index + 1), 58)
    ;; draw bitmap font
    var %len1 $len(%text1)
    var %x1 $calc(160 - (%len1 * 13))
    var %cnt 1
    while (%cnt <= %len1) {
        var %chr $right($left(%text1, %cnt), 1)
        if ($asc(%chr) !isin 32,160) {
            drawpic -nrsc @dm.p2.b1 $calc(%x1 + ((%cnt - 1) * 26)) 94 24 24 $qt($+($scriptdirimg\chr2\,%chr,.png))
        }
        inc %cnt
    }
    drawcopy -nt @dm.p2.b1 $rgb(255,255,255) 0 0 320 180 @demo 0 0 320 180
    var %table 1850,3700,5550,7400,9250,11100,12950,14800,16650,18500,20350,22200,24050,25900,27750
    if (%dm.c > $gettok(%table, $calc(%dm.p2.index + 0), 44)) {
        inc %dm.p2.index
        if (%dm.p2.ctab.active == 3) {
            set %dm.p2.ctab.active 0
        }
        inc %dm.p2.ctab.active
    }
    dmDrawFrame demo_plasmabars
    if (%dm.c > 22100) {
        .signal -n dmSelectPart endscroll
        return
    }
}

;; endscroller
alias demo_endscroll {
    var %cnt 1
    var %x.main $calc(($cos($calc(%dm.c / 10)).deg * 48) + 160)
    while (%cnt <= %dm.p4.bar.total) {

        var %x $calc(($cos($calc((%dm.c / 8) + (%cnt * 3))).deg * 96) + %x.main)
        var %y $calc(32 + (%cnt * 2))

        drawcopy -nt @dm.p3.b1 0 7 0 7 180 @demo %x %y 7 180

        inc %cnt
    }

    if (%dm.p4.bar.total < 32) {
        dinc dm.p4.bar.total .005
    }
    ;;-----
    var %font Impact
    var %size 20
    var %cnt $calc(1 + %dm.endscroll.offset)
    var %tot 39
    while (%cnt <= %tot) {
        var %ypos $calc(%dm.endscroll.y + (%cnt * 32))
        var %text %dm.endscroll.text. [ $+ [ %cnt ] ]
        if (%text != $null) {
            if (%ypos > -28) {
                if (%ypos < 370) {
                    var %xpos $calc(160 - ($width(%text, %font, %size) / 2))
                    ;drawtext -nr @demo 0 %font %size $calc(%xpos + 2) $calc(%ypos + 2) %text
                    drawtext -nr @demo 16777215 %font %size %xpos %ypos %text
                }
                else {
                    break
                }
            }
            else {
                inc %dm.endscroll.offset
            }
        }
        inc %cnt
    }
    if (%dm.c < 26000) {
        ddec dm.endscroll.y .05
    }
    dmDrawFrame demo_endscroll
}



;; --- ENGINE -----

alias dmDrawFrame {

    set %dm.c $calc($ticks - %dm.ticks.main)

    ;; ---- fps display -------

    /*

    inc %dm.fps.count
    if ($calc($ticks - %dm.fps.ticks.start) >= 1000) {
        set %dm.fps.current %dm.fps.count
        set %dm.fps.count 0
        set %dm.fps.ticks.start $ticks
    }
    drawtext -nrb @demo 16777215 0 console 8 0 0 fps: %dm.fps.current
    drawtext -nrb @demo 16777215 0 console 8 0 8 var: $var(%dm.*,0)

    */

    ;; ------------------------

    drawdot @demo
    if (%dm.fs == 1) {
        drawcopy @demo 0 0 %dm.screen.w %dm.screen.h @demo.fs 0 0 %dm.fs.w %dm.fs.h
    }
    drawrect -nrf @demo 0 0 0 0 %dm.screen.w %dm.screen.h
    .timerdmDrawFrame -tmh 1 0 noop $!dmStartDraw( $1 )
    set %dm.frt $calc(%dm.c - %dm.frt.start)
}


alias dmStartDraw {
    set %dm.frt.start %dm.c
    $1
}

alias dmInit {


    ;; part 2

    set %dm.test.index 1

    ;; init

    set %dm.screen.x 0
    set %dm.screen.y 0
    set %dm.screen.w 320
    set %dm.screen.h 180

    window -dak0pfbo @demo %dm.screen.x %dm.screen.y %dm.screen.w %dm.screen.h
    if ($1 == fs) {
        set %dm.fs.w $window(-1).w
        set %dm.fs.h $window(-1).h
        window -dak0pfBbo +d @demo.fs 0 0 %dm.fs.w %dm.fs.h
        set %dm.fs 1
        tokenize 32 $2-
    }
    elseif ($1 == fs2) {
        set %dm.fs.w 1280
        set %dm.fs.h 800
        window -dak0pfBbo +d @demo.fs 1920 0 %dm.fs.w %dm.fs.h
        set %dm.fs 1
        tokenize 32 $2-
    }
    set %dm.flags $1-

    set %dm.ticks.main $ticks
    set %dm.fps.ticks.start $ticks
    set %dm.fps.count 0

    set %dm.precalc.cnt 1
    window -h @dmPreloadLog
    clear @dmPreLoadLog
    dmPreload
}

alias dmPreload {
    var %read $($read($scriptdirprecalc.dss, %dm.precalc.cnt), 2)
    %read
    :error
    inc %dm.precalc.cnt

    echo @dmPreloadLog %read
    dmPrintLog

    var %tot $lines($scriptdirprecalc.dss)
    var %pct $calc((%dm.precalc.cnt / %tot) * 100)
    var %txt Precalculationizing... .. . $+($round(%pct, 0),$(%))

    var %x $calc(160 - $width(%txt, fixedsys, 18) / 2)
    drawtext -nr @demo 8421504 fixedsys 18 %x 160 %txt
    drawrect -nrfi @demo 8421504 0 5 160 $calc($+(0.,$iif(%pct < 10, $+(0,%pct), %pct)) * 305) 15
    break
    if (%dm.precalc.cnt <= %tot) {
        dmDrawFrame dmPreload
    }
    else {
        window -c @dmPreloadLog
        splay -m %dm.music
        .signal -n dmSelectPart %dm.flags
    }
}


;; ---- GLOBAL FUNCTIONS -----


alias dinc {
    inc $+(%,$1) $calc(%dm.frt * $2)
}

alias ddec {
    dec $+(%,$1) $calc(%dm.frt * $2)
}

;; ---- EVENTS ----

on *:SIGNAL:dmSelectPart: {
    set %dm.ticks.main $ticks
    set %dm.fps.ticks.start $ticks
    ;set %dm.fps.count 0
    set %dm.c 0
    set %dm.frt.start 0
    $+(demo_,$1)
}


on *:CLOSE:@demo*: {
    splay stop
    drawpic -c
    unset %dm.*
}

on *:KEYDOWN:*:32: {
    echo -s %dm.c
}

alias dmError {
    drawtext -rb @demo $rgb(255,0,0) 0 console 8 0 0 $1-
    if (%dm.fs == 1) {
        drawcopy @demo 0 0 %dm.screen.w %dm.screen.h @demo.fs 0 0 %dm.fs.w %dm.fs.h
    }
    halt
}

alias dmPrintLog {
    var %cnt 1
    var %tot 15
    while (%cnt <= %tot) {
        drawtext -nrb @demo $rgb(255,0,0) 0 console 10 0 $calc((%tot - (%cnt * 11)) + 138) $line(@dmPreloadLog, $calc($line(@dmPreloadLog, 0) - %cnt))
        inc %cnt
    }
}


;;-----------------------------------------------

alias paledit {
    var %pic $iif($1-, $1-, $sfile($scriptdir, Select image to get pallette from))
    if (%pic) {
        var %pic.w $pic(%pic).w
        var %pic.h $pic(%pic).h
        window -dak0pfbo @paledit 100 100 %pic.w %pic.h
        drawpic @paledit 0 0 %pic.w %pic.h $qt(%pic)
    }
    else {
        echo -s You fail. Select an image, kthx.
    }
}

menu @paledit {
    sclick: {
        set %paledit.r $instok(%paledit.r, $getdot(@paledit, $mouse.x, $mouse.y), 1, 32)
        echo -s palette size: $numtok(%paledit.r, 32) entries
    }
    rclick: {
        echo -s "generated" palette:
        echo -s %paledit.r
    }
}


on *:CLOSE:@paledit: {
    echo -s "generated" palette:
    echo -s %paledit.r
    unset %paledit.*
}

alias spectrum {
    dmInit $1 1
}