

getSystem().addFilePath("./data/assets/");
getSystem().addFilePath("./data/");

//getSystem().addFilePath("d:/Dropbox/evoke/Demo/assets/");
//getSystem().addFilePath("c:/dev/demo_evokeinv/data/");
//getSystem().addFilePath("c:/dev/demo_evokeinv/data/assets/");

execute(getSystem().findFile("loading.nut"));
execute(getSystem().findFile("postprocess.nut"));
execute(getSystem().findFile("ui.nut"));

loader <- Loading();
loader.render(0);

// ---------------------------------------------------

lengthDemo<-128.5;
QUALITY_SHADOWMAPSIZE <- 1024;
QUALITY_FBOSIZEX <- 2048;
QUALITY_FBOSIZEY <- 1024;


for(local i=0;i<getSystem().getNumArguments();i++)
{
    local arg = getSystem().getArgument(i);

    if(arg=="high")
    {
        QUALITY_FBOSIZEX = 4096;
        QUALITY_FBOSIZEY = 2048;
    }

    if(arg=="low")
    {
        QUALITY_FBOSIZEX = 1024;
        QUALITY_FBOSIZEY = 1024;
        QUALITY_SHADOWMAPSIZE = 512;
    }
}


scenePost <- Scene();
scenePost.addToRoot();
scenePost.clearColor=true;


baumLight<-null;
dustTetris<-null;
cloud <-null;
blackParticle <-null;
preRenderScene <- Scene();
sceneHerzOverlays<-Scene();

numLoadSteps<-22.0;

for(local i=0;i<numLoadSteps;i++)
{

    if(i==0)
    {
        sound <- SOUND();
        sound.load(getSystem().findFile("dust_evoke.mp3"))
        //sound.volume=0;
        worldParts<-World();
        scenePost.addChild(worldParts);

        cloud <- Texture();
        cloud.load(getSystem().findFile("cloud.png"));
    }

    if(i==1)
    {
        world5711<-World();
        world5711.load(getSystem().findFile("5711_anim.v3d"));
        world5711.clearDepth=false;
        world5711.getMesh("Cylinder").getMaterial().selfIllum=1.0;
        world5711.loop=false;
        preRenderScene.addChild(world5711);
        preRenderScene.forceRender();
        preRenderScene.removeChild(world5711);
    }

    if(i==2)
    {
        worldHerzchen1<-World();
        worldHerzchen1.load(getSystem().findFile("herzchen_regen1.v3d"));
        worldHerzchen1.clearDepth=false;
        worldHerzchen1.loop=true;
        //worldHerzchen1.getMesh("HerzA_0").getMaterial().selfIllum=1.0;
        worldHerzchen1.getMesh("HerzA_0").getMaterial().depthMaskDisable=1.0;

        preRenderScene.addChild(worldHerzchen1);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldHerzchen1);
    }

    if(i==3)
    {
        worldWolken<-World();
        worldWolken.load(getSystem().findFile("wolken.v3d"));
        worldWolken.clearDepth=false;
        worldWolken.getCurrentCamera().fov=36;
        worldWolken.loop=false;
        worldWolken.getMesh("wolke_1").getMaterial().wobble2=true;
        worldWolken.getMesh("wolke_quote").getMaterial().wobble2=true;
        //worldWolken.getMesh("wolke_quote").getMaterial().selfIllum=1.0;
        //worldWolken.getMesh("wolke_1").getMaterial().depthMaskDisable=true;

        preRenderScene.addChild(worldWolken);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldWolken);


        worldWolken.getMaterial("susencrusen").depthMaskDisable=true;
        worldWolken.getMaterial("susencrusen").selfIllum=1.0;
        worldWolken.getMaterial("pandur").depthMaskDisable=true;
        worldWolken.getMaterial("pandur").selfIllum=1.0;
        worldWolken.getMaterial("chunna").depthMaskDisable=true;
        worldWolken.getMaterial("chunna").selfIllum=1.0;
        worldWolken.getMesh("aech").getMaterial().depthMaskDisable=true;
        worldWolken.getMesh("aech").getMaterial().selfIllum=1.0;
        worldWolken.getMaterial("quote").depthMaskDisable=true;
        worldWolken.getMaterial("quote").selfIllum=1.0;

        dustTetris<-ParticleDust();
        dustTetris.setPosition(0,-110,-50);
        dustTetris.setArea(100,1100,200);
        dustTetris.setNumParticles(1000);
        dustTetris.setTexture(cloud);
        dustTetris.setSize(30.0);
        dustTetris.init();
        worldWolken.addChild(dustTetris);
    }

    if(i==4)
    {
        worldBaum<-World();
        worldBaum.load(getSystem().findFile("baum.v3d"));
        worldBaum.getCurrentCamera().fov=31;
        worldBaum.clearDepth=false;
        worldBaum.shadowMapSize=QUALITY_SHADOWMAPSIZE;
        worldBaum.loop=false;
        //worldBaum.speed=1.01;
        worldBaum.getMesh("leaf").getMaterial().wobble=true;
        worldBaum.getMesh("quote_box").getMaterial().wobble2=true;

        worldBaum.getMaterial("pixel_weiss").depthMaskDisable=true;
        worldBaum.getMaterial("pixel_weiss").selfIllum=1.0;

        worldBaum.getMaterial("aquakante").depthMaskDisable=true;
        worldBaum.getMaterial("aquakante").selfIllum=1.0;

        worldBaum.getMaterial("allee").depthMaskDisable=true;
        worldBaum.getMaterial("allee").selfIllum=1.0;

        worldBaum.getMaterial("quote2").depthMaskDisable=true;
        worldBaum.getMaterial("quote2").selfIllum=1.0;

        worldBaum.getMaterial("quote1").depthMaskDisable=true;
        worldBaum.getMaterial("quote1").selfIllum=1.0;



        worldBaum.getMesh("Plane_2").getMaterial().depthMaskDisable=true;

        worldBaum.getMesh("Plane_3").getMaterial().depthMaskDisable=true;
        worldBaum.getMesh("Plane_3").getMaterial().selfIllum=1.0;

        worldBaum.getMesh("Plane_4").getMaterial().depthMaskDisable=true;
        worldBaum.getMesh("Plane_4").getMaterial().selfIllum=1.0;



        worldBaum.getMesh("leaf1").getMaterial().twoSided=false;

        worldBaum.getCurrentCamera().upVectorX=0;
        worldBaum.getCurrentCamera().upVectorY=1;
        worldBaum.getCurrentCamera().upVectorZ=0;

        worldBaum.getMesh("line").getMaterial().selfIllum=1.0;
        worldBaum.getMesh("quote_box").getMaterial().selfIllum=1.0;

        worldBaum.getLight("Light").targetX=50;
        worldBaum.getLight("Light").targetY=0;//8.32045;
        worldBaum.getLight("Light").targetZ=0;

        worldBaum.removeChild(worldBaum.getNode("Light_1"));

        blackParticle <- Texture();
        blackParticle.load(getSystem().findFile("particle.png"));

        dustBaum<-ParticleDust();
        dustBaum.setPosition(0,20,0);
        dustBaum.setArea(300,100,300);
        dustBaum.setNumParticles(300);
        dustBaum.setTexture(blackParticle);
        dustBaum.setSize(2.0);
        dustBaum.init();
        worldBaum.addChild(dustBaum);

        preRenderScene.addChild(worldBaum);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldBaum);
    }

    if(i==5)
    {
        worldUntergrund<-World();

        worldUntergrund.load(getSystem().findFile("wurzelevoke.v3d"));
        worldUntergrund.getCurrentCamera().fov=34;
        worldUntergrund.clearDepth=false;
        worldUntergrund.shadowMapSize=QUALITY_SHADOWMAPSIZE;
        worldUntergrund.loop=false;

        worldUntergrund.getCurrentCamera().upVectorX=0;
        worldUntergrund.getCurrentCamera().upVectorY=1;
        worldUntergrund.getCurrentCamera().upVectorZ=0;


        worldUntergrund.getLight("Light").multiplyer=2.7;
        worldUntergrund.getLight("Light").castShadow=false;
        worldUntergrund.getLight("Light_1").multiplyer=2.7;
        worldUntergrund.getLight("omni_light").multiplyer=0.5;
        worldUntergrund.getMesh("data").getMaterial().selfIllum=1.0;

        worldUntergrund.getLight("Light_1").shadowNoise=180.0;

        animRootR<-Anim();
        animRootG<-Anim();
        animRootB<-Anim();
        worldUntergrund.getMesh("wurzelset_1").getMaterial().selfIllum=1.0;
        worldUntergrund.getMesh("wurzelset_1").getMaterial().wobble=true;
        worldUntergrund.getMesh("wurzelset_1").getMaterial().receiveShadows=false;
        worldUntergrund.getMesh("wurzelset_1").getMaterial().animColorDiffuseR=animRootR;
        worldUntergrund.getMesh("wurzelset_1").getMaterial().animColorDiffuseG=animRootG;
        worldUntergrund.getMesh("wurzelset_1").getMaterial().animColorDiffuseB=animRootB;
        animRootR.setValue(85,1);
        animRootR.setValue(90,1);
        animRootG.setValue(85,1.0);
        animRootG.setValue(90,1);
        animRootB.setValue(85,1.0);
        animRootB.setValue(90,1);


        anim2RootR<-Anim();
        anim2RootG<-Anim();
        anim2RootB<-Anim();
        worldUntergrund.getMesh("wurzelset_2").getMaterial().selfIllum=1.0;
        worldUntergrund.getMesh("wurzelset_2").getMaterial().wobble=true;
        worldUntergrund.getMesh("wurzelset_2").getMaterial().receiveShadows=false;
        worldUntergrund.getMesh("wurzelset_2").getMaterial().animColorDiffuseR=anim2RootR;
        worldUntergrund.getMesh("wurzelset_2").getMaterial().animColorDiffuseG=anim2RootG;
        worldUntergrund.getMesh("wurzelset_2").getMaterial().animColorDiffuseB=anim2RootB;
        anim2RootR.setValue(85,1);
        //anim2RootR.setValue(90,1);
        anim2RootG.setValue(85,1.0/255.0*68.0);
        //anim2RootG.setValue(90,1);
        anim2RootB.setValue(85,1.0/255.0*30.0);
        //anim2RootB.setValue(90,1);


        anim3RootR<-Anim();
        anim3RootG<-Anim();
        anim3RootB<-Anim();
        worldUntergrund.getMesh("wurzelset_3").getMaterial().selfIllum=1.0;
        worldUntergrund.getMesh("wurzelset_3").getMaterial().wobble=true;
        worldUntergrund.getMesh("wurzelset_3").getMaterial().receiveShadows=false;
        worldUntergrund.getMesh("wurzelset_3").getMaterial().animColorDiffuseR=anim3RootR;
        worldUntergrund.getMesh("wurzelset_3").getMaterial().animColorDiffuseG=anim3RootG;
        worldUntergrund.getMesh("wurzelset_3").getMaterial().animColorDiffuseB=anim3RootB;
        anim3RootR.setValue(80,1);
        anim3RootR.setValue(85,1);
        anim3RootG.setValue(80,1.0/255.0*68.0);
        anim3RootG.setValue(85,1);
        anim3RootB.setValue(80,1.0/255.0*30.0);
        anim3RootB.setValue(85,1);

        anim4RootR<-Anim();
        anim4RootG<-Anim();
        anim4RootB<-Anim();
        worldUntergrund.getMesh("wurzelset_4").getMaterial().selfIllum=1.0;
        worldUntergrund.getMesh("wurzelset_4").getMaterial().wobble=true;
        worldUntergrund.getMesh("wurzelset_4").getMaterial().receiveShadows=false;
        worldUntergrund.getMesh("wurzelset_4").getMaterial().animColorDiffuseR=anim4RootR;
        worldUntergrund.getMesh("wurzelset_4").getMaterial().animColorDiffuseG=anim4RootG;
        worldUntergrund.getMesh("wurzelset_4").getMaterial().animColorDiffuseB=anim4RootB;
        anim4RootR.setValue(85,1);
        anim4RootR.setValue(90,1);
        anim4RootG.setValue(85,1.0/255.0*68.0);
        anim4RootG.setValue(90,1);
        anim4RootB.setValue(85,1.0/255.0*30.0);
        anim4RootB.setValue(90,1);

        animRootR2<-Anim();
        animRootG2<-Anim();
        animRootB2<-Anim();
        worldUntergrund.getMesh("roots_logo").getMaterial().selfIllum=1.0;
        worldUntergrund.getMesh("roots_logo").getMaterial().receiveShadows=false;
        worldUntergrund.getMesh("roots_logo").getMaterial().animColorDiffuseR=animRootR2;
        worldUntergrund.getMesh("roots_logo").getMaterial().animColorDiffuseG=animRootG2;
        worldUntergrund.getMesh("roots_logo").getMaterial().animColorDiffuseB=animRootB2;
        animRootR2.setValue(96,1);
        animRootR2.setValue(105,1);
        animRootG2.setValue(96,1.0/255.0*68.0);
        animRootG2.setValue(105,1);
        animRootB2.setValue(96,1.0/255.0*30.0);
        animRootB2.setValue(105,1);

        preRenderScene.addChild(worldUntergrund);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldUntergrund);

        worldUntergrund.getMesh("quote").getMaterial().selfIllum=1.0;
        worldUntergrund.getMesh("quote").getMaterial().depthMaskDisable=true;
        worldUntergrund.getMesh("quote").castShadow=false;
        worldUntergrund.getMesh("quote").getMaterial().depthMaskDisable=true;
    }

    if(i==6)
    {
        worldTetris<-World();
        worldTetris.load(getSystem().findFile("tetris.v3d"));
        worldTetris.getCurrentCamera().fov=29;
        worldTetris.clearDepth=false;
        worldTetris.loop=false;

        worldTetris.getMaterial("dark grey").selfIllum=1.0;
        worldTetris.getMaterial("light grey").selfIllum=1.0;
        worldTetris.getMaterial("light grey").opacity=0.99;
        worldTetris.getMaterial("red").selfIllum=1.0;
        worldTetris.getMaterial("mint").selfIllum=1.0;
        worldTetris.getMaterial("white").selfIllum=1.0;
        worldTetris.getMaterial("pertol").selfIllum=1.0;
        worldTetris.getMaterial("pertol").depthMaskDisable=true;
        worldTetris.getMesh("pixel").getMaterial().selfIllum=1.0;
        worldTetris.getMaterial("quote").depthMaskDisable=true;
        worldTetris.getMaterial("quote").selfIllum=1.0;
        worldTetris.getMesh("snake").getMaterial().selfIllum=1.0;


        worldTetris.getMesh("tertrissteine_hinten").getMaterial().depthMaskDisable=true;
        worldTetris.getMesh("tertrissteine_mitte").getMaterial().depthMaskDisable=true;
        worldTetris.getMesh("pixel").getMaterial().depthMaskDisable=true;

        preRenderScene.addChild(worldTetris);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldTetris);

    }

    if(i==7)
    {
        worldHerzchen2<-World();
        worldHerzchen2.load(getSystem().findFile("herzchen_regen2.v3d"));
        worldHerzchen2.clearDepth=false;
        worldHerzchen2.loop=true;
        //worldHerzchen2.getMesh("HerzA_0").getMaterial().depthMaskDisable=1.0;

        preRenderScene.addChild(worldHerzchen2);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldHerzchen2);
    }

    if(i==8)
    {
        worldHerzchen3<-World();
        worldHerzchen3.load(getSystem().findFile("herzchen_regen3.v3d"));
        worldHerzchen3.clearDepth=false;
        worldHerzchen3.loop=true;
        //worldHerzchen3.getMesh("HerzA_0").getMaterial().depthMaskDisable=1.0;

        preRenderScene.addChild(worldHerzchen3);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldHerzchen3);
    }

    if(i==9)
    {
        worldHerzchen4<-World();
        worldHerzchen4.load(getSystem().findFile("herzchen_regen4.v3d"));
        worldHerzchen4.clearDepth=false;
        worldHerzchen4.loop=true;
        //worldHerzchen4.getMesh("HerzA_0").getMaterial().depthMaskDisable=1.0;

        preRenderScene.addChild(worldHerzchen4);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldHerzchen4);
    }

    if(i==10)
    {
        worldHerzchen5<-World();
        worldHerzchen5.load(getSystem().findFile("herzchen_regen5.v3d"));
        worldHerzchen5.clearDepth=false;
        worldHerzchen5.loop=true;
       // worldHerzchen5.getMesh("HerzA_0").getMaterial().depthMaskDisable=1.0;

        preRenderScene.addChild(worldHerzchen5);
        preRenderScene.forceRender();
        preRenderScene.removeChild(worldHerzchen5);

        local herzchenStart=6;
        sceneHerzOverlays.addChild(worldHerzchen1);
        worldHerzchen1.startTime=herzchenStart;

        sceneHerzOverlays.addChild(worldHerzchen2);
        worldHerzchen2.startTime=herzchenStart+4;

        sceneHerzOverlays.addChild(worldHerzchen3);
        worldHerzchen3.startTime=herzchenStart+4*2;

        sceneHerzOverlays.addChild(worldHerzchen4);
        worldHerzchen4.startTime=herzchenStart+4*3;

        sceneHerzOverlays.addChild(worldHerzchen5);
        worldHerzchen5.startTime=herzchenStart+4*4;

        worldHerzchen1.animLength = 4*5;
        worldHerzchen2.animLength = 4*5;
        worldHerzchen3.animLength = 4*5;
        worldHerzchen4.animLength = 4*5;
        worldHerzchen5.animLength = 4*5;
    }

    if(i==11)
    {
        worldWipeLines<-World();
        worldWipeLines.load(getSystem().findFile("wipe_lines.v3d"));
        worldWipeLines.clearDepth=false;
        worldWipeLines.getCurrentCamera().fov=20;
        worldWipeLines.loop=false;
        worldWipeLines.startTime=4.4;
    }

    if(i==12)
    {
        worldWipeWolken<-World();
        worldWipeWolken.load(getSystem().findFile("wolken_wipe.v3d"));
        worldWipeWolken.clearDepth=false;
        worldWipeWolken.getCurrentCamera().fov=31;
        worldWipeWolken.loop=false;
        worldWipeWolken.startTime=4.4;
    }

    loader.render(i/numLoadSteps);
}


loader.render(1.0);

// start

post <- ProstProcess();
fbo <- FBO();
fbo.init(QUALITY_FBOSIZEX,QUALITY_FBOSIZEY,2);

post.animFFT.setSound(sound);
post.setTexture(fbo.getTextureColor());
post.setTextureDepth(fbo.getTextureDepth());

scenePost.addChild(post.world);
scenePost.addChild(fbo);



function part5711()
{
    fbo.clear();
    fbo.addChild(world5711);
    fbo.addChild(worldWipeLines);
}

function partWolken()
{
    fbo.clear();
    fbo.addChild(sceneHerzOverlays);
    fbo.addChild(world5711);

    fbo.addChild(worldWolken);

    fbo.addChild(worldWipeLines);
    fbo.addChild(worldWipeLines);
}

function partBaum()
{
    fbo.clear();
    fbo.addChild(sceneHerzOverlays);
    fbo.addChild(worldTetris);
    fbo.addChild(worldBaum);
    worldBaum.setCameraNum(0);
    worldBaum.startTime=worldBaum_startTime;
}

function partUntergrund()
{
    fbo.clear();
    fbo.addChild(sceneHerzOverlays);
    fbo.addChild(worldBaum);
    fbo.addChild(worldUntergrund);
}

function partTetris()
{
    fbo.clear();
    fbo.addChild(sceneHerzOverlays);
    fbo.addChild(worldWolken);
    fbo.addChild(worldTetris);
    fbo.addChild(worldWipeWolken);
}

function partEvoke()
{
    fbo.clear();
    fbo.addChild(worldEvoke);
}




enum PARTS
{
    PART_5711,
    PART_WOLKEN,
    PART_WOLKEN_REMOVE_5711,
    PART_BAUM,
    PART_BAUM_TOTALE,
    PART_UNTERGRUND,
    PART_TETRIS,
    PART_EVOKE,
    PART_WIPELINES,
    PART_UNTERGRUND_REMOVE_BAUM,
    PART_EXIT,
    NUM_PARTS
}

currentPart <- PARTS.PART_5711;


function partChange(event)
{
    //print("old currentpart: "+currentPart);
    //print("NEXT currentpart: "+event.keyValue);

    if(currentPart!=event.keyValue)
    {
        currentPart=event.keyValue;

        if(currentPart==PARTS.PART_5711) part5711();
        if(currentPart==PARTS.PART_WOLKEN) partWolken();
        if(currentPart==PARTS.PART_BAUM) partBaum();

        if(currentPart==PARTS.PART_EXIT){ getSystem().exit(); }

        if(currentPart==PARTS.PART_UNTERGRUND) partUntergrund();
        if(currentPart==PARTS.PART_TETRIS) partTetris();
        if(currentPart==PARTS.PART_EVOKE) partEvoke();

        if(currentPart==PARTS.PART_UNTERGRUND_REMOVE_BAUM) { fbo.removeChild(worldBaum); }
        if(currentPart==PARTS.PART_WOLKEN_REMOVE_5711) { fbo.removeChild(world5711); }

        //print("NOW currentpart: "+currentPart);
    }
}

// ----------------------------------------------------------------------------------

worldHerzchen1.startTime=6.0;
worldTetris.startTime=27.0;
worldWipeWolken.startTime=worldTetris.startTime+3.8;
worldWolken.startTime=6.0;

worldBaum_startTime<-48.0;
worldBaumTotale_startTime<-63.0;
worldUntergrund.startTime=75.4;




parts <- Anim();
parts.setValue(0                            ,PARTS.PART_5711);
parts.setValue(worldWolken.startTime        ,PARTS.PART_WOLKEN);
parts.setValue(7.5                          ,PARTS.PART_WOLKEN_REMOVE_5711);


parts.setValue(worldTetris.startTime        ,PARTS.PART_TETRIS);
parts.setValue(worldBaum_startTime          ,PARTS.PART_BAUM);
parts.setValue(worldBaumTotale_startTime     ,PARTS.PART_BAUM_TOTALE);



parts.setValue(worldUntergrund.startTime   ,PARTS.PART_UNTERGRUND);
parts.setValue(worldUntergrund.startTime+5.0    ,PARTS.PART_UNTERGRUND_REMOVE_BAUM);

parts.setValue(lengthDemo   ,PARTS.PART_EXIT);


//parts.setValue(100   ,PARTS.PART_BAUM_TOTALE);
//parts.setValue(120   ,PARTS.PART_EVOKE);



animClearColorR<-Anim();
animClearColorR.setValue(0    ,0.9);
animClearColorR.setValue(77   ,0.5);
animClearColorR.setValue(79.9   ,0.5);
animClearColorR.setValue(79.99   ,0);
animClearColorR.setValue(90   ,0);

animClearColorG<-Anim();
animClearColorG.setValue(0    ,0.9);
animClearColorG.setValue(77   ,0.5);
animClearColorG.setValue(79.9   ,0.5);
animClearColorG.setValue(79.99   ,0);
animClearColorG.setValue(90   ,0);

animClearColorB<-Anim();
animClearColorB.setValue(0    ,0.9);
animClearColorB.setValue(77   ,0.5);
animClearColorB.setValue(79.9   ,0.5);
animClearColorB.setValue(79.99   ,0);
animClearColorB.setValue(90   ,0);

scenePost.animClearColorR=animClearColorR;
scenePost.animClearColorG=animClearColorG;
scenePost.animClearColorB=animClearColorB;

// ----------------------------------------------------------------------------------

parts.setCallBackCurrentKeyChanged(partChange);

dummy <- EmptyNode();
dummy.animPosX=parts;
worldParts.addChild(dummy);

gui<-ui();
gui.toggle();

getSystem().setGlobalTime(0);
part5711();
sound.play();
