#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>
#include "mesh3d.h"
#include "shader.h"
#include "texture.h"
#include "sky.h"

Mesh3D *sky;
GLuint nightskytext;

GLuint skyshaders[2];
GLuint skyprg;

void initSky(){
   sky          = loadOBJ("data/sky.obj");
   nightskytext = loadPNGTexture("data/texture/night_sky.png");

   skyshaders[0] = loadShader(GL_VERTEX_SHADER, "shaders/sky.vs");
   skyshaders[1] = loadShader(GL_FRAGMENT_SHADER, "shaders/sky.fs");
   skyprg        = createProgram(2, skyshaders);

   glBindVertexArray(sky->vao);
   bindVarToBuff(skyprg, "vertex", sky->vbo[MESHVERTEXINDEX], 3);
   bindVarToBuff(skyprg, "normal", sky->vbo[MESHNORMALINDEX], 3);
   bindVarToBuff(skyprg, "tcoord", sky->vbo[MESHTEXINDEX], 2);

}

void drawSky(float *pmatrix, float *camera, float size){
   GLint loc;

   glUseProgram(skyprg);

   loc = glGetUniformLocation(skyprg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, pmatrix);

   loc = glGetUniformLocation(skyprg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);

   loc = glGetUniformLocation(skyprg, "size");
   glUniform1f(loc, size);

   loc = glGetUniformLocation(skyprg, "image");
   glActiveTexture(GL_TEXTURE0);
   glBindTexture(GL_TEXTURE_2D, nightskytext);
   glUniform1i(loc, 0);

   drawMesh3D(sky);
}

void freeSky(){
   freeMesh3D(sky);
}
