#version 150

layout (triangles) in;
layout (triangle_strip, max_vertices = 9) out;

uniform float time;
uniform mat4 pmatrix;
uniform mat4 camera;
uniform int type;

in vec3 nvec[3];
out vec3 vnorm;

void main(void){

   mat4 trans = mat4(1.0);

   for(int j = 0; j < 3; j++){
      float offset = 3.141592 / 180.0 * (j * 120);
      if(type == 1){
         trans[3][0] = sin(time / 10.0 + offset) * 100.0;
         trans[3][2] = cos(time / 10.0 + offset) * 200.0;
         trans[3][1] = 0.0;
      }
      else if(type == 2){
         trans[3][0] = sin(time + offset) * 80.0;
         trans[3][1] = cos(time + offset) * 200.0;
         trans[3][2] = -100.0;
      }
      else {
         trans[3][0] = sin(time + offset) * 100.0;
         trans[3][1] = cos(time + offset) * 200.0;
         trans[3][2] = -200.0 - sin(time) * 200.0;
      }

      for(int i = 0; i < gl_in.length(); i++){
         gl_Position = pmatrix * trans * camera * gl_in[i].gl_Position;
         vnorm = nvec[i];
         EmitVertex();
      }

      EndPrimitive();
   }

}
