#version 150

in vec2 texcoord;
out vec4 FragColor;

uniform sampler2D color1;
uniform sampler2D color2;
uniform sampler2D depth;
uniform sampler2D text;
uniform float time;

const float weight[8] = float[8](0.1994711402, 0.1760326634, 0.1209853623, 0.0647587978, 0.0269954833, 0.0087641502, 0.0022159242, 0.0004363413);

vec4 gauss(int kernelsize){
   vec4 sum = texture(color1, texcoord) * weight[0];
   ivec2 size = textureSize(color1, 0);
   float dx = 1.0 / size.x;
   float dy = 1.0 / size.y;
   for(int i = 1; i < kernelsize; i++){
      sum += texture(color1, texcoord + vec2(0.0, i)*dx) * weight[i];
      sum += texture(color1, texcoord - vec2(0.0, i)*dx) * weight[i];
      sum += texture(color1, texcoord + vec2(i, 0.0)*dy) * weight[i];
      sum += texture(color1, texcoord - vec2(i, 0.0)*dy) * weight[i];
   }

   return(sum);
}

float vignette(){
   float d = distance(texcoord, vec2(0.5, 0.5));
   return(smoothstep(1.0, 0.0, d));
}

void main(void){
   vec4 firstpass = gauss(2);
   vec4 layer = texture2D(text, texcoord);
   FragColor = mix(firstpass, layer, layer.a) * vignette();
}
