#version 150

layout (triangles) in;
layout (triangle_strip, max_vertices = 63) out;

in vec2 texc[3];
in vec3 vertexcolor[3];

uniform mat4 pmatrix;
uniform mat4 camera;

out vec2 tc;
out vec3 vc;

const float pi = 3.1415926535;

void main(){

   /* atom in the centre */
   for(int j = 0; j < gl_in.length(); j++){
      gl_Position = pmatrix * camera * gl_in[j].gl_Position;
      tc = texc[j];
      vc = vertexcolor[j];
      EmitVertex();
   }
   EndPrimitive();

   /* additional atoms */
   for(float i = -pi/2.0; i < pi/2.0; i += pi/20.0){
      for(int j = 0; j < gl_in.length(); j++){
         vec4 pos = gl_in[j].gl_Position;
         pos.x = pos.x + sin(i) * -30.0;
         pos.y = pos.y + cos(i * 54.5) * 30.0;
         pos.z = pos.z + cos(i) * -30.0;
         gl_Position = pmatrix * camera * pos;
         tc = texc[j];
         vc = vertexcolor[j];
         EmitVertex();
      }
      EndPrimitive();
   }
}
