uniform sampler2D InputMap;
varying vec2 uv;
uniform float xPixelOffset;
uniform float yPixelOffset;
uniform float Threshold;
uniform float Gain;
uniform float Saturation;
void main(void)
{
float w, w_total = 0.;
vec4 color = vec4(0);
for (float i = -3.; i < 4.; i+=0.5)
{
vec4 sample = texture2D(InputMap, uv + vec2(i * xPixelOffset*4., i * yPixelOffset*4.));
sample = clamp((sample - Threshold) * Gain, 0., Saturation);
w_total += w = exp(-i*i * 0.4);
color += max(sample, 0.) * w;
}
gl_FragColor = color / w_total;
gl_FragColor.a = 1.;
}