#version 150 compatibility
#extension GL_EXT_gpu_shader4: require
uniform float     Time;
uniform float     Trigger;
uniform vec3      Resolution;
uniform int       ActiveCount;
uniform int       StartOffset;
uniform vec3      EmitterColor;
uniform float     EmitterSpeed;
uniform vec3      EmitterPos;
uniform vec3      FFOffset;
uniform float     ShapeSelector;
uniform float     ShapeScale;
uniform float     AnimationSpeed;
uniform sampler2D InPos;
uniform sampler2D InSpd;
uniform sampler2D InColor;
in vec2 uv;
float rand(vec2 co, float f)
{
return fract(sin(dot(co.xy ,vec2(12.9898,78.233) * f)) * 43758.5453) - 0.5;
}
float sdSphere( vec3 p, float s )
{
return length(p)-s;
}
float sdPlane( vec3 p, vec4 n )
{
return dot(p,n.xyz) + n.w;
}
float sdCylinder( vec3 p, vec3 c )
{
return length(p.xz-c.xy)-c.z;
}
float sdBox( vec3 p, vec3 b )
{
vec3  di = abs(p) - b;
float mc = max(di.x, max(di.y, di.z));
return min(mc,length(max(di,0.0)));
}
float opC( float d1, float d2 )
{
return min(d1,d2);
}
float opI( float d1, float d2 )
{
return max(d1,d2);
}
float opS( float d1, float d2 )
{
return max(-d1,d2);
}
float DistEqu(int Shape, vec3 Pos)
{
float Radius = 300;
float Height = 2000.;
float HeightOfs = -1800.;
Pos += FFOffset;
Pos /= ShapeScale;
switch (Shape)
{
case 0: return sdCylinder(Pos , vec3(0, 0, 80));
case 1: return opI(opC(
opC(sdCylinder(Pos.xzy,                           vec3(0, 0, Radius)),
sdCylinder(Pos.xzy - vec3(160. * 8.66 * 2., 0, +160. * 10.),  vec3(0, 0, Radius))),
sdCylinder(Pos.xzy - vec3(160. * 8.66 * 2., 0, -160. * 10.),  vec3(0, 0, Radius))),
sdBox(Pos.xzy - vec3(0, HeightOfs, 0), vec3(4000, Height, 4000)));
case 2: return opI(sdBox(Pos, vec3(400, 400, 400)),
opC(sdCylinder(Pos.yxz, vec3(0, 0, 80)),
sdCylinder(Pos,     vec3(0, 0, 80))));
case 3: return opC(sdBox(Pos - vec3(-300, 0, 0), vec3(100,100,100)),
sdBox(Pos - vec3(300, 0, 0), vec3(100,100,100)));
case 4: return opC(opC(sdBox(Pos - vec3(-300, -300, 0), vec3(100,100,100)),
sdBox(Pos - vec3(300, -300, 0), vec3(100,100,100))),
opC(sdBox(Pos - vec3(-300, 300, 0), vec3(100,100,100)),
sdBox(Pos - vec3(300, 300, 0), vec3(100,100,100))));
case 5: return sdCylinder(Pos  , vec3(00, 0, 80));
case 6: return sdSphere(vec3(Pos.x, Pos.y, Pos.z), 500.);
case 7: return sdBox(Pos, vec3(500));
case 8: return sdBox(vec3(mod(60000. + Pos.x, 600.) - 300., mod(60000. + Pos.y, 600.) - 300., mod(60000. + Pos.z, 600.) - 300.), vec3(100,100,100));
case 9: return sdSphere(vec3(mod(60000. + Pos.x, 600.) - 300., mod(60000. + Pos.y, 600.) - 300., mod(60000. + Pos.z, 600.) - 300.), 100.);
case 10: return sdSphere(vec3(Pos.x, Pos.y, Pos.z), 1500.);
case 11: return sdCylinder(vec3(mod(60000. + Pos.x, 600.) - 300., mod(60000. + Pos.y, 600.) - 300., mod(60000. + Pos.z, 600.) - 300.) , vec3(00, 0, 80));
case 12: return opI(sdBox(Pos, vec3(1400, 1400, 1400)),
opC(opC(sdCylinder(Pos.yxz, vec3(0, 0, 200)),
sdCylinder(Pos,     vec3(0, 0, 200))),
sdCylinder(Pos.xzy, vec3(0, 0, 200))));
}
return 0.0;
}
float DistFunc(vec3 Pos)
{
return DistEqu(int(ShapeSelector), Pos);
}
void main(void)
{
ivec2 iuv = ivec2(gl_FragCoord.xy);
int ParticalIndex = (256*256*4 - StartOffset + (iuv.x + iuv.y * int(.5 + Resolution.x))) % (256*256);
vec4 PosActive = texelFetch(InPos, iuv, 0);
vec3 Pos = PosActive.xyz;
if ((PosActive.w == 0.) && (ParticalIndex < ActiveCount))
{
vec3 startSpd = normalize(vec3(rand(uv*100., 33.22), rand(uv*100., 22.22), rand(uv*100., 11.22)));
gl_FragData[0] = vec4(EmitterPos.x + rand(uv*100., 10.) * 0.,
EmitterPos.y + rand(uv*100., 11.) * 200.,
EmitterPos.z + rand(uv*100., 12.) * 0., 1.0);
gl_FragData[1] = vec4(startSpd * EmitterSpeed, 1.);
gl_FragData[2] = vec4(EmitterColor, 1.);
return;
}
if ((PosActive.w != 0.) && (ParticalIndex >= ActiveCount))
{
gl_FragData[0] = vec4(0);
gl_FragData[1] = vec4(0);
gl_FragData[2] = vec4(0);
return;
}
if (PosActive.w == 0.)
{
gl_FragData[0] = vec4(0);
gl_FragData[1] = vec4(0);
gl_FragData[2] = vec4(0);
return;
}
vec3 Color = texelFetch(InColor, iuv, 0).rgb;
Color = mix(Color, vec3(0.75, 0.75, 0.57), 0.01);
vec3 ForceVector = vec3(0);
float distance0 = DistFunc(Pos);
float distanceX = DistFunc(Pos + vec3(0.1, 0.0, 0.0));
float distanceY = DistFunc(Pos + vec3(0.0, 0.1, 0.0));
float distanceZ = DistFunc(Pos + vec3(0.0, 0.0, 0.1));
ForceVector = normalize(vec3(distance0) - vec3(distanceX, distanceY, distanceZ)) * distance0;
if (distance0 == 0.)
ForceVector = vec3(0);
vec3 speed = texelFetch(InSpd, iuv, 0).xyz;
if (dot(normalize(ForceVector), speed) < 0.)
speed *= 1. / (1. + length(ForceVector)*0.0005);
if (length(ForceVector) != 0.)
{
vec3 verticalSpeed = dot(speed, normalize(ForceVector)) * normalize(ForceVector);
vec3 surfaceSpeed  = speed - verticalSpeed;
float MinSpeed = 200.;
float SpeedLen = length(surfaceSpeed);
if (SpeedLen < MinSpeed)
surfaceSpeed *= MinSpeed / SpeedLen;
speed = verticalSpeed + surfaceSpeed;
}
speed += ForceVector * 0.01 * AnimationSpeed;
if (Trigger == 1.)
{
float angle = dot(normalize(speed), vec3(1, 0, 0));
if ((angle > 0.94) && (length(ForceVector) < 40.) && (Pos.z < 0.))
{
speed *= 15;
Color = vec3(0.2, 10.2, 0.2);
}
}
if (Trigger == 2.)
{
speed *= 8.;
}
if (Trigger == 4.)
{
speed *= -2.;
}
if (Trigger == 5.)
{
speed *= -2.;
}
if (Trigger == 3.)
{
float angle = dot(normalize(speed), vec3(1, 0, 0));
if ((angle > 0.94) && (length(ForceVector) < 40.) && (Pos.z > 0.))
{
speed *= 15.;
Color = vec3(10.2, 0.2, 0.2);
}
}
if (Trigger == 6.)
{
speed *= 2000.;
}
Pos += speed * 0.0008 * AnimationSpeed;
gl_FragData[0] = vec4(Pos, 1.0);
gl_FragData[1] = vec4(speed, 1.0);
gl_FragData[2] = vec4(Color, 1.0);
}