#extension GL_EXT_gpu_shader4: require
#define FXAA_QUALITY__SUBPIX (3.0/4.0)
#define FXAA_QUALITY__EDGE_THRESHOLD (1.0/6.0)
#define FXAA_QUALITY__EDGE_THRESHOLD_MIN (1.0/12.0)
uniform sampler2D Input;
varying vec2 uv;
vec4 FxaaPixelShader(
vec2 pos,
sampler2D tex,
vec2 rcpFrame)
{
vec2 posM;
posM.x = pos.x;
posM.y = pos.y;
vec4 rgbyM = textureLod(tex, posM, 0.);
#define lumaM rgbyM.w
float lumaS = textureLodOffset(tex, posM, 0., ivec2( 0, 1)).w;
float lumaE = textureLodOffset(tex, posM, 0., ivec2( 1, 0)).w;
float lumaN = textureLodOffset(tex, posM, 0., ivec2( 0,-1)).w;
float lumaW = textureLodOffset(tex, posM, 0., ivec2(-1, 0)).w;
float maxSM  = max(lumaS, lumaM);
float minSM  = min(lumaS, lumaM);
float maxESM = max(lumaE, maxSM);
float minESM = min(lumaE, minSM);
float maxWN  = max(lumaN, lumaW);
float minWN  = min(lumaN, lumaW);
float rangeMax = max(maxWN, maxESM);
float rangeMin = min(minWN, minESM);
float rangeMaxScaled = rangeMax * FXAA_QUALITY__EDGE_THRESHOLD;
float range = rangeMax - rangeMin;
float rangeMaxClamped = max(FXAA_QUALITY__EDGE_THRESHOLD_MIN, rangeMaxScaled);
bool earlyExit = range < rangeMaxClamped;
if(earlyExit)
#if (FXAA_DISCARD == 1)
discard;
#else
return rgbyM;
#endif
float lumaNW = textureLodOffset(tex, posM, 0., ivec2(-1,-1)).w;
float lumaSE = textureLodOffset(tex, posM, 0., ivec2( 1, 1)).w;
float lumaNE = textureLodOffset(tex, posM, 0., ivec2( 1,-1)).w;
float lumaSW = textureLodOffset(tex, posM, 0., ivec2(-1, 1)).w;
float lumaNS = lumaN + lumaS;
float lumaWE = lumaW + lumaE;
float subpixRcpRange = 1.0/range;
float subpixNSWE = lumaNS + lumaWE;
float edgeHorz1 = (-2.0 * lumaM) + lumaNS;
float edgeVert1 = (-2.0 * lumaM) + lumaWE;
float lumaNESE = lumaNE + lumaSE;
float lumaNWNE = lumaNW + lumaNE;
float edgeHorz2 = (-2.0 * lumaE) + lumaNESE;
float edgeVert2 = (-2.0 * lumaN) + lumaNWNE;
float lumaNWSW = lumaNW + lumaSW;
float lumaSWSE = lumaSW + lumaSE;
float edgeHorz4 = (abs(edgeHorz1) * 2.0) + abs(edgeHorz2);
float edgeVert4 = (abs(edgeVert1) * 2.0) + abs(edgeVert2);
float edgeHorz3 = (-2.0 * lumaW) + lumaNWSW;
float edgeVert3 = (-2.0 * lumaS) + lumaSWSE;
float edgeHorz = abs(edgeHorz3) + edgeHorz4;
float edgeVert = abs(edgeVert3) + edgeVert4;
float subpixNWSWNESE = lumaNWSW + lumaNESE;
float lengthSign = rcpFrame.x;
bool horzSpan = edgeHorz >= edgeVert;
float subpixA = subpixNSWE * 2.0 + subpixNWSWNESE;
if(!horzSpan) lumaN = lumaW;
if(!horzSpan) lumaS = lumaE;
if(horzSpan) lengthSign = rcpFrame.y;
float subpixB = (subpixA * (1.0/12.0)) - lumaM;
float gradientN = lumaN - lumaM;
float gradientS = lumaS - lumaM;
float lumaNN = lumaN + lumaM;
float lumaSS = lumaS + lumaM;
bool pairN = abs(gradientN) >= abs(gradientS);
float gradient = max(abs(gradientN), abs(gradientS));
if(pairN) lengthSign = -lengthSign;
float subpixC = clamp(abs(subpixB) * subpixRcpRange, 0.0, 1.0);
vec2 posB;
posB.x = posM.x;
posB.y = posM.y;
vec2 offNP;
offNP.x = (!horzSpan) ? 0.0 : rcpFrame.x;
offNP.y = ( horzSpan) ? 0.0 : rcpFrame.y;
if(!horzSpan) posB.x += lengthSign * 0.5;
if( horzSpan) posB.y += lengthSign * 0.5;
vec2 posN;
posN.x = posB.x - offNP.x;
posN.y = posB.y - offNP.y;
vec2 posP;
posP.x = posB.x + offNP.x;
posP.y = posB.y + offNP.y;
float subpixD = ((-2.0)*subpixC) + 3.0;
float lumaEndN = textureLod(tex, posN, 0.).w;
float subpixE = subpixC * subpixC;
float lumaEndP = textureLod(tex, posP, 0.).w;
if(!pairN) lumaNN = lumaSS;
float gradientScaled = gradient * 1.0/4.0;
float lumaMM = lumaM - lumaNN * 0.5;
float subpixF = subpixD * subpixE;
bool lumaMLTZero = lumaMM < 0.0;
lumaEndN -= lumaNN * 0.5;
lumaEndP -= lumaNN * 0.5;
bool doneN = abs(lumaEndN) >= gradientScaled;
bool doneP = abs(lumaEndP) >= gradientScaled;
if(!doneN) posN.x -= offNP.x * 1.5;
if(!doneN) posN.y -= offNP.y * 1.5;
bool doneNP = (!doneN) || (!doneP);
if(!doneP) posP.x += offNP.x * 1.5;
if(!doneP) posP.y += offNP.y * 1.5;
if(doneNP)
{
if(!doneN) lumaEndN = textureLod(tex, posN.xy, 0.).w;
if(!doneP) lumaEndP = textureLod(tex, posP.xy, 0.).w;
if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
doneN = abs(lumaEndN) >= gradientScaled;
doneP = abs(lumaEndP) >= gradientScaled;
if(!doneN) posN.x -= offNP.x * 2.0;
if(!doneN) posN.y -= offNP.y * 2.0;
doneNP = (!doneN) || (!doneP);
if(!doneP) posP.x += offNP.x * 2.0;
if(!doneP) posP.y += offNP.y * 2.0;
if(doneNP)
{
if(!doneN) lumaEndN = textureLod(tex, posN.xy, 0.).w;
if(!doneP) lumaEndP = textureLod(tex, posP.xy, 0.).w;
if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
doneN = abs(lumaEndN) >= gradientScaled;
doneP = abs(lumaEndP) >= gradientScaled;
if(!doneN) posN.x -= offNP.x * 2.0;
if(!doneN) posN.y -= offNP.y * 2.0;
doneNP = (!doneN) || (!doneP);
if(!doneP) posP.x += offNP.x * 2.0;
if(!doneP) posP.y += offNP.y * 2.0;
if(doneNP)
{
if(!doneN) lumaEndN = textureLod(tex, posN.xy, 0.).w;
if(!doneP) lumaEndP = textureLod(tex, posP.xy, 0.).w;
if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
doneN = abs(lumaEndN) >= gradientScaled;
doneP = abs(lumaEndP) >= gradientScaled;
if(!doneN) posN.x -= offNP.x * 4.0;
if(!doneN) posN.y -= offNP.y * 4.0;
doneNP = (!doneN) || (!doneP);
if(!doneP) posP.x += offNP.x * 4.0;
if(!doneP) posP.y += offNP.y * 4.0;
if(doneNP)
{
if(!doneN) lumaEndN = textureLod(tex, posN.xy, 0.).w;
if(!doneP) lumaEndP = textureLod(tex, posP.xy, 0.).w;
if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
doneN = abs(lumaEndN) >= gradientScaled;
doneP = abs(lumaEndP) >= gradientScaled;
if(!doneN) posN.x -= offNP.x * 2.0;
if(!doneN) posN.y -= offNP.y * 2.0;
if(!doneP) posP.x += offNP.x * 2.0;
if(!doneP) posP.y += offNP.y * 2.0;
}
}
}
}
float dstN = posM.x - posN.x;
float dstP = posP.x - posM.x;
if(!horzSpan) dstN = posM.y - posN.y;
if(!horzSpan) dstP = posP.y - posM.y;
bool goodSpanN = (lumaEndN < 0.0) != lumaMLTZero;
float spanLength = (dstP + dstN);
bool goodSpanP = (lumaEndP < 0.0) != lumaMLTZero;
float spanLengthRcp = 1.0/spanLength;
bool directionN = dstN < dstP;
float dst = min(dstN, dstP);
bool goodSpan = directionN ? goodSpanN : goodSpanP;
float subpixG = subpixF * subpixF;
float pixelOffset = (dst * (-spanLengthRcp)) + 0.5;
float subpixH = subpixG * FXAA_QUALITY__SUBPIX;
float pixelOffsetGood = goodSpan ? pixelOffset : 0.0;
float pixelOffsetSubpix = max(pixelOffsetGood, subpixH);
if(!horzSpan) posM.x += pixelOffsetSubpix * lengthSign;
if( horzSpan) posM.y += pixelOffsetSubpix * lengthSign;
return textureLod(tex, posM, 0.);
}
void main()
{
gl_FragData[0] = FxaaPixelShader(uv, Input, vec2(1./800., 1./600.));
}