#extension GL_EXT_gpu_shader4: require
varying float out_MatIndex;
varying vec3  out_normal;
varying vec3  out_vpos;
varying vec3  out_diffuse;
varying vec3  out_emission;
varying vec4  out_hpos;
varying vec2  out_texcoord;
uniform int   EffectSelector;
uniform float EffectAmount;
float rand(vec2 co, float f)
{
return fract(sin(dot(co.xy ,vec2(12.9898,78.233) * f)) * 43758.5453);
}
void main()
{
out_diffuse  = gl_FrontMaterial.diffuse.rgb * gl_FrontMaterial.diffuse.a ;
out_emission = gl_FrontMaterial.emission.rgb * gl_FrontMaterial.emission.a ;
out_MatIndex = gl_FrontMaterial.ambient.a;
float lightFactor = (0.2 + 0.2 * (rand(vec2(gl_InstanceID), 2.) - .5)) * clamp(1. - float(gl_InstanceID) / 3500., 0., 1.);
out_diffuse = vec3(lightFactor);
vec4 vertex = gl_Vertex;
float Angle = rand(vec2(gl_InstanceID, sin(float(gl_InstanceID) * 0.2)), 2.) * 8. - 4.;
float HorzShift = 3. + float(gl_InstanceID) / 100.;
if (gl_InstanceID % 11 == 0)
out_emission += vec3(lightFactor * 0.9);
if ((gl_InstanceID / 200) % 2 == 0)
Angle += EffectAmount * .2;
else
Angle -= EffectAmount * .2;
vertex.xyz *= clamp(float(gl_InstanceID) / 400., 2., 8.) * (.5 + rand(vec2(gl_InstanceID), 2.)*3.) * .3;
vertex.xy += vec2(sin(Angle) * HorzShift,
cos(Angle) * HorzShift);
vertex.z += float(gl_InstanceID) * .1 - 50.;
out_vpos = (gl_ModelViewMatrix * vec4(vertex.xyz, 1.)).xyz;
out_normal = gl_Normal;
out_normal = normalize(gl_NormalMatrix * out_normal);
out_hpos = gl_Position = gl_ModelViewProjectionMatrix * vertex;
out_texcoord = gl_MultiTexCoord0.xy;
}