/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkLoadBehaviour;
import jogamp.opengl.util.pngj.chunks.ChunkPredicate;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSPLT;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;
import jogamp.opengl.util.pngj.chunks.PngChunkUNKNOWN;

public class ChunkHelper {
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";
    public static final byte[] b_IHDR = ChunkHelper.toBytes("IHDR");
    public static final byte[] b_PLTE = ChunkHelper.toBytes("PLTE");
    public static final byte[] b_IDAT = ChunkHelper.toBytes("IDAT");
    public static final byte[] b_IEND = ChunkHelper.toBytes("IEND");
    public static final String cHRM = "cHRM";
    public static final String gAMA = "gAMA";
    public static final String iCCP = "iCCP";
    public static final String sBIT = "sBIT";
    public static final String sRGB = "sRGB";
    public static final String bKGD = "bKGD";
    public static final String hIST = "hIST";
    public static final String tRNS = "tRNS";
    public static final String pHYs = "pHYs";
    public static final String sPLT = "sPLT";
    public static final String tIME = "tIME";
    public static final String iTXt = "iTXt";
    public static final String tEXt = "tEXt";
    public static final String zTXt = "zTXt";

    public static byte[] toBytes(String string) {
        return string.getBytes(PngHelperInternal.charsetLatin1);
    }

    public static String toString(byte[] byArray) {
        return new String(byArray, PngHelperInternal.charsetLatin1);
    }

    public static String toString(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, PngHelperInternal.charsetLatin1);
    }

    public static byte[] toBytesUTF8(String string) {
        return string.getBytes(PngHelperInternal.charsetUTF8);
    }

    public static String toStringUTF8(byte[] byArray) {
        return new String(byArray, PngHelperInternal.charsetUTF8);
    }

    public static String toStringUTF8(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, PngHelperInternal.charsetUTF8);
    }

    public static boolean isCritical(String string) {
        return Character.isUpperCase(string.charAt(0));
    }

    public static boolean isPublic(String string) {
        return Character.isUpperCase(string.charAt(1));
    }

    public static boolean isSafeToCopy(String string) {
        return !Character.isUpperCase(string.charAt(3));
    }

    public static boolean isUnknown(PngChunk pngChunk) {
        return pngChunk instanceof PngChunkUNKNOWN;
    }

    public static int posNullByte(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean shouldLoad(String string, ChunkLoadBehaviour chunkLoadBehaviour) {
        if (ChunkHelper.isCritical(string)) {
            return true;
        }
        boolean bl = PngChunk.isKnown(string);
        switch (chunkLoadBehaviour) {
            case LOAD_CHUNK_ALWAYS: {
                return true;
            }
            case LOAD_CHUNK_IF_SAFE: {
                return bl || ChunkHelper.isSafeToCopy(string);
            }
            case LOAD_CHUNK_KNOWN: {
                return bl;
            }
            case LOAD_CHUNK_NEVER: {
                return false;
            }
        }
        return false;
    }

    public static final byte[] compressBytes(byte[] byArray, boolean bl) {
        return ChunkHelper.compressBytes(byArray, 0, byArray.length, bl);
    }

    public static byte[] compressBytes(byte[] byArray, int n, int n2, boolean bl) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            InputStream inputStream = bl ? byteArrayInputStream : new InflaterInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = bl ? new DeflaterOutputStream(byteArrayOutputStream) : byteArrayOutputStream;
            ChunkHelper.shovelInToOut(inputStream, outputStream);
            inputStream.close();
            outputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new PngjException(exception);
        }
    }

    private static void shovelInToOut(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static boolean maskMatch(int n, int n2) {
        return (n & n2) != 0;
    }

    public static List<PngChunk> filterList(List<PngChunk> list, ChunkPredicate chunkPredicate) {
        ArrayList<PngChunk> arrayList = new ArrayList<PngChunk>();
        for (PngChunk pngChunk : list) {
            if (!chunkPredicate.match(pngChunk)) continue;
            arrayList.add(pngChunk);
        }
        return arrayList;
    }

    public static int trimList(List<PngChunk> list, ChunkPredicate chunkPredicate) {
        Iterator<PngChunk> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PngChunk pngChunk = iterator.next();
            if (!chunkPredicate.match(pngChunk)) continue;
            iterator.remove();
            ++n;
        }
        return n;
    }

    public static final boolean equivalent(PngChunk pngChunk, PngChunk pngChunk2) {
        if (pngChunk == pngChunk2) {
            return true;
        }
        if (pngChunk == null || pngChunk2 == null || !pngChunk.id.equals(pngChunk2.id)) {
            return false;
        }
        if (pngChunk.getClass() != pngChunk2.getClass()) {
            return false;
        }
        if (!pngChunk2.allowsMultiple()) {
            return true;
        }
        if (pngChunk instanceof PngChunkTextVar) {
            return ((PngChunkTextVar)pngChunk).getKey().equals(((PngChunkTextVar)pngChunk2).getKey());
        }
        if (pngChunk instanceof PngChunkSPLT) {
            return ((PngChunkSPLT)pngChunk).getPalName().equals(((PngChunkSPLT)pngChunk2).getPalName());
        }
        return false;
    }

    public static boolean isText(PngChunk pngChunk) {
        return pngChunk instanceof PngChunkTextVar;
    }
}

