/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.awt;

import com.jogamp.common.util.RunnableTask;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.newt.util.EDTUtil;
import java.awt.EventQueue;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.Debug;

public class AWTEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private final Object edtLock = new Object();
    private final ThreadGroup threadGroup;
    private final String name;
    private final Runnable dispatchMessages;
    private NewtEventDispatchThread nedt = null;
    private int start_iter = 0;
    private static long pollPeriod = 10L;

    public AWTEDTUtil(ThreadGroup threadGroup, String string, Runnable runnable) {
        this.threadGroup = threadGroup;
        this.name = Thread.currentThread().getName() + "-" + string + "-EDT-";
        this.dispatchMessages = runnable;
        this.nedt = new NewtEventDispatchThread(this.threadGroup, string);
        this.nedt.setDaemon(true);
    }

    @Override
    public final long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public final void setPollPeriod(long l) {
        pollPeriod = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reset() {
        Object object = this.edtLock;
        synchronized (object) {
            this.waitUntilStopped();
            if (DEBUG) {
                System.err.println(Thread.currentThread() + ": AWT-EDT reset - edt: " + this.nedt);
            }
            this.nedt = new NewtEventDispatchThread(this.threadGroup, this.name);
            this.nedt.setDaemon(true);
        }
    }

    private final void startImpl() {
        if (this.nedt.isAlive()) {
            throw new RuntimeException("AWT-EDT Thread.isAlive(): true, isRunning: " + this.nedt.isRunning() + ", edt: " + this.nedt);
        }
        ++this.start_iter;
        this.nedt.setName(this.name + this.start_iter);
        this.nedt.shouldStop = false;
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": AWT-EDT START - edt: " + this.nedt);
        }
        this.nedt.start();
    }

    @Override
    public final boolean isCurrentThreadEDT() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public final boolean isCurrentThreadNEDT() {
        return this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadEDTorNEDT() {
        return EventQueue.isDispatchThread() || this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isRunning() {
        return this.nedt.isRunning();
    }

    @Override
    public final void invokeStop(Runnable runnable) {
        this.invokeImpl(true, runnable, true);
    }

    @Override
    public final void invoke(boolean bl, Runnable runnable) {
        this.invokeImpl(bl, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeImpl(boolean bl, Runnable runnable, boolean bl2) {
        Object object;
        Throwable throwable = null;
        RunnableTask runnableTask = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            Object object3 = this.edtLock;
            synchronized (object3) {
                if (this.nedt.shouldStop) {
                    if (DEBUG) {
                        System.err.println(Thread.currentThread() + ": Warning: AWT-EDT about (1) to stop, won't enqueue new task: " + this.nedt);
                        Thread.dumpStack();
                    }
                    return;
                }
                if (bl2) {
                    Object object4 = this.nedt.sync;
                    synchronized (object4) {
                        this.nedt.shouldStop = true;
                        this.nedt.sync.notifyAll();
                    }
                    if (DEBUG) {
                        System.err.println(Thread.currentThread() + ": AWT-EDT signal STOP (on edt: " + this.isCurrentThreadEDT() + ") - " + this.nedt);
                    }
                } else if (!this.nedt.isRunning()) {
                    this.startImpl();
                }
                if (null == runnable) {
                    bl = false;
                } else if (this.isCurrentThreadEDT()) {
                    runnable.run();
                    bl = false;
                } else {
                    runnableTask = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
                    AWTEDTExecutor.singleton.invoke(false, (Runnable)runnableTask);
                }
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = runnableTask.getThrowable();
                }
                if (null != throwable) {
                    if (throwable instanceof NativeWindowException) {
                        throw (NativeWindowException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitUntilIdle() {
        NewtEventDispatchThread newtEventDispatchThread;
        Object object = this.edtLock;
        synchronized (object) {
            newtEventDispatchThread = this.nedt;
        }
        if (!newtEventDispatchThread.isRunning() || newtEventDispatchThread == Thread.currentThread() || EventQueue.isDispatchThread()) {
            return;
        }
        try {
            AWTEDTExecutor.singleton.invoke(true, new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.nedt.isRunning() && this.nedt != Thread.currentThread() && !EventQueue.isDispatchThread()) {
                while (this.nedt.isRunning()) {
                    try {
                        this.edtLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }

    class NewtEventDispatchThread
    extends Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        Object sync;

        public NewtEventDispatchThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.sync = new Object();
        }

        public final boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object;
            RuntimeException runtimeException;
            block32: {
                if (DEBUG) {
                    System.err.println(this.getName() + ": AWT-EDT run() START " + this.getName());
                }
                runtimeException = null;
                try {
                    do {
                        if (!this.shouldStop) {
                            AWTEDTExecutor.singleton.invoke(true, AWTEDTUtil.this.dispatchMessages);
                        }
                        object = this.sync;
                        synchronized (object) {
                            if (!this.shouldStop) {
                                try {
                                    this.sync.wait(pollPeriod);
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                        }
                    } while (!this.shouldStop);
                    if (!DEBUG) break block32;
                    System.err.println(this.getName() + ": AWT-EDT run() END " + this.getName() + ", " + runtimeException);
                }
                catch (Throwable throwable) {
                    block33: {
                        try {
                            this.shouldStop = true;
                            runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException("Within AWT-EDT", throwable);
                            if (!DEBUG) break block33;
                            System.err.println(this.getName() + ": AWT-EDT run() END " + this.getName() + ", " + runtimeException);
                        }
                        catch (Throwable throwable2) {
                            if (DEBUG) {
                                System.err.println(this.getName() + ": AWT-EDT run() END " + this.getName() + ", " + runtimeException);
                            }
                            Object object2 = AWTEDTUtil.this.edtLock;
                            synchronized (object2) {
                                boolean bl = this.isRunning = !this.shouldStop;
                                if (!this.isRunning) {
                                    AWTEDTUtil.this.edtLock.notifyAll();
                                }
                            }
                            if (DEBUG) {
                                System.err.println(this.getName() + ": AWT-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                            }
                            if (null != runtimeException) {
                                throw runtimeException;
                            }
                            throw throwable2;
                        }
                    }
                    Object object3 = AWTEDTUtil.this.edtLock;
                    synchronized (object3) {
                        boolean bl = this.isRunning = !this.shouldStop;
                        if (!this.isRunning) {
                            AWTEDTUtil.this.edtLock.notifyAll();
                        }
                    }
                    if (DEBUG) {
                        System.err.println(this.getName() + ": AWT-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                    }
                    if (null != runtimeException) {
                        throw runtimeException;
                    }
                }
            }
            object = AWTEDTUtil.this.edtLock;
            synchronized (object) {
                boolean bl = this.isRunning = !this.shouldStop;
                if (!this.isRunning) {
                    AWTEDTUtil.this.edtLock.notifyAll();
                }
            }
            if (DEBUG) {
                System.err.println(this.getName() + ": AWT-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
            }
            if (null != runtimeException) {
                throw runtimeException;
            }
        }
    }
}

