/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.utils;

import java.util.ArrayList;
import java.util.List;
import org.taongad.utils.MarchingSquare;
import org.taongad.utils.Point;

public class MarchingSquaresField {
    private List<Point> points = new ArrayList<Point>();
    private List<MarchingSquare> squares = new ArrayList<MarchingSquare>();

    public MarchingSquaresField(int width, int height, int step_x, int step_y) {
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                Point tl = this.add_point(x, y + step_y);
                Point tr = this.add_point(x + step_x, y + step_y);
                Point bl = this.add_point(x, y);
                Point br = this.add_point(x + step_x, y);
                Point center = this.add_point((float)x + (float)step_x / 2.0f, (float)y + (float)step_y / 2.0f);
                MarchingSquare ms = new MarchingSquare(tl, tr, bl, br, center);
                this.squares.add(ms);
                y += step_y;
            }
            x += step_x;
        }
    }

    public List<MarchingSquare> getSquares() {
        return this.squares;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void reset() {
        for (Point p : this.points) {
            p.reset();
        }
    }

    private Point add_point(float x, float y) {
        Point p2;
        for (Point p2 : this.points) {
            if (p2.pos.x != x || p2.pos.y != y) continue;
            return p2;
        }
        p2 = new Point(x, y, 0.0f);
        p2.nearest_ball = null;
        this.points.add(p2);
        return p2;
    }

    public static void main(String[] args) {
        MarchingSquaresField msf = new MarchingSquaresField(30, 20, 10, 10);
        System.out.println(msf.points.size());
        System.out.println(msf.squares.size());
    }
}

