/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene.entities;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import org.taongad.gfx.SpriteAnimation;
import org.taongad.scene.Scene;

public abstract class Entity {
    protected SpriteAnimation anim;
    float xPos;
    float yPos;
    float alpha = 1.0f;
    float scale = 4.0f;
    protected boolean loop = true;

    protected void init(Scene parent, Sprite[] frames, int frameDelay, float timeOffset) {
        this.anim = new SpriteAnimation(frames, frameDelay, timeOffset, this.loop);
    }

    public float getMaxLoopTime() {
        return this.anim.getMaxLoopTime();
    }

    public float getRemainingLoopTime() {
        return this.anim.getRemainingLoopTime();
    }

    public void setX(float xPos) {
        this.xPos = xPos;
    }

    public void setY(float yPos) {
        this.yPos = yPos;
    }

    public void setPosition(float x, float y) {
        this.xPos = x;
        this.yPos = y;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void draw(SpriteBatch batch, float deltaTimeMSec) {
        if (!this.anim.isDone()) {
            this.anim.update(deltaTimeMSec);
            Sprite sprite = this.anim.getCurrentFrame();
            sprite.setScale(this.scale);
            sprite.setPosition(this.xPos, this.yPos);
            sprite.draw(batch, this.alpha);
        }
    }
}

