/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import com.bitfire.utils.ShaderLoader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.Metronome;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.anim.drivers.LerpDriver;
import org.taongad.effects.PostPostProcessing;
import org.taongad.effects.PostProcessing;
import org.taongad.scene.BigBangScene;
import org.taongad.scene.BombScene;
import org.taongad.scene.CityAfterExplosionScene;
import org.taongad.scene.CityExplodeScene;
import org.taongad.scene.CityScene;
import org.taongad.scene.CreditsScene;
import org.taongad.scene.DjungleExplodedScene;
import org.taongad.scene.DjungleScene;
import org.taongad.scene.EggScene;
import org.taongad.scene.FadeScene;
import org.taongad.scene.MeteorScene;
import org.taongad.scene.RoboLifeScene;
import org.taongad.scene.Scene;
import org.taongad.scene.WaterScene;
import org.taongad.utils.DriverUtil;
import org.taongad.utils.FastMath;

public class SceneManager {
    Logger log = Logger.getLogger(SceneManager.class.getName());
    List<Scene> scenes;
    Scene currentScene;
    Scene nextScene;
    int activeScene = 0;
    float sceneFade = 0.0f;
    SpriteBatch batch;
    List<Disposable> disposables = new ArrayList<Disposable>();
    FrameBuffer currentSceneFBO;
    FrameBuffer nextSceneFBO;
    Sprite currentSceneSprite;
    Sprite nextSceneSprite;
    boolean doPost = true;
    Music music;
    Metronome metronome;
    AnimationSequence anim;
    float time = 0.0f;
    boolean isAllLoaded = false;
    boolean isLoading = false;
    List<Texture> loadAnim = new ArrayList<Texture>();
    final float LOAD_ANIM_TICK_MSEC = 50.0f;
    float loadAnimLastTickMSec;
    int currentTexIdx;
    Texture loadBarComponent;
    Pixmap loadBarComponentPix;
    Pixmap loadBarComponentPixInner;
    BitmapFont font;
    PostProcessing post;
    PostPostProcessing postPost;
    BitmapFont logoFont;
    private FadeScene fadeScene;

    public float getCurrentMusicPosMSec() {
        return this.music.getPosition() * 1000.0f;
    }

    public float getCurrentTimeMSec() {
        return this.time;
    }

    public void addDisposable(Disposable disposable) {
        this.disposables.add(disposable);
    }

    public SpriteBatch getBatch() {
        return this.batch;
    }

    public int getCurrentSceneNr() {
        return this.activeScene;
    }

    public void load() {
        this.batch = new SpriteBatch();
        this.disposables.add(this.batch);
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/Computerfont.ttf"));
        this.font = generator.generateFont(90);
        generator.dispose();
        this.loadAnim.add(new Texture(Gdx.files.internal("gfx/amigahand.png")));
        this.loadBarComponentPix = new Pixmap((int)((float)Gdx.graphics.getWidth() * 0.75f), 80, Pixmap.Format.RGB888);
        this.loadBarComponentPix.setColor(Color.WHITE);
        this.loadBarComponentPix.fill();
        this.loadBarComponentPixInner = new Pixmap(this.loadBarComponentPix.getWidth() - 16, this.loadBarComponentPix.getHeight() - 16, Pixmap.Format.RGB888);
        this.loadBarComponentPixInner.setColor(Color.BLACK);
        this.loadBarComponentPixInner.fill();
        this.loadBarComponentPix.drawPixmap(this.loadBarComponentPixInner, 8, 8);
        this.loadBarComponent = new Texture(this.loadBarComponentPix);
        this.disposables.add(this.loadBarComponentPix);
        this.disposables.add(this.loadBarComponentPixInner);
        this.disposables.add(this.loadBarComponent);
        ShaderLoader.BasePath = "shaders/";
        this.post = new PostProcessing();
        this.postPost = new PostPostProcessing();
        generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/BIRTH_OF_A_HERO.ttf"));
        this.logoFont = generator.generateFont(150);
        generator.dispose();
        this.disposables.add(this.logoFont);
    }

    private void loadAll() {
        FastMath.init();
        this.anim = new AnimationSequence();
        this.createFBOs();
        this.loadScenes();
        this.loadMusic();
        this.music.play();
        this.isAllLoaded = true;
    }

    private void createFBOs() {
        this.currentSceneFBO = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
        this.disposables.add(this.currentSceneFBO);
        this.currentSceneSprite = new Sprite(this.currentSceneFBO.getColorBufferTexture());
        this.currentSceneSprite.flip(false, true);
        this.nextSceneFBO = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
        this.disposables.add(this.nextSceneFBO);
        this.nextSceneSprite = new Sprite(this.nextSceneFBO.getColorBufferTexture());
        this.nextSceneSprite.flip(false, true);
    }

    private void loadScenes() {
        this.scenes = new ArrayList<Scene>();
        this.fadeScene = new FadeScene(0.0f);
        this.loadScene(FadeScene.class, 0.0f, 1000.0f, 1000.0f);
        this.loadScene(BigBangScene.class, 1000.0f, 45000.0f, 3000.0f);
        this.loadScene(WaterScene.class, 45000.0f, 94000.0f, 4000.0f);
        this.loadScene(DjungleScene.class, 94000.0f, 107000.0f, 2000.0f);
        this.loadScene(MeteorScene.class, 107000.0f, 117000.0f, 1000.0f);
        this.loadScene(DjungleExplodedScene.class, 117000.0f, 125000.0f, 4000.0f);
        this.loadScene(EggScene.class, 125000.0f, 170000.0f, 3000.0f);
        this.loadScene(CityScene.class, 170000.0f, 204000.0f, 3000.0f);
        this.loadScene(BombScene.class, 204000.0f, 214000.0f, 1000.0f);
        this.loadScene(CityExplodeScene.class, 214000.0f, 222000.0f, 4000.0f);
        this.loadScene(CityAfterExplosionScene.class, 222000.0f, 233000.0f, 4000.0f);
        this.loadScene(RoboLifeScene.class, 233000.0f, 282000.0f, 3000.0f);
        this.loadScene(CreditsScene.class, 282000.0f, 306000.0f, 4000.0f);
        this.loadScene(FadeScene.class, 306000.0f, 520000.0f, 2000.0f);
        DriverUtil.setupLerpObserver(this.anim, new AnimationEvent.OnCompletedListener(){

            @Override
            public void onCompleted(float completedTime) {
                Gdx.app.exit();
            }
        }, this.scenes.get(this.scenes.size() - 1).getStartTime(), this.scenes.get(this.scenes.size() - 1).getStartTime() + 1000.0f < 120000.0f ? 120000.0f : this.scenes.get(this.scenes.size() - 1).getStartTime() + 1000.0f, 0.0f, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
            }
        });
        this.activeScene = 0;
        this.currentScene = this.scenes.get(this.activeScene);
        this.nextScene = this.activeScene + 1 < this.scenes.size() ? this.scenes.get(this.activeScene + 1) : this.fadeScene;
    }

    private void loadScene(Class<? extends Scene> sceneType, float startTimeMSec, float endTimeMSec, float fadeTimeMSec) {
        try {
            final Scene scene = sceneType.getConstructor(Float.TYPE).newInstance(Float.valueOf(startTimeMSec));
            scene.load();
            this.scenes.add(scene);
            this.disposables.add(scene);
            this.anim.addEvent(new SceneSwitchEvent(this, startTimeMSec, endTimeMSec));
            float fadeTime = endTimeMSec - startTimeMSec < fadeTimeMSec ? endTimeMSec - startTimeMSec : fadeTimeMSec;
            LerpDriver fadeOutDriver = new LerpDriver(endTimeMSec - fadeTime, endTimeMSec, 0.0f, 1.0f);
            fadeOutDriver.registerObserver(new DriverObserver<Float>(){

                @Override
                public void publishValue(Float value) {
                    SceneManager.this.fadeScene.setFadeColor(scene.getFadeInColor());
                    if (SceneManager.this.activeScene < SceneManager.this.scenes.size() - 1) {
                        SceneManager.this.sceneFade = value.floatValue();
                    }
                }
            });
            LerpDriver fadeInDriver = new LerpDriver(endTimeMSec, endTimeMSec + fadeTime, 1.0f, 0.0f);
            fadeInDriver.registerObserver(new DriverObserver<Float>(){

                @Override
                public void publishValue(Float value) {
                    if (SceneManager.this.activeScene < SceneManager.this.scenes.size()) {
                        SceneManager.this.sceneFade = value.floatValue();
                    }
                }
            });
            this.anim.addEvent(fadeOutDriver);
            this.anim.addEvent(fadeInDriver);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log.log(Level.WARNING, "Error creating Scene of type: " + sceneType.getName(), e);
        }
    }

    private void loadMusic() {
        this.music = Gdx.audio.newMusic(Gdx.files.internal("sfx/String Thory3.mp3"));
        this.music.setLooping(false);
        this.music.setVolume(1.0f);
        this.disposables.add(this.music);
    }

    public void nextScene() {
        if (this.activeScene + 1 < this.scenes.size()) {
            ++this.activeScene;
            this.activeScene %= this.scenes.size();
            this.currentScene.onSceneExitEvent(this);
            this.currentScene = this.scenes.get(this.activeScene);
            this.currentScene.onSceneEnterEvent(this);
            this.nextScene = this.activeScene + 1 < this.scenes.size() ? this.scenes.get(this.activeScene + 1) : this.fadeScene;
            this.currentSceneSprite.setTexture(this.currentSceneFBO.getColorBufferTexture());
            this.nextSceneSprite.setTexture(this.nextSceneFBO.getColorBufferTexture());
        }
    }

    public void draw(float deltaTimeMSec) {
        if (this.isAllLoaded) {
            if (this.isLoading) {
                this.isLoading = false;
                deltaTimeMSec = 0.0f;
            }
            this.time += deltaTimeMSec;
            this.post.update(this.time);
            this.postPost.update(this.time);
            this.anim.update(deltaTimeMSec);
            this.currentSceneFBO.begin();
            this.currentScene.drawScene(this.time);
            this.currentSceneFBO.end();
            this.nextSceneFBO.begin();
            this.fadeScene.draw(deltaTimeMSec);
            this.nextSceneFBO.end();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            this.doPost = !(this.currentScene instanceof CreditsScene);
            if (this.doPost) {
                this.post.begin();
            } else {
                this.postPost.begin();
            }
            this.batch.begin();
            this.currentSceneSprite.draw(this.batch);
            this.nextSceneSprite.draw(this.batch, this.sceneFade);
            this.batch.end();
            if (this.doPost) {
                this.post.end();
            } else {
                this.postPost.end();
            }
        } else {
            this.handleLoadingScreen(deltaTimeMSec);
        }
    }

    private void handleLoadingScreen(float deltaTimeMSec) {
        this.loadAnimLastTickMSec += deltaTimeMSec;
        if (this.loadAnimLastTickMSec >= 50.0f) {
            ++this.currentTexIdx;
            this.currentTexIdx %= this.loadAnim.size();
            this.loadAnimLastTickMSec = 0.0f;
        }
        float factorLoaded = this.time % 20.0f / 20.0f;
        this.loadBarComponentPixInner.setColor(Color.BLACK);
        this.loadBarComponentPixInner.fill();
        this.loadBarComponentPixInner.setColor(Color.WHITE);
        this.loadBarComponentPixInner.fillRectangle(0, 0, (int)((float)this.loadBarComponentPixInner.getWidth() * factorLoaded), this.loadBarComponentPixInner.getHeight());
        this.loadBarComponentPix.drawPixmap(this.loadBarComponentPixInner, 8, 8);
        this.loadBarComponent.draw(this.loadBarComponentPix, 0, 0);
        float scale = 2.0f;
        Texture currTex = this.loadAnim.get(this.currentTexIdx);
        float animDestW = (float)currTex.getWidth() * scale;
        float animDestH = (float)currTex.getHeight() * scale;
        int animSrcW = currTex.getWidth();
        int animSrcH = currTex.getHeight();
        float yOffs = 0.0f;
        String txt2 = "Loading...";
        this.batch.begin();
        this.batch.draw(this.loadAnim.get(this.currentTexIdx), (float)Gdx.graphics.getWidth() / 2.0f - animDestW / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f - animDestH / 2.0f - yOffs, (float)animSrcW / 2.0f, (float)animSrcH / 2.0f, animDestW, animDestH, 1.0f, 1.0f, 0.0f, 0, 0, animSrcW, animSrcH, false, false);
        this.font.setColor(Color.WHITE);
        this.font.draw(this.batch, txt2, (float)Gdx.graphics.getWidth() / 2.0f - this.font.getBounds((CharSequence)txt2).width / 2.0f + 30.0f, (float)Gdx.graphics.getHeight() * 0.25f);
        this.batch.end();
        if (this.isLoading) {
            this.loadAll();
            this.time = 0.0f;
        } else {
            this.isLoading = true;
        }
    }

    public void setFadeColor(Color color) {
        this.fadeScene.setFadeColor(color);
    }

    public void dispose() {
        for (Disposable disposable : this.disposables) {
            disposable.dispose();
        }
    }

    public class SceneSwitchEvent
    extends AnimationEvent {
        SceneManager manager;

        public SceneSwitchEvent(SceneManager manager, float startTime, float endTime) {
            super(startTime, endTime);
            this.manager = manager;
        }

        @Override
        public void update(float deltaTimeMSec) {
        }

        @Override
        public void dispose() {
            this.manager.nextScene();
        }
    }
}

