/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Sprite;
import java.util.Random;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.ColorUtil;
import org.taongad.utils.DriverUtil;

public class DjungleScene
extends StringTheoryScene {
    PixTexSprite plant;
    PixTexSprite bush;
    PixTexSprite cactus;
    PixTexSprite hut;
    PixTexSprite djungle;
    PixTexSprite preDjungle;
    PixTexSprite trex;
    float scrollOffs;
    float endOffs = 1632.0f;
    float skyColor = 1.0f;
    float groundColor = 1.0f;
    Random rng = new Random(5151L);

    public DjungleScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.anim = new AnimationSequence();
        this.plant = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/gr\u00e4stuva.png"));
        this.plant.drawPixToTex();
        this.cactus = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/kaktus.png"));
        this.cactus.drawPixToTex();
        this.bush = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/buske.png"));
        this.bush.drawPixToTex();
        this.djungle = new PixTexSprite(this, Gdx.files.internal("gfx/djungel/heldjungel.png"));
        this.djungle.drawPixToTex();
        this.preDjungle = new PixTexSprite(this, Gdx.files.internal("gfx/djungel/inf\u00f6r skog.png"));
        this.preDjungle.drawPixToTex();
        this.trex = new PixTexSprite(this, Gdx.files.internal("gfx/trex/trex2.png"));
        this.trex.drawPixToTex();
        float scrollTime = 10000.0f;
        DriverUtil.setupLerpObserver(this.anim, 0.0f, scrollTime, 0.0f, -this.endOffs, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                DjungleScene.this.scrollOffs = value.floatValue();
            }
        });
        DriverUtil.setupLerpObserver(this.anim, 0.0f, scrollTime, 1.0f, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                DjungleScene.this.skyColor = value.floatValue();
                DjungleScene.this.groundColor = value.floatValue();
            }
        });
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        this.anim.update(deltaTimeMSec);
        Gdx.gl.glClearColor(0.0f, 0.4f * this.skyColor, 0.3f + 0.6f * this.skyColor, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.bg.getPixmap().setColor(ColorUtil.createColorFromByteValues(184, 134, 11, 255).mul(0.3f + 0.6f * this.groundColor));
        this.bg.getPixmap().fillRectangle(0, 76, 204, 152);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        int treeLine1 = 71;
        int treeLine2 = 69;
        float scale = 5.0f;
        float startPos = this.endOffs / scale;
        this.rng = new Random(5151L);
        this.drawRandomPos(this.bush, 20, 0.0f, 300.0f);
        this.drawRandomPos(this.bush, 10, 150.0f, 460.0f);
        this.rng = new Random(5159L);
        this.drawRandomPos(this.bush, 40, 460.0f, 820.0f);
        this.rng = new Random(5153L);
        this.drawRandomPos(this.plant, 20, 0.0f, 520.0f);
        this.drawRandomPos(this.plant, 20, 520.0f, 820.0f);
        this.rng = new Random(5157L);
        this.drawRandomPos(this.cactus, 8, 0.0f, 620.0f);
        float offset = -50.0f;
        this.drawSprite(this.preDjungle, startPos - (float)(this.djungle.getWidth() * 2) - offset, treeLine2, scale);
        this.drawSprite(this.djungle, startPos + 0.0f, treeLine1, scale);
        this.drawSprite(this.djungle, startPos + (float)this.djungle.getWidth(), treeLine1, scale);
        this.drawSprite(this.djungle, startPos + (float)(this.djungle.getWidth() * 2), treeLine1, scale);
        this.drawSprite(this.djungle, startPos + offset, treeLine2, scale);
        this.drawSprite(this.djungle, startPos + (float)this.djungle.getWidth() + offset, treeLine2, scale);
        this.drawSprite(this.djungle, startPos + (float)(this.djungle.getWidth() * 2) + offset, treeLine2, scale);
        this.drawSprite(this.djungle, startPos + (float)(this.djungle.getWidth() * 3) + offset, treeLine2, scale);
        this.drawSprite(this.trex, startPos + 102.0f, 60.0f, scale);
        this.batch.end();
    }

    private void drawRandomPos(PixTexSprite sprite, int count, float minX, float maxX) {
        float minY = 0.0f;
        float maxY = 120.0f;
        int i = 0;
        while (i < count) {
            this.drawSprite(sprite, minX + this.rng.nextFloat() * maxX, minY + this.rng.nextFloat() * maxY, 3.0f);
            ++i;
        }
    }

    private void drawSprite(PixTexSprite sprite, float x, float y, float scale) {
        Sprite mySprite = sprite.getSprite();
        mySprite.setScale(scale);
        mySprite.setOrigin(mySprite.getWidth() / 2.0f, 2.0f);
        mySprite.setPosition(this.scrollOffs + x * mySprite.getScaleX(), y * mySprite.getScaleX());
        mySprite.draw(this.batch, 1.0f);
    }
}

