/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.Sprite;
import java.util.Random;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.ColorUtil;
import org.taongad.utils.DriverUtil;
import org.taongad.utils.FastMath;

public class DjungleExplodedScene
extends StringTheoryScene {
    PixTexSprite plant;
    PixTexSprite bush;
    PixTexSprite cactus;
    PixTexSprite hut;
    PixTexSprite djugle;
    PixTexSprite trex;
    PixTexSprite bombCloud;
    float orgScrollOffs = -1632.0f;
    float scrollOffs = -1632.0f;
    float yOffs = 0.0f;
    float endOffs = 1632.0f;
    float skyColor = 0.0f;
    float groundColor = 0.0f;
    float shakeX;
    float shakeY;
    Random rng = new Random(5151L);
    Random rngBomb = new Random(5151L);
    Sound explosion;
    boolean firstFrame = true;

    public DjungleExplodedScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.anim = new AnimationSequence();
        this.explosion = Gdx.audio.newSound(Gdx.files.internal("sfx/Bomb_Exploding2.mp3"));
        this.disposables.add(this.explosion);
        this.plant = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/gr\u00e4stuva.png"));
        this.plant.drawPixToTex();
        this.cactus = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/kaktus.png"));
        this.cactus.drawPixToTex();
        this.bush = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/buske.png"));
        this.bush.drawPixToTex();
        this.djugle = new PixTexSprite(this, Gdx.files.internal("gfx/djungel/heldjungel.png"));
        this.djugle.drawPixToTex();
        this.bombCloud = new PixTexSprite(this, Gdx.files.internal("gfx/svampmoln3.png"));
        this.bombCloud.drawPixToTex();
        this.trex = new PixTexSprite(this, Gdx.files.internal("gfx/trex/trex2.png"));
        this.trex.drawPixToTex();
        DriverUtil.setupLerpObserver(this.anim, 0.0f, 20000.0f, 1.0f, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                float dirX = FastMath.cos(DjungleExplodedScene.this.rngBomb.nextFloat() * ((float)Math.PI * 2));
                float dirY = FastMath.sin(DjungleExplodedScene.this.rngBomb.nextFloat() * ((float)Math.PI * 2));
                float ampX = DjungleExplodedScene.this.rngBomb.nextFloat() * 14.0f;
                float ampY = DjungleExplodedScene.this.rngBomb.nextFloat() * 7.0f;
                DjungleExplodedScene.this.shakeX = dirX * ampX;
                DjungleExplodedScene.this.scrollOffs = DjungleExplodedScene.this.orgScrollOffs + DjungleExplodedScene.this.shakeX;
                DjungleExplodedScene.this.shakeY = DjungleExplodedScene.this.yOffs = ampY * dirY;
            }
        });
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        if (this.firstFrame) {
            this.explosion.play(1.0f, 0.8f, 0.0f);
            this.firstFrame = false;
        }
        this.time += deltaTimeMSec;
        this.anim.update(deltaTimeMSec);
        Gdx.gl.glClearColor(0.0f, 0.4f * this.skyColor, 0.3f + 0.6f * this.skyColor, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.bg.getPixmap().setColor(ColorUtil.createColorFromByteValues(184, 134, 11, 255).mul(0.3f + 0.6f * this.groundColor));
        this.bg.getPixmap().fillRectangle(0, 76, 204, 152);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        int treeLine1 = 74;
        int treeLine2 = 67;
        float scale = 5.0f;
        float startPos = this.endOffs / scale;
        this.drawSprite(this.djugle, startPos + 0.0f, treeLine1, scale);
        this.drawSprite(this.djugle, startPos + (float)this.djugle.getWidth(), treeLine1, scale);
        this.drawSprite(this.djugle, startPos + (float)(this.djugle.getWidth() * 2), treeLine1, scale);
        float offset = 10.0f;
        this.drawSprite(this.djugle, startPos + offset, treeLine2, scale);
        this.drawSprite(this.djugle, startPos + (float)this.djugle.getWidth() + offset, treeLine2, scale);
        this.drawSprite(this.djugle, startPos + (float)(this.djugle.getWidth() * 2) + offset, treeLine2, scale);
        this.rng = new Random(5151L);
        this.drawRandomPos(this.bush, 20, 0.0f, 300.0f);
        this.drawRandomPos(this.bush, 10, 150.0f, 460.0f);
        this.rng = new Random(5159L);
        this.drawRandomPos(this.bush, 40, 460.0f, 820.0f);
        this.rng = new Random(5153L);
        this.drawRandomPos(this.plant, 20, 0.0f, 520.0f);
        this.drawRandomPos(this.plant, 20, 520.0f, 820.0f);
        this.rng = new Random(5157L);
        this.drawRandomPos(this.cactus, 8, 0.0f, 620.0f);
        float cloudScale = (float)Gdx.graphics.getWidth() / 204.0f * 2.0f;
        this.bombCloud.getSprite().setScale(cloudScale);
        this.bombCloud.getSprite().setOrigin(this.bombCloud.getSprite().getWidth() / 2.0f, 0.0f);
        this.bombCloud.getSprite().setPosition(this.shakeX + (float)(Gdx.graphics.getWidth() / 2), this.shakeY + (float)(Gdx.graphics.getHeight() / 2) - 6.0f * cloudScale);
        this.bombCloud.getSprite().draw(this.batch, 0.95f);
        this.batch.end();
    }

    private void drawRandomPos(PixTexSprite sprite, int count, float minX, float maxX) {
        float minY = 0.0f;
        float maxY = 120.0f;
        int i = 0;
        while (i < count) {
            this.drawSprite(sprite, minX + this.rng.nextFloat() * maxX, minY + this.rng.nextFloat() * maxY, 3.0f);
            ++i;
        }
    }

    private void drawSprite(PixTexSprite sprite, float x, float y, float scale) {
        Sprite mySprite = sprite.getSprite();
        mySprite.setScale(scale);
        mySprite.setOrigin(mySprite.getWidth() / 2.0f, 2.0f);
        mySprite.setPosition(this.scrollOffs + x * mySprite.getScaleX(), this.yOffs + y * mySprite.getScaleX());
        mySprite.draw(this.batch, 0.9f);
    }
}

