/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import java.util.Random;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.ColorUtil;
import org.taongad.utils.DriverUtil;
import org.taongad.utils.FastMath;

public class CityExplodeScene
extends StringTheoryScene {
    PixTexSprite road;
    PixTexSprite city;
    PixTexSprite bombCloud;
    Color skyCityColor = ColorUtil.createColorFromByteValues(65, 65, 104, 255);
    Color cityColor = Color.GRAY;
    float orgScrollOffs = -1632.0f;
    float scrollOffs = -1632.0f;
    float yOffs = 0.0f;
    float endOffs = 1632.0f;
    float skyColor = 0.0f;
    float groundColor = 0.0f;
    float shakeX;
    float shakeY;
    Random rng = new Random(5151L);
    Random rngBomb = new Random(5151L);
    Sound explosion;
    boolean firstFrame = true;

    public CityExplodeScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.explosion = Gdx.audio.newSound(Gdx.files.internal("sfx/Bomb_Exploding2.mp3"));
        this.disposables.add(this.explosion);
        this.anim = new AnimationSequence();
        this.city = new PixTexSprite(this, Gdx.files.internal("gfx/stad/stad.png"));
        this.city.drawPixToTex();
        this.road = new PixTexSprite(this, Gdx.files.internal("gfx/stad/v\u00e4g.png"));
        this.road.drawPixToTex();
        this.bombCloud = new PixTexSprite(this, Gdx.files.internal("gfx/svampmoln3.png"));
        this.bombCloud.drawPixToTex();
        DriverUtil.setupLerpObserver(this.anim, 0.0f, 20000.0f, 1.0f, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                float dirX = FastMath.cos(CityExplodeScene.this.rngBomb.nextFloat() * ((float)Math.PI * 2));
                float dirY = FastMath.sin(CityExplodeScene.this.rngBomb.nextFloat() * ((float)Math.PI * 2));
                float ampX = CityExplodeScene.this.rngBomb.nextFloat() * 14.0f;
                float ampY = CityExplodeScene.this.rngBomb.nextFloat() * 7.0f;
                CityExplodeScene.this.shakeX = dirX * ampX;
                CityExplodeScene.this.scrollOffs = CityExplodeScene.this.orgScrollOffs + CityExplodeScene.this.shakeX;
                CityExplodeScene.this.shakeY = CityExplodeScene.this.yOffs = ampY * dirY;
            }
        });
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        if (this.firstFrame) {
            this.explosion.play(1.0f, 0.8f, 0.0f);
            this.firstFrame = false;
        }
        this.time += deltaTimeMSec;
        this.anim.update(deltaTimeMSec);
        Gdx.gl.glClearColor(this.skyCityColor.r, this.skyCityColor.g, this.skyCityColor.b, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.bg.getPixmap().setColor(this.cityColor);
        this.bg.getPixmap().fillRectangle(0, 76, 204, 152);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        int horizon1 = 73;
        int horizon2 = 72;
        float scale1 = 5.0f;
        float startPos = this.endOffs / scale1;
        this.drawSprite(this.city, startPos + 0.0f, horizon1, scale1);
        this.drawSprite(this.city, startPos + (float)this.city.getWidth(), horizon1, scale1);
        this.drawSprite(this.city, startPos + (float)(this.city.getWidth() * 2), horizon1, scale1);
        float offset = -50.0f;
        float scale2 = 3.0f;
        this.drawSprite(this.city, startPos + offset, (float)horizon2 * (scale1 / scale2), scale2);
        this.drawSprite(this.city, startPos + (float)this.city.getWidth() + offset, (float)horizon2 * (scale1 / scale2), scale2);
        this.drawSprite(this.city, startPos + (float)(this.city.getWidth() * 2) + offset, (float)horizon2 * (scale1 / scale2), scale2);
        int i = 0;
        while (i < 8) {
            this.drawSprite(this.road, 420 + this.road.getWidth() * i, 73 - this.road.getHeight(), scale1);
            ++i;
        }
        float cloudScale = (float)Gdx.graphics.getWidth() / 204.0f * 2.0f;
        this.bombCloud.getSprite().setScale(cloudScale);
        this.bombCloud.getSprite().setOrigin(this.bombCloud.getSprite().getWidth() / 2.0f, 0.0f);
        this.bombCloud.getSprite().setPosition(this.shakeX + (float)(Gdx.graphics.getWidth() / 2), this.shakeY + (float)(Gdx.graphics.getHeight() / 2) - 6.0f * cloudScale);
        this.bombCloud.getSprite().draw(this.batch, 0.95f);
        this.batch.end();
    }

    private void drawRandomPos(PixTexSprite sprite, int count, float minX, float maxX) {
        float minY = 0.0f;
        float maxY = 120.0f;
        int i = 0;
        while (i < count) {
            this.drawSprite(sprite, minX + this.rng.nextFloat() * maxX, minY + this.rng.nextFloat() * maxY, 3.0f);
            ++i;
        }
    }

    private void drawSprite(PixTexSprite sprite, float x, float y, float scale) {
        Sprite mySprite = sprite.getSprite();
        mySprite.setScale(scale);
        mySprite.setOrigin(mySprite.getWidth() / 2.0f, 2.0f);
        mySprite.setPosition(this.scrollOffs + x * mySprite.getScaleX(), this.yOffs + y * mySprite.getScaleX());
        mySprite.draw(this.batch, 0.9f);
    }
}

