/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import java.util.Random;
import org.taongad.anim.AnimationSequence;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.ColorUtil;

public class CityAfterExplosionScene
extends StringTheoryScene {
    PixTexSprite road;
    PixTexSprite city;
    PixTexSprite skulls;
    Color skyCityColor = ColorUtil.createColorFromByteValues(65, 65, 104, 255);
    Color cityColor = Color.GRAY;
    float yOffs = 0.0f;
    float skyColor = 0.0f;
    float groundColor = 0.0f;
    Random rng = new Random(5151L);

    public CityAfterExplosionScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.anim = new AnimationSequence();
        this.city = new PixTexSprite(this, Gdx.files.internal("gfx/stad/trasigstad.png"));
        this.city.drawPixToTex();
        this.road = new PixTexSprite(this, Gdx.files.internal("gfx/stad/v\u00e4g.png"));
        this.road.drawPixToTex();
        this.skulls = new PixTexSprite(this, Gdx.files.internal("gfx/d\u00f6skalle/fleralager.png"));
        this.skulls.drawPixToTex();
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        this.anim.update(deltaTimeMSec);
        Gdx.gl.glClearColor(this.skyCityColor.r, this.skyCityColor.g, this.skyCityColor.b, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.bg.getPixmap().setColor(this.cityColor);
        this.bg.getPixmap().fillRectangle(0, 76, 204, 152);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        int horizon1 = 53;
        int horizon2 = 72;
        float scale1 = 5.0f;
        float startPos = 0.0f;
        int i = 0;
        while (i < 2) {
            this.drawSprite(this.road, this.road.getWidth() / 3 + this.road.getWidth() * i, 73 - this.road.getHeight(), scale1);
            ++i;
        }
        this.drawSprite(this.city, startPos + 0.0f, horizon1, scale1);
        this.drawSprite(this.city, startPos + (float)this.city.getWidth(), horizon1, scale1);
        this.drawSprite(this.city, startPos + (float)(this.city.getWidth() * 2), horizon1, scale1);
        float offset = -50.0f;
        float scale2 = 3.0f;
        int i2 = 0;
        while (i2 < 4) {
            this.drawSprite(this.skulls, this.skulls.getWidth() * i2 - this.skulls.getWidth() / 2, 58 - this.skulls.getHeight(), scale1);
            ++i2;
        }
        this.batch.end();
    }

    private void drawRandomPos(PixTexSprite sprite, int count, float minX, float maxX) {
        float minY = 0.0f;
        float maxY = 120.0f;
        int i = 0;
        while (i < count) {
            this.drawSprite(sprite, minX + this.rng.nextFloat() * maxX, minY + this.rng.nextFloat() * maxY, 3.0f);
            ++i;
        }
    }

    private void drawSprite(PixTexSprite sprite, float x, float y, float scale) {
        Sprite mySprite = sprite.getSprite();
        mySprite.setScale(scale);
        mySprite.setOrigin(mySprite.getWidth() / 2.0f, 2.0f);
        mySprite.setPosition(x * mySprite.getScaleX(), this.yOffs + y * mySprite.getScaleX());
        mySprite.draw(this.batch, 1.0f);
    }
}

