/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.anim.drivers.LerpDriver;
import org.taongad.scene.SceneManager;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.FastMath;

public class BigBangScene
extends StringTheoryScene {
    final float waveTimeScale_1 = 0.005f;
    final float waveTimeScale_2_3 = 5.0E-4f;
    float circle1ScaleFactor = 1.0f;
    float timeScale1 = 1.1E-4f;
    float timeScale2 = 1.0E-6f;
    float timeScale3 = 2.0E-5f;
    float tint = 0.0f;
    Color colorDiffToWhite = Color.WHITE.cpy().sub(Color.YELLOW);
    Color circleColor = Color.YELLOW.cpy();
    Sound explosion;
    boolean hasTriggered;

    public BigBangScene(float startTimeMSec) {
        super(startTimeMSec);
        this.fadeColor = Color.WHITE.cpy();
    }

    @Override
    public void onSceneEnterEvent(SceneManager manager) {
        super.onSceneEnterEvent(manager);
        manager.setFadeColor(Color.BLACK);
    }

    @Override
    public void onSceneExitEvent(SceneManager manager) {
        super.onSceneExitEvent(manager);
        manager.setFadeColor(Color.WHITE);
    }

    @Override
    public void load() {
        this.explosion = Gdx.audio.newSound(Gdx.files.internal("sfx/Bomb_Exploding2.mp3"));
        this.disposables.add(this.explosion);
        this.anim = new AnimationSequence();
        float startFadeToWhite = 42000.0f;
        LerpDriver fadeToWhiteDriver = new LerpDriver(startFadeToWhite, startFadeToWhite + 3000.0f, 0.0f, 1.0f);
        fadeToWhiteDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                if (!BigBangScene.this.hasTriggered) {
                    BigBangScene.this.explosion.play(1.0f, 0.8f, 0.0f);
                    BigBangScene.this.hasTriggered = true;
                }
                BigBangScene.this.tint = value.floatValue();
                float r = Color.YELLOW.r + value.floatValue() * BigBangScene.this.colorDiffToWhite.r;
                float g = Color.YELLOW.g + value.floatValue() * BigBangScene.this.colorDiffToWhite.g;
                float b = Color.YELLOW.b + value.floatValue() * BigBangScene.this.colorDiffToWhite.b;
                BigBangScene.this.circleColor = new Color(r, g, b, 1.0f);
            }
        });
        this.anim.addEvent(fadeToWhiteDriver);
        float endTime = 1000.0f;
        float startExplode = 0.0f;
        this.setupCircleExplode0(startExplode, endTime, 0.5f);
        startExplode += endTime;
        endTime = 14137.167f;
        this.setupCircleExplode1(startExplode, endTime, 0.7f);
        this.setupCircleExplode2(startExplode += endTime, endTime, 0.5f);
        this.setupCircleExplode3(startExplode += endTime, startExplode + endTime * 2.0f);
    }

    private void setupCircleExplode0(float startTime, float endTime, float divisionFirstSecond) {
        float explodeDurationFirst = endTime * divisionFirstSecond;
        float explodeDurationSecond = endTime - explodeDurationFirst;
        float startExplodeEnd = startTime + explodeDurationFirst;
        LerpDriver explodingCircleDriver = new LerpDriver(startTime, startExplodeEnd, 0.0f, explodeDurationFirst);
        explodingCircleDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                BigBangScene.this.drawExplodingCircle0(BigBangScene.this.circleColor);
            }
        });
        this.anim.addEvent(explodingCircleDriver);
        LerpDriver stopExplodingCircleDriver = new LerpDriver(startExplodeEnd, startExplodeEnd + explodeDurationSecond, explodeDurationFirst, 0.0f);
        stopExplodingCircleDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                BigBangScene.this.drawExplodingCircle0(BigBangScene.this.circleColor);
            }
        });
        this.anim.addEvent(stopExplodingCircleDriver);
    }

    private void setupCircleExplode1(float startTime, float endTime, float divisionFirstSecond) {
        float explodeDurationFirst = endTime;
        float explodeDurationSecond = explodeDurationFirst - divisionFirstSecond * explodeDurationFirst;
        float startExplodeEnd = startTime + explodeDurationFirst;
        LerpDriver explodingCircleDriver = new LerpDriver(startTime, startExplodeEnd, 0.0f, explodeDurationFirst);
        explodingCircleDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                BigBangScene.this.drawExplodingCircle1(BigBangScene.this.circleColor, value.floatValue() * 3.0f);
            }
        });
        this.anim.addEvent(explodingCircleDriver);
        LerpDriver stopExplodingCircleDriver = new LerpDriver(startExplodeEnd - explodeDurationSecond, startExplodeEnd, 1.0f, 0.0f);
        stopExplodingCircleDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                BigBangScene.this.circle1ScaleFactor = value.floatValue();
            }
        });
        this.anim.addEvent(stopExplodingCircleDriver);
    }

    private void setupCircleExplode2(float startTime, float endTime, float divisionFirstSecond) {
        float explodeDurationFirst = endTime * divisionFirstSecond;
        float explodeDurationSecond = endTime - explodeDurationFirst;
        float startExplodeEnd = startTime + explodeDurationFirst;
        LerpDriver explodingCircleDriver = new LerpDriver(startTime, startExplodeEnd, 0.0f, explodeDurationFirst);
        explodingCircleDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                BigBangScene.this.drawExplodingCircle2(BigBangScene.this.circleColor, value.floatValue() * 0.6f);
            }
        });
        this.anim.addEvent(explodingCircleDriver);
        LerpDriver stopExplodingCircleDriver = new LerpDriver(startExplodeEnd, startExplodeEnd + explodeDurationSecond, explodeDurationFirst, 0.0f);
        stopExplodingCircleDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                BigBangScene.this.drawExplodingCircle2(BigBangScene.this.circleColor, value.floatValue() * 0.6f);
            }
        });
        this.anim.addEvent(stopExplodingCircleDriver);
    }

    private void setupCircleExplode3(float startTime, float endTime) {
        float explodeDuration = endTime;
        float startExplodeEnd = startTime + explodeDuration;
        LerpDriver explodingCircleDriver = new LerpDriver(startTime, startExplodeEnd, 0.0f, endTime);
        explodingCircleDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                BigBangScene.this.drawExplodingCircle3(BigBangScene.this.circleColor, value.floatValue());
            }
        });
        this.anim.addEvent(explodingCircleDriver);
        LerpDriver stopExplodingCircleDriver = new LerpDriver(startExplodeEnd, startExplodeEnd + explodeDuration, endTime, 0.0f);
        stopExplodingCircleDriver.registerObserver(new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                BigBangScene.this.drawExplodingCircle3(BigBangScene.this.circleColor, value.floatValue());
            }
        });
        this.anim.addEvent(stopExplodingCircleDriver);
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        Gdx.gl.glClearColor(this.tint, this.tint, this.tint, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.bg.clearPix();
        this.anim.update(deltaTimeMSec);
        this.blitAndScaleBG();
        this.batch.end();
    }

    private void drawExplodingCircle0(Color waveColor) {
        this.bg.getPixmap().setColor(waveColor);
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            float iPos = i;
            int x = (int)(FastMath.cos(iPos) * 1.0f);
            int y = (int)(FastMath.sin(iPos) * 1.0f);
            this.bg.getPixmap().drawPixel(102 + x, 76 - y);
            i += 1.0E-4f;
        }
        this.bg.drawPixToTex();
    }

    private void drawExplodingCircle1(Color waveColor, float currTime) {
        float ampX = 30.0f;
        float ampY = 30.0f;
        float maxFreq = 1.0f;
        float timeAccel = 2.0E-5f;
        this.timeScale1 += timeAccel;
        float scaledTime = currTime * this.timeScale1;
        float wave2 = 0.5f + FastMath.sinAbs(4.712389f + currTime * 0.005f);
        float freq = maxFreq * (scaledTime * 0.1f);
        float mod2PIfreq = freq % ((float)Math.PI * 2);
        float wave4 = FastMath.sinAbs(4.712389f + scaledTime);
        ampX *= 1.0f;
        ampY *= 1.0f;
        this.bg.getPixmap().setColor(waveColor);
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            float wave1 = FastMath.sin(i * freq * 2.0f);
            float wave3 = FastMath.sin(i * freq * 3.0f);
            float iPos = i + mod2PIfreq;
            int x = (int)(FastMath.cos(iPos) * (1.0f + this.circle1ScaleFactor * ampX * wave4));
            int y = (int)(FastMath.sin(iPos) * (1.0f + this.circle1ScaleFactor * ampY * wave4));
            this.bg.getPixmap().drawPixel(102 + x, 76 - y);
            i += 1.0E-4f;
        }
        this.bg.drawPixToTex();
    }

    private void drawExplodingCircle2(Color waveColor, float currTime) {
        float baseRadius = 1.0f;
        float ampX = 40.0f;
        float ampY = 40.0f;
        float maxFreq = 20.0f;
        float timeAccel = 1.0E-7f;
        this.timeScale2 += timeAccel;
        float scaledTime = currTime * this.timeScale2;
        float wave2 = 0.5f + FastMath.sinAbs(4.712389f + currTime * 5.0E-4f);
        float freq = maxFreq * scaledTime;
        float mod2PIfreq = freq % ((float)Math.PI * 2);
        ampX *= 1.0f;
        ampY *= 1.0f;
        this.bg.getPixmap().setColor(waveColor);
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            float wave1 = FastMath.sin(i * freq * 2.0f);
            float wave3 = FastMath.sin(i * freq * 2.0f);
            float iPos = i + mod2PIfreq;
            int x = (int)(FastMath.cos(iPos) * (baseRadius + ampX * wave1));
            int y = (int)(FastMath.sin(iPos) * (baseRadius + ampY * wave3));
            this.bg.getPixmap().drawPixel(102 + x, 76 - y);
            i += 1.0E-4f;
        }
        this.bg.drawPixToTex();
    }

    private void drawExplodingCircle3(Color waveColor, float currTime) {
        float baseRadius = 1.0f;
        float ampX = 40.0f;
        float ampY = 40.0f;
        float maxFreq = 20.0f;
        float timeAccel = 1.0E-7f;
        this.timeScale3 += timeAccel;
        float scaledTime = currTime * this.timeScale3;
        float wave2 = 0.5f + FastMath.sinAbs(4.712389f + currTime * 5.0E-4f);
        float freq = maxFreq * scaledTime;
        float mod2PIfreq = freq % ((float)Math.PI * 2);
        ampX *= wave2 + scaledTime * 3.0f;
        ampY *= wave2 + scaledTime * 0.5f;
        this.bg.getPixmap().setColor(waveColor);
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            float wave1 = FastMath.sin(i * freq * 2.0f);
            float wave3 = FastMath.sin(i * (freq * 4.0f) * 2.0f);
            float iPos = i + mod2PIfreq;
            int x = (int)(FastMath.cos(iPos) * (baseRadius + ampX * wave1));
            int y = (int)(FastMath.sin(iPos) * (baseRadius + ampY * wave3));
            this.bg.getPixmap().drawPixel(102 + x, 76 - y);
            i += 1.0E-4f;
        }
        this.bg.drawPixToTex();
    }
}

