/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.gfx;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Disposable;
import org.taongad.gfx.ManagedPixmap;
import org.taongad.gfx.ManagedTexture;
import org.taongad.scene.Scene;

public class PixTex
implements Disposable {
    protected Pixmap pix;
    protected Texture tex;
    private int width;
    private int height;

    public PixTex(Scene parent, FileHandle handle) {
        this.pix = new ManagedPixmap(parent, handle);
        this.initTex(parent);
    }

    public PixTex(Scene parent, int width, int height, Pixmap.Format format) {
        this.pix = new ManagedPixmap(parent, width, height, format);
        this.initTex(parent);
    }

    private void initTex(Scene parent) {
        this.tex = new ManagedTexture(parent, this.pix);
        this.width = this.tex.getWidth();
        this.height = this.tex.getHeight();
    }

    public void clearPix() {
        this.pix.setColor(Color.alpha(0.0f));
        this.pix.fill();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Pixmap getPixmap() {
        return this.pix;
    }

    public Texture getTexture() {
        return this.tex;
    }

    public void drawPixToTex() {
        this.tex.draw(this.pix, 0, 0);
    }

    public void drawPixToTex(int x, int y) {
        this.tex.draw(this.pix, x, y);
    }

    @Override
    public void dispose() {
        this.pix.dispose();
        this.tex.dispose();
    }
}

