/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.anim.drivers;

import java.util.ArrayList;
import java.util.List;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.drivers.DriverObserver;

public abstract class Driver<T>
extends AnimationEvent {
    protected final T startValue;
    protected T currValue;
    private List<DriverObserver<T>> observers = new ArrayList<DriverObserver<T>>();

    public Driver(float startTime, float endTime, T startValue) {
        super(startTime, endTime);
        this.startValue = startValue;
        this.currValue = startValue;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.unregisterAllObservers();
    }

    public void registerObserver(DriverObserver<T> observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    private void unregisterAllObservers() {
        this.observers.clear();
    }

    public T getValue() {
        return this.currValue;
    }

    public void notifyAllObservers() {
        for (DriverObserver<T> obs : this.observers) {
            obs.publishValue(this.currValue);
        }
    }
}

