/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model.still;

import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.model.Model;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.collision.BoundingBox;
import java.util.ArrayList;

public class StillModel
implements Model {
    public final StillSubMesh[] subMeshes;
    private static final BoundingBox tmpBox = new BoundingBox();

    public StillModel(SubMesh ... subMeshes) {
        this.subMeshes = new StillSubMesh[subMeshes.length];
        for (int i = 0; i < subMeshes.length; ++i) {
            this.subMeshes[i] = (StillSubMesh)subMeshes[i];
        }
    }

    @Override
    public void render() {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            StillSubMesh subMesh = this.subMeshes[i];
            if (i == 0) {
                subMesh.material.bind();
            } else if (!this.subMeshes[i - 1].material.equals(subMesh.material)) {
                subMesh.material.bind();
            }
            subMesh.mesh.render(subMesh.primitiveType);
        }
    }

    @Override
    public void render(ShaderProgram program) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            StillSubMesh subMesh = this.subMeshes[i];
            if (i == 0) {
                subMesh.material.bind(program);
            } else if (!this.subMeshes[i - 1].material.equals(subMesh.material)) {
                subMesh.material.bind(program);
            }
            subMesh.mesh.render(program, subMesh.primitiveType);
        }
    }

    @Override
    public Model getSubModel(String ... subMeshNames) {
        ArrayList<StillSubMesh> subMeshes = new ArrayList<StillSubMesh>();
        for (String name : subMeshNames) {
            for (StillSubMesh subMesh : this.subMeshes) {
                if (!name.equals(subMesh.name)) continue;
                subMeshes.add(subMesh);
            }
        }
        if (subMeshes.size() > 0) {
            return new StillModel(subMeshes.toArray(new StillSubMesh[subMeshes.size()]));
        }
        return null;
    }

    @Override
    public StillSubMesh getSubMesh(String name) {
        for (StillSubMesh subMesh : this.subMeshes) {
            if (!subMesh.name.equals(name)) continue;
            return subMesh;
        }
        return null;
    }

    @Override
    public SubMesh[] getSubMeshes() {
        return this.subMeshes;
    }

    @Override
    public void setMaterials(Material ... materials) {
        if (materials.length != this.subMeshes.length) {
            throw new UnsupportedOperationException("number of materials must equal number of sub-meshes");
        }
        for (Material this.subMeshes[i].material : materials) {
        }
    }

    @Override
    public void setMaterial(Material material) {
        int len = this.subMeshes.length;
        for (int i = 0; i < len; ++i) {
            this.subMeshes[i].material = material;
        }
    }

    @Override
    public void getBoundingBox(BoundingBox bbox) {
        bbox.inf();
        for (int i = 0; i < this.subMeshes.length; ++i) {
            this.subMeshes[i].mesh.calculateBoundingBox(tmpBox);
            bbox.ext(tmpBox);
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.subMeshes.length; ++i) {
            this.subMeshes[i].mesh.dispose();
        }
    }
}

