/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g3d.ModelLoaderHints;
import com.badlogic.gdx.graphics.g3d.loaders.KeyframedModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.ModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.SkeletonModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.StillModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.G3dLoader;
import com.badlogic.gdx.graphics.g3d.loaders.g3d.G3dtLoader;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Loader;
import com.badlogic.gdx.graphics.g3d.loaders.wavefront.ObjLoader;
import com.badlogic.gdx.graphics.g3d.model.Model;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedModel;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class ModelLoaderRegistry {
    private static Map<String, Array<ModelLoader>> loaders = new HashMap<String, Array<ModelLoader>>();
    private static Map<String, Array<ModelLoaderHints>> defaultHints = new HashMap<String, Array<ModelLoaderHints>>();

    public static void registerLoader(String extension, ModelLoader loader, ModelLoaderHints defaultHints) {
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        if (loaders == null) {
            loaders = new Array();
            ModelLoaderRegistry.loaders.put(extension.toLowerCase(), loaders);
        }
        loaders.add(loader);
        Array<ModelLoaderHints> hints = ModelLoaderRegistry.defaultHints.get(extension);
        if (hints == null) {
            hints = new Array();
            ModelLoaderRegistry.defaultHints.put(extension.toLowerCase(), hints);
        }
        hints.add(defaultHints);
    }

    public static Model load(FileHandle file) {
        String name = file.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new GdxRuntimeException("file '" + file.name() + "' does not have an extension that can be matched to a ModelLoader");
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        Array<ModelLoaderHints> hints = defaultHints.get(extension);
        if (loaders == null) {
            throw new GdxRuntimeException("no loaders for extension '" + extension + "'");
        }
        if (hints == null) {
            throw new GdxRuntimeException("no default hints for extension '" + extension + "'");
        }
        Model model = null;
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < loaders.size; ++i) {
            ModelLoader loader = loaders.get(i);
            ModelLoaderHints hint = hints.get(i);
            try {
                model = loader.load(file, hint);
                continue;
            }
            catch (GdxRuntimeException e) {
                errors.append("Couldn't load '" + file.name() + "' with loader of type " + loader.getClass().getName() + ": " + e.getMessage() + "\n");
            }
        }
        if (model == null) {
            throw new GdxRuntimeException(errors.toString());
        }
        return model;
    }

    public static Model load(FileHandle file, ModelLoaderHints hints) {
        String name = file.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new GdxRuntimeException("file '" + file.name() + "' does not have an extension that can be matched to a ModelLoader");
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        if (loaders == null) {
            throw new GdxRuntimeException("no loaders for extension '" + extension + "'");
        }
        Model model = null;
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < loaders.size; ++i) {
            ModelLoader loader = loaders.get(i);
            try {
                model = loader.load(file, hints);
                continue;
            }
            catch (GdxRuntimeException e) {
                errors.append("Couldn't load '" + file.name() + "' with loader of type " + loader.getClass().getName() + ": " + e.getMessage() + "\n");
            }
        }
        if (model == null) {
            throw new GdxRuntimeException(errors.toString());
        }
        return model;
    }

    public static StillModel loadStillModel(FileHandle file) {
        String name = file.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new GdxRuntimeException("file '" + file.name() + "' does not have an extension that can be matched to a ModelLoader");
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        Array<ModelLoaderHints> hints = defaultHints.get(extension);
        if (loaders == null) {
            throw new GdxRuntimeException("no loaders for extension '" + extension + "'");
        }
        if (hints == null) {
            throw new GdxRuntimeException("no default hints for extension '" + extension + "'");
        }
        StillModel model = null;
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < loaders.size; ++i) {
            ModelLoader loader = loaders.get(i);
            ModelLoaderHints hint = hints.get(i);
            try {
                if (!(loader instanceof StillModelLoader)) continue;
                model = ((StillModelLoader)loader).load(file, hint);
                continue;
            }
            catch (GdxRuntimeException e) {
                errors.append("Couldn't load '" + file.name() + "' with loader of type " + loader.getClass().getName() + ": " + e.getMessage() + "\n");
            }
        }
        if (model == null) {
            throw new GdxRuntimeException("Couldn't load model '" + file.name() + "', " + errors.toString());
        }
        return model;
    }

    public static StillModel loadStillModel(FileHandle file, ModelLoaderHints hints) {
        String name = file.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new GdxRuntimeException("file '" + file.name() + "' does not have an extension that can be matched to a ModelLoader");
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        if (loaders == null) {
            throw new GdxRuntimeException("no loaders for extension '" + extension + "'");
        }
        StillModel model = null;
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < loaders.size; ++i) {
            ModelLoader loader = loaders.get(i);
            try {
                if (!(loader instanceof StillModelLoader)) continue;
                model = ((StillModelLoader)loader).load(file, hints);
                continue;
            }
            catch (GdxRuntimeException e) {
                errors.append("Couldn't load '" + file.name() + "' with loader of type " + loader.getClass().getName() + ": " + e.getMessage() + "\n");
            }
        }
        if (model == null) {
            throw new GdxRuntimeException("Couldn't load model '" + file.name() + "', " + errors.toString());
        }
        return model;
    }

    public static KeyframedModel loadKeyframedModel(FileHandle file) {
        String name = file.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new GdxRuntimeException("file '" + file.name() + "' does not have an extension that can be matched to a ModelLoader");
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        Array<ModelLoaderHints> hints = defaultHints.get(extension);
        if (loaders == null) {
            throw new GdxRuntimeException("no loaders for extension '" + extension + "'");
        }
        if (hints == null) {
            throw new GdxRuntimeException("no default hints for extension '" + extension + "'");
        }
        KeyframedModel model = null;
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < loaders.size; ++i) {
            ModelLoader loader = loaders.get(i);
            ModelLoaderHints hint = hints.get(i);
            try {
                if (!(loader instanceof KeyframedModelLoader)) continue;
                model = ((KeyframedModelLoader)loader).load(file, hint);
                continue;
            }
            catch (GdxRuntimeException e) {
                errors.append("Couldn't load '" + file.name() + "' with loader of type " + loader.getClass().getName() + ": " + e.getMessage() + "\n");
            }
        }
        if (model == null) {
            throw new GdxRuntimeException(errors.toString());
        }
        return model;
    }

    public static KeyframedModel loadKeyframedModel(FileHandle file, ModelLoaderHints hints) {
        String name = file.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new GdxRuntimeException("file '" + file.name() + "' does not have an extension that can be matched to a ModelLoader");
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        if (loaders == null) {
            throw new GdxRuntimeException("no loaders for extension '" + extension + "'");
        }
        KeyframedModel model = null;
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < loaders.size; ++i) {
            ModelLoader loader = loaders.get(i);
            try {
                if (!(loader instanceof KeyframedModelLoader)) continue;
                model = ((KeyframedModelLoader)loader).load(file, hints);
                continue;
            }
            catch (GdxRuntimeException e) {
                errors.append("Couldn't load '" + file.name() + "' with loader of type " + loader.getClass().getName() + ": " + e.getMessage() + "\n");
            }
        }
        if (model == null) {
            throw new GdxRuntimeException(errors.toString());
        }
        return model;
    }

    public static SkeletonModel loadSkeletonModel(FileHandle file) {
        String name = file.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new GdxRuntimeException("file '" + file.name() + "' does not have an extension that can be matched to a ModelLoader");
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        Array<ModelLoaderHints> hints = defaultHints.get(extension);
        if (loaders == null) {
            throw new GdxRuntimeException("no loaders for extension '" + extension + "'");
        }
        if (hints == null) {
            throw new GdxRuntimeException("no default hints for extension '" + extension + "'");
        }
        SkeletonModel model = null;
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < loaders.size; ++i) {
            ModelLoader loader = loaders.get(i);
            ModelLoaderHints hint = hints.get(i);
            try {
                if (!(loader instanceof SkeletonModelLoader)) continue;
                model = ((SkeletonModelLoader)loader).load(file, hint);
                continue;
            }
            catch (GdxRuntimeException e) {
                errors.append("Couldn't load '" + file.name() + "' with loader of type " + loader.getClass().getName() + ": " + e.getMessage());
            }
        }
        if (model == null) {
            throw new GdxRuntimeException(errors.toString());
        }
        return model;
    }

    public static SkeletonModel loadSkeletonModel(FileHandle file, ModelLoaderHints hints) {
        String name = file.name();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new GdxRuntimeException("file '" + file.name() + "' does not have an extension that can be matched to a ModelLoader");
        }
        String extension = name.substring(dotIndex + 1).toLowerCase();
        Array<ModelLoader> loaders = ModelLoaderRegistry.loaders.get(extension);
        if (loaders == null) {
            throw new GdxRuntimeException("no loaders for extension '" + extension + "'");
        }
        SkeletonModel model = null;
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < loaders.size; ++i) {
            ModelLoader loader = loaders.get(i);
            try {
                if (!(loader instanceof SkeletonModelLoader)) continue;
                model = ((SkeletonModelLoader)loader).load(file, hints);
                continue;
            }
            catch (GdxRuntimeException e) {
                errors.append("Couldn't load '" + file.name() + "' with loader of type " + loader.getClass().getName() + ": " + e.getMessage());
            }
        }
        if (model == null) {
            throw new GdxRuntimeException(errors.toString());
        }
        return model;
    }

    static {
        ModelLoaderRegistry.registerLoader("obj", new ObjLoader(), new ModelLoaderHints(false));
        ModelLoaderRegistry.registerLoader("md2", new MD2Loader(), new MD2Loader.MD2LoaderHints(0.2f));
        ModelLoaderRegistry.registerLoader("g3dt", new G3dtLoader.G3dtStillModelLoader(), new ModelLoaderHints(true));
        ModelLoaderRegistry.registerLoader("g3dt", new G3dtLoader.G3dtKeyframedModelLoader(), new ModelLoaderHints(true));
        ModelLoaderRegistry.registerLoader("g3d", new G3dLoader.G3dStillModelLoader(), new ModelLoaderHints(false));
        ModelLoaderRegistry.registerLoader("g3d", new G3dLoader.G3dKeyframedModelLoader(), new ModelLoaderHints(false));
        ModelLoaderRegistry.registerLoader("g3d", new G3dLoader.G3dSkeletonModelLoader(), new ModelLoaderHints(false));
    }
}

