/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.TimeUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class AssetLoadingTask
implements Callable<Void> {
    AssetManager manager;
    final AssetDescriptor assetDesc;
    final AssetLoader loader;
    final ExecutorService threadPool;
    final long startTime;
    volatile boolean asyncDone = false;
    boolean dependenciesLoaded = false;
    Array<AssetDescriptor> dependencies;
    Future<Void> depsFuture = null;
    Future<Void> loadFuture = null;
    Object asset = null;
    int ticks = 0;
    boolean cancel = false;

    public AssetLoadingTask(AssetManager manager, AssetDescriptor assetDesc, AssetLoader loader, ExecutorService threadPool) {
        this.manager = manager;
        this.assetDesc = assetDesc;
        this.loader = loader;
        this.threadPool = threadPool;
        this.startTime = manager.log.getLevel() == 3 ? TimeUtils.nanoTime() : 0L;
    }

    @Override
    public Void call() throws Exception {
        AsynchronousAssetLoader asyncLoader = (AsynchronousAssetLoader)this.loader;
        if (!this.dependenciesLoaded) {
            this.dependencies = asyncLoader.getDependencies(this.assetDesc.fileName, this.assetDesc.params);
            if (this.dependencies != null) {
                for (AssetDescriptor desc : this.dependencies) {
                    this.manager.injectDependency(this.assetDesc.fileName, desc);
                }
            } else {
                asyncLoader.loadAsync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
                this.asyncDone = true;
            }
        } else {
            asyncLoader.loadAsync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
        }
        return null;
    }

    public boolean update() {
        ++this.ticks;
        if (this.loader instanceof SynchronousAssetLoader) {
            this.handleSyncLoader();
        } else {
            this.handleAsyncLoader();
        }
        return this.asset != null;
    }

    private void handleSyncLoader() {
        SynchronousAssetLoader syncLoader = (SynchronousAssetLoader)this.loader;
        if (!this.dependenciesLoaded) {
            this.dependenciesLoaded = true;
            this.dependencies = syncLoader.getDependencies(this.assetDesc.fileName, this.assetDesc.params);
            if (this.dependencies == null) {
                this.asset = syncLoader.load(this.manager, this.assetDesc.fileName, this.assetDesc.params);
                return;
            }
            for (AssetDescriptor desc : this.dependencies) {
                this.manager.injectDependency(this.assetDesc.fileName, desc);
            }
        } else {
            this.asset = syncLoader.load(this.manager, this.assetDesc.fileName, this.assetDesc.params);
        }
    }

    private void handleAsyncLoader() {
        AsynchronousAssetLoader asyncLoader = (AsynchronousAssetLoader)this.loader;
        if (!this.dependenciesLoaded) {
            if (this.depsFuture == null) {
                this.depsFuture = this.threadPool.submit(this);
            } else if (this.depsFuture.isDone()) {
                try {
                    this.depsFuture.get();
                }
                catch (Exception e) {
                    throw new GdxRuntimeException("Couldn't load dependencies of asset '" + this.assetDesc.fileName + "'", e);
                }
                this.dependenciesLoaded = true;
                if (this.asyncDone) {
                    this.asset = asyncLoader.loadSync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
                }
            }
        } else if (this.loadFuture == null && !this.asyncDone) {
            this.loadFuture = this.threadPool.submit(this);
        } else if (this.asyncDone) {
            this.asset = asyncLoader.loadSync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
        } else if (this.loadFuture.isDone()) {
            try {
                this.loadFuture.get();
            }
            catch (Exception e) {
                throw new GdxRuntimeException("Couldn't load asset '" + this.assetDesc.fileName + "'", e);
            }
            this.asset = asyncLoader.loadSync(this.manager, this.assetDesc.fileName, this.assetDesc.params);
        }
    }

    public Object getAsset() {
        return this.asset;
    }
}

