/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import processing.core.PApplet;
import processing.core.PGraphicsJava2D;
import processing.core.PImage;

public class PGraphicsRetina2D
extends PGraphicsJava2D {
    PImage retina = new PImage();
    static int[] rgetset = new int[4];

    public PGraphicsRetina2D() {
        this.retina.format = 1;
    }

    @Override
    public void setParent(PApplet parent) {
        super.setParent(parent);
        this.retina.parent = parent;
    }

    @Override
    protected void allocate() {
    }

    @Override
    public void beginDraw() {
        GraphicsConfiguration gc = this.parent.getGraphicsConfiguration();
        if (this.image == null) {
            this.retina.width = this.width * 2;
            this.retina.height = this.height * 2;
            this.image = gc.createCompatibleImage(this.retina.width, this.retina.height);
        }
        this.g2 = (Graphics2D)this.image.getGraphics();
        this.checkSettings();
        this.resetMatrix();
        this.g2.scale(2.0, 2.0);
        this.vertexCount = 0;
    }

    @Override
    public void endDraw() {
        this.g2.dispose();
    }

    @Override
    public void loadPixels() {
        if (this.retina.pixels == null || this.retina.pixels.length != this.retina.width * this.retina.height) {
            this.retina.pixels = new int[this.retina.width * this.retina.height];
        }
        this.getRaster().getDataElements(0, 0, this.retina.width, this.retina.height, this.retina.pixels);
        if (this.hints[10]) {
            this.pixels = this.retina.pixels;
        } else {
            if (this.pixels == null || this.pixels.length != this.width * this.height) {
                this.pixels = new int[this.width * this.height];
            }
            int offset = 0;
            int roffset = 0;
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    int px00 = this.retina.pixels[roffset];
                    int px01 = this.retina.pixels[roffset + 1];
                    int px10 = this.retina.pixels[roffset + this.retina.width];
                    int px11 = this.retina.pixels[roffset + this.retina.width + 1];
                    int red = (px00 >> 16 & 0xFF) + (px01 >> 16 & 0xFF) + (px10 >> 16 & 0xFF) + (px11 >> 16 & 0xFF) << 14 & 0xFF0000;
                    int green = (px00 >> 8 & 0xFF) + (px01 >> 8 & 0xFF) + (px10 >> 8 & 0xFF) + (px11 >> 8 & 0xFF) << 6 & 0xFF00;
                    int blue = (px00 & 0xFF) + (px01 & 0xFF) + (px10 & 0xFF) + (px11 & 0xFF) >> 2 & 0xFF;
                    this.pixels[offset++] = 0xFF000000 | red | green | blue;
                    roffset += 2;
                    ++x;
                }
                roffset += this.retina.width;
                ++y;
            }
        }
    }

    @Override
    public void updatePixels() {
        if (!this.hints[10]) {
            int offset = 0;
            int roffset = 0;
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    int orig;
                    this.retina.pixels[roffset] = orig = this.pixels[offset++];
                    this.retina.pixels[roffset + 1] = orig;
                    this.retina.pixels[roffset + this.retina.width] = orig;
                    this.retina.pixels[roffset + this.retina.width + 1] = orig;
                    ++x;
                }
                roffset += this.retina.width;
                ++y;
            }
        }
        this.getRaster().setDataElements(0, 0, this.retina.width, this.retina.height, this.retina.pixels);
    }

    @Override
    public int get(int x, int y) {
        if (this.hints[10]) {
            if (x < 0 || y < 0 || x >= this.retina.width || y >= this.retina.height) {
                return 0;
            }
            this.getRaster().getDataElements(x, y, getset);
            return getset[0];
        }
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        this.getRaster().getDataElements(x, y, 2, 2, getset);
        int red = (rgetset[0] >> 16 & 0xFF) + (rgetset[1] >> 16 & 0xFF) + (rgetset[2] >> 16 & 0xFF) + (rgetset[3] >> 16 & 0xFF) << 14 & 0xFF0000;
        int green = (rgetset[0] >> 8 & 0xFF) + (rgetset[1] >> 8 & 0xFF) + (rgetset[2] >> 8 & 0xFF) + (rgetset[3] >> 8 & 0xFF) << 6 & 0xFF00;
        int blue = (rgetset[0] & 0xFF) + (rgetset[1] & 0xFF) + (rgetset[2] & 0xFF) + (rgetset[3] & 0xFF) >> 2 & 0xFF;
        return 0xFF000000 | red | green | blue;
    }

    @Override
    public PImage get(int x, int y, int w, int h) {
        int targetX = 0;
        int targetY = 0;
        int targetWidth = w;
        int targetHeight = h;
        boolean cropped = false;
        if (x < 0) {
            w += x;
            targetX = -x;
            cropped = true;
            x = 0;
        }
        if (y < 0) {
            h += y;
            targetY = -y;
            cropped = true;
            y = 0;
        }
        if (this.hints[10]) {
            if (x + w > this.retina.width) {
                w = this.retina.width - x;
                cropped = true;
            }
            if (y + h > this.retina.height) {
                h = this.retina.height - y;
                cropped = true;
            }
        } else {
            if (x + w > this.width) {
                w = this.width - x;
                cropped = true;
            }
            if (y + h > this.height) {
                h = this.height - y;
                cropped = true;
            }
        }
        if (w < 0) {
            w = 0;
        }
        if (h < 0) {
            h = 0;
        }
        int targetFormat = this.format;
        if (cropped && this.format == 1) {
            targetFormat = 2;
        }
        PImage target = new PImage(targetWidth, targetHeight, targetFormat);
        target.parent = this.parent;
        if (w > 0 && h > 0) {
            this.getImpl(x, y, w, h, target, targetX, targetY);
        }
        return target;
    }

    @Override
    public PImage get() {
        PImage outgoing;
        this.loadPixels();
        if (this.hints[10]) {
            outgoing = this.retina.get();
            outgoing.parent = this.parent;
        } else {
            outgoing = new PImage(this.width, this.height, 1);
            outgoing.pixels = new int[this.width * this.height];
            System.arraycopy(this.pixels, 0, outgoing.pixels, 0, outgoing.pixels.length);
            outgoing.parent = this.parent;
        }
        return outgoing;
    }

    @Override
    public void set(int x, int y, int argb) {
        if (this.hints[10]) {
            if (x >= 0 && y >= 0 && x < this.retina.width && y < this.retina.height) {
                PGraphicsRetina2D.getset[0] = argb;
                this.getRaster().setDataElements(x, y, getset);
            }
        } else if (x >= 0 && y >= 0 && x < this.width && y < this.height) {
            int i = 0;
            while (i < 4) {
                PGraphicsRetina2D.rgetset[i] = argb;
                ++i;
            }
            this.getRaster().setDataElements(x, y, 2, 2, rgetset);
        }
    }

    @Override
    public void set(int x, int y, PImage img) {
        int sx = 0;
        int sy = 0;
        int sw = img.width;
        int sh = img.height;
        if (x < 0) {
            sx -= x;
            sw += x;
            x = 0;
        }
        if (y < 0) {
            sy -= y;
            sh += y;
            y = 0;
        }
        if (this.hints[10]) {
            if (x + sw > this.retina.width) {
                sw = this.retina.width - x;
            }
            if (y + sh > this.retina.height) {
                sh = this.retina.height - y;
            }
        } else {
            if (x + sw > this.width) {
                sw = this.width - x;
            }
            if (y + sh > this.height) {
                sh = this.height - y;
            }
        }
        if (sw <= 0 || sh <= 0) {
            return;
        }
        this.setImpl(img, sx, sy, sw, sh, x, y);
    }

    @Override
    public void mask(int[] alpha) {
        PGraphicsRetina2D.showMethodWarning("mask");
    }

    @Override
    public void mask(PImage alpha) {
        PGraphicsRetina2D.showMethodWarning("mask");
    }

    @Override
    public void filter(int kind) {
        if (this.hints[10]) {
            this.loadPixels();
            this.retina.filter(kind);
            this.updatePixels();
        } else {
            super.filter(kind);
        }
    }

    @Override
    public void filter(int kind, float param) {
        if (this.hints[10]) {
            this.loadPixels();
            this.retina.filter(kind, param);
            this.updatePixels();
        } else {
            super.filter(kind);
        }
    }

    @Override
    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (this.hints[10]) {
            super.copy(sx, sy, sw, sh, dx, dy, dw, dh);
        } else if (sw != dw || sh != dh) {
            this.g2.drawImage(this.image, dx * 2, dy * 2, (dx + dw) * 2, (dy + dh) * 2, sx * 2, sy * 2, (sx + sw) * 2, (sy + sh) * 2, null);
        } else {
            this.g2.copyArea(sx * 2, sy * 2, sw * 2, sh * 2, (dx -= sx) * 2, (dy -= sy) * 2);
        }
    }

    @Override
    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (this.hints[10]) {
            super.copy(src, sx, sy, sw, sh, dx, dy, dw, dh);
        } else {
            this.g2.drawImage((Image)src.getNative(), dx * 2, dy * 2, (dx + dw) * 2, (dy + dh) * 2, sx, sy, sx + sw, sy + sh, null);
        }
    }

    @Override
    public void blend(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        if (this.hints[10]) {
            this.retina.blend(sx, sy, sw, sh, dx, dy, dw, dh, mode);
        } else {
            super.blend(sx, sy, sw, sh, dx, dy, dw, dh, mode);
        }
    }

    @Override
    public void blend(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        if (this.hints[10]) {
            this.retina.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, mode);
        } else {
            super.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, mode);
        }
    }

    @Override
    public boolean save(String filename) {
        if (this.hints[10]) {
            return this.retina.save(filename);
        }
        return super.save(filename);
    }
}

