uniform sampler2D tex0;
uniform float vx_offset;
uniform float rnd_factor = 0.05;
uniform float rnd_scale = 5.1;
uniform vec2 v1 = vec2(92.,80.);
uniform vec2 v2 = vec2(41.,62.);
uniform float rt_w = 1024;
uniform float rt_h = 768;

float rand(vec2 co)
{
  return fract(sin(dot(co.xy ,v1)) + cos(dot(co.xy ,v2)) * rnd_scale);
}

void main() 
{ 
  vec2 uv = gl_TexCoord[0].xy;
  
  vec3 tc = vec3(1.0, 0.0, 0.0);
  if (uv.x < (vx_offset-0.005))
  {
    vec2 rnd = vec2(rand(uv.xy),rand(uv.yx));  
    tc = texture2D(tex0, uv+rnd*rnd_factor).rgb;  
  }
  else if (uv.x>=(vx_offset+0.005))
  {
    tc = texture2D(tex0, uv).rgb;
  }
  
  gl_FragColor = vec4(tc, 1.0);
}
