uniform sampler2D tex0;
uniform float time;
uniform float vx_offset;
void main() 
{ 
  float hatch_y_offset = 5.0;
  vec2 uv = gl_TexCoord[0].xy;
  
  vec3 tc = vec3(1.0, 0.0, 0.0);
  if (uv.x < (vx_offset-0.005))
  {
    float lum = length(texture2D(tex0, uv).rgb);
    tc = vec3(1.0, 1.0, 1.0);
  
    if (lum < 1.0) 
    {
      if (mod(gl_FragCoord.x + gl_FragCoord.y, 10.0) == 0.0) 
        tc = vec3(0.0, 0.0, 0.0);
    }  
  
    if (lum < 0.7) 
    {
      if (mod(gl_FragCoord.x - gl_FragCoord.y, 10.0) == 0.0) 
        tc = vec3(0.0, 0.0, 0.0);
    }  
  
    if (lum < 0.5) 
    {
      if (mod(gl_FragCoord.x + gl_FragCoord.y - hatch_y_offset, 10.0) == 0.0) 
        tc = vec3(0.0, 0.0, 0.0);
    }  
  
    if (lum < 0.3) 
    {
      if (mod(gl_FragCoord.x - gl_FragCoord.y - hatch_y_offset, 10.0) == 0.0) 
        tc = vec3(0.0, 0.0, 0.0);
    }
  }
  else if (uv.x>=(vx_offset+0.005))
  {
    tc = texture2D(tex0, uv).rgb;
  }
  
  gl_FragColor = vec4(tc, 1.0);
}

