import pygame, Utils, math, random
from pygame.locals import *

class Thing(pygame.sprite.Sprite):

    def __init__(self, place, image):
        pygame.sprite.Sprite.__init__(self)
        self._layer = -1
        self.image = Utils.load_image(image, -1)
        self.rect = pygame.Rect(place, (99, 131))
        self.frame = 0
        self.xSpeed = random.randint(2, 4)

    def draw(self, screen):
        screen.blit(self.image, self.rect.topleft)

    def detectBorder(self, sprites, screen):
        if self.rect.left > screen.get_width():
            sprites.remove(self)
            
    def update(self, sprites, screen):
        self.detectBorder(sprites, screen)
        self.frame += 1

        self.rect = self.rect.move(self.xSpeed, 0)
        
