import pygame, Utils
from pygame.locals import *

class Text(pygame.sprite.Sprite):

    def __init__(self, place, img1, img2, time):
        pygame.sprite.Sprite.__init__(self)
        self.image = Utils.load_image(img1, -1)
        self.image2 = Utils.load_image(img2, -1)
        self.rect = pygame.Rect(place, (1280, 720))
        self.frame = 0
        self.survival = time
        self.inc = True

    def draw(self, screen):
        if self.inc:
            screen.blit(self.image, (0, 0))
        elif not self.inc:
            screen.blit(self.image2, (0, 0))

    def detectBorder(self, sprites, screen):
        if self.rect.left < 0:
            sprites.remove(self)
        if self.rect.top < 0:
            sprites.remove(self)

    def toggle(self):
        if self.inc == True:
            self.inc = False
        else:
            self.inc = True
    
    def update(self, sprites, screen):
        self.frame += 1

        if self.frame % 8 == 0:
            self.toggle()

        if self.frame == 60*self.survival:
            sprites.remove(self)
        
