# -*- coding: cp1252 -*-
'''
Created on 29 aug 2012

@author: Dan Torberg

Modul som innehller en meny-loop samt metoder som anvnds av den.

Metoder: 

update_menu()        anropar set_background() samt load_buttons().
set_background()     ndrar bakgrunden beroende p om man r i huvudmenyn, creditssidan eller infosidan.
load_buttons()       laddar in olika knappar beroende p om man r i huvudmenyn, creditssidan eller infosidan.
user_input()         hanterar input frn anvndaren.
run_menu()           brjar med att anropa update_menu() samt starta musiken fr att sedan g in i menyloopen.
'''
import pygame, sys, Globals, Button, Game
from pygame.locals import * 

pygame.init()

screen = pygame.display.set_mode((1024, 600))
pygame.display.set_caption("Bepos revenge!")
icon = pygame.image.load("images/icon.png")
colorkey = icon.get_at((0, 0))
icon.set_colorkey(colorkey, RLEACCEL)
pygame.display.set_icon(icon)

pygame.mixer.music.load('sounds/JakesFable - Ecstatic Day.mp3')

background = None

sprites = pygame.sprite.RenderPlain()

clock = pygame.time.Clock()

def update_menu(page, main):
    set_background(page)
    load_buttons(main)
    
def set_background(page):
    global background 
    
    if page == 'main':
        background = Globals.load_image('images/menubg.png')
        background = background.convert()
    elif page == 'credit':
        background = Globals.load_image('images/credits.png')
        background = background.convert()
    elif page == 'instructions':
        background = Globals.load_image('images/instructions.png')
        background = background.convert()

def load_buttons(main):
    sprites.empty()
    if main:
        one = Button._1P(screen.get_width()/2-97, 200)
        two = Button._2P(screen.get_width()/2-97, 250)
        instructions = Button.Instructions(screen.get_width()/2-97, 300)
        cred = Button.Credits(screen.get_width()/2-97, 350)
        quitbutton = Button.Quit(screen.get_width()/2-97, 400)
        sprites.add(one, two, instructions, cred, quitbutton)
    else:
        back = Button.Back(10, screen.get_height()-44-10)
        sprites.add(back)

def user_input(events):
    for event in events:
        if event.type == QUIT:
            pygame.quit()
            sys.exit(0)
        elif event.type == KEYDOWN:
            if event.key == K_ESCAPE:
                pygame.quit()
                sys.exit(0)
            elif event.key == K_5:
                pygame.display.set_mode((1024, 600), pygame.FULLSCREEN)
        elif event.type == MOUSEBUTTONDOWN:
            for sprite in sprites:
                if sprite.rect.collidepoint(pygame.mouse.get_pos()) and pygame.mouse.get_pressed()[0]:
                    if isinstance(sprite, Button._1P):
                        Globals.players = 1
                        Game.run_game(screen)
                        
                    elif isinstance(sprite, Button._2P):
                        Globals.players = 2
                        Game.run_game(screen)
                        
                    elif isinstance(sprite, Button.Instructions):
                        update_menu('instructions', False)
                        
                    elif isinstance(sprite, Button.Credits):
                        update_menu('credit', False)
                        
                    elif isinstance(sprite, Button.Quit):
                        pygame.quit()
                        sys.exit()
                        
                    elif isinstance(sprite, Button.Back):
                        update_menu('main', True)
        
def run_menu():
    update_menu('main', True)
    pygame.mixer.music.play(-1)
    
    while True:
        clock.tick(30)
    
        user_input(pygame.event.get())
        
        screen.blit(background, (0, 0))
        sprites.update()
    
        for sprite in sprites:
            sprite.draw(screen)
                
        pygame.display.flip()
    
run_menu()
