# -*- coding: cp1252 -*-
'''
Created on 22 aug 2012

@author: Dan Torberg

Modul som innehller ett antal variabler och metoder som behver anvndas av flera av de olika klasserna och modulerna. 
Load_sound() och load_image() r metoder fr att ladda in bilder och ljud. Bda metoderna r lnade frn "Chimp" exemplet.

Variabler:

quit_game       anvnds fr att konrollera nr spel-loopen ska avslutas.
total_kills     anvnds fr att hlla reda p hur mnga fiender som har ddats totalt under en omgng.
p1_msg          anvnds fr att konrollera om ett specifikt tidsbegrnsat meddelande visats fr spelare 1. 
p2_msg          samma som ovan fr spelare 2.
frame           anvnds fr att kontrollera hur mnga frames som visats sedan spel-loopens start. Anvnds
                bland annat fr att kontrollera nr fiender ska genereras.
spawn_rate      anvnds tillsammans med "frame" fr att avgra nr fiender ska genereras.
players         representerar antalet spelare i den aktuella omgngen.
game_over       anvnds fr att frn spel-loopen avgra om spelaren frlorat omgngen.
'''
import os, pygame
from pygame.locals import *

quit_game = False
total_kills = 0
p1_msg = False
p2_msg = False
frame = 0
spawn_rate = 120
players = 0
game_over = False

def load_image(name, colorkey=None):
    path = os.path.join(name)
    try:
        image = pygame.image.load(path)
    except pygame.error, message:
        print 'Cannot load image:', name
        raise SystemExit, message
    image = image.convert()
    if colorkey is not None:
        if colorkey is -1:
            colorkey = image.get_at((0, 0))
        image.set_colorkey(colorkey, RLEACCEL)
    return image

def load_sound(name):
    class NoneSound:
        def play(self): pass
    if not pygame.mixer:
        return NoneSound()
    path = os.path.join(name)
    try:
        sound = pygame.mixer.Sound(path)
    except pygame.error, message:
        print 'Cannot load sound:', name
        raise SystemExit, message
    return sound
    