# -*- coding: cp1252 -*-
'''
Created on 22 aug 2012

@author: Dan Torberg

Modul innehllande klassen Enemy samt ett antal subklasser till Enemy. Basklassen (Enemy) har en variabel "frame" som anvnds fr att 
hlla koll p tiden i animationen av karaktren. Den har ven en variabel "last_hit" som innehller den senaste spelaren som trffade 
fienden. Detta fr att kunna hlla koll p antal "kills" per spelare.

Metoden update() kontrollerar ifall fienden r dd och om den r det s tas objektet bort ur spelet och "total_kills" kas med 1. ven
variabeln kills hos spelaren som skt sista skottet uppdateras. Om fienden fortfarande lever s flyttas den enligt variablerna Xspeed 
samt Yspeed.

Metoden hit() minskar variabeln "lives" med 1 och spelar upp ett ljud som representerar en trff.

Varje subklass har sin egen __init__()-metod s att de kan ha olika antal liv samt olika hastighet. De har ven en egen draw()-metod
s att varje unik fiende ska kunna ha olika utseende samt olika animationer.
'''
import pygame, Globals, Message
from pygame.locals import *

pygame.mixer.init()

splat_sound = Globals.load_sound('sounds/splat.wav')
wilhelm = Globals.load_sound('sounds/WilhelmScream.wav')

class Enemy(pygame.sprite.Sprite):

    def __init__(self, x, y):
        pygame.sprite.Sprite.__init__(self)
        self.image = Globals.load_image('images/zombie_hp.png', -1)
        self.rect = pygame.Rect((x, y), (37, 65))
        self.frame = 0
        self.lives = 1
        self.Xspeed = 0
        self.Yspeed = 0
        self.last_hit = None
        self.is_alive = True
        self.marked = False
        
    def update(self, sprites, screen):
        if self.marked:
            sprites.remove(self)
        if self.lives < 1 and self.is_alive:
            self.is_alive = False
            self.frame = 0
            self.Xspeed = 0
            self.last_hit.kills += 1
            Globals.total_kills += 1
            
        self.rect = self.rect.move(self.Xspeed, self.Yspeed)
        
        if self.rect.right < 1:
            sprites.remove(self)
            if not Globals.game_over:
                wilhelm.play()
                Globals.game_over = True
                text = pygame.font.Font(None, 48).render("Game over", 2, (255,0,0))
                sprites.add(Message.Message(text ,screen.get_width()/2 -text.get_width()/2 ,screen.get_height()/2 - text.get_height()/2 ,360))
        
    def hit(self, origin):
        self.last_hit = origin
        self.lives -= 1
        splat_sound.play()
        
    def draw(self, screen):
        screen.blit(self.image, self.rect.topleft)
        
class Zombie(Enemy):

    def __init__(self, x, y):
        super(Zombie, self).__init__(x, y)
        self.Xspeed = -2
        self.Yspeed = 0
        self.lives = 3
        
    def draw(self, screen):
        diff = 0
        if self.lives == 3:
            diff = 117*2
        elif self.lives == 2:
            diff = 117
        
        if self.frame == 60:
            self.frame = 0
        else:
            self.frame += 1
            
        if self.is_alive:
            if self.frame <= 15:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (1 + diff, 139, 37, 66))
            elif self.frame > 15 and self.frame <= 30:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (40 + diff, 139, 37, 66))
            elif self.frame > 30 and self.frame <= 45:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (79 + diff, 139, 37, 66))
            elif self.frame > 45 and self.frame <= 60:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (40 + diff, 139, 37, 66))
        else:
            if self.frame <= 15:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (352, 139, 37, 66))
            elif self.frame > 15 and self.frame <= 30:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (391, 139, 37, 66))
            elif self.frame > 30 and self.frame <= 45:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (430, 139, 37, 66))
            elif self.frame > 45:
                self.marked = True
        
class FastZombie(Enemy):
    
    def __init__(self, x, y):
        super(FastZombie, self).__init__(x, y)
        self.Xspeed = -4
        self.Yspeed = 0
        self.lives = 3
        
    def draw(self, screen):
        diff = 0
        if self.lives == 3:
            diff = 117*2
        elif self.lives == 2:
            diff = 117
 
        if self.frame == 60:
            self.frame = 0
        else:
            self.frame += 1
            
        if self.is_alive:
            if self.frame <= 15:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (1 + diff, 1, 37, 70))
            elif self.frame > 15 and self.frame <= 30:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (40 + diff, 1, 37, 70))
            elif self.frame > 30 and self.frame <= 45:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (79 + diff, 1, 37, 70))
            elif self.frame > 45 and self.frame <= 60:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (40 + diff, 1, 37, 70))
        else:
            if self.frame <= 15:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (352, 1, 37, 70))
            elif self.frame > 15 and self.frame <= 30:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (391, 1, 37, 70))
            elif self.frame > 30 and self.frame <= 45:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (430, 1, 37, 70))
            elif self.frame > 45:
                self.marked = True
                
class StrongZombie(Enemy):
    
    def __init__(self, x, y):
        super(StrongZombie, self).__init__(x, y)
        self.Xspeed = -1
        self.Yspeed = 0
        self.lives = 9
        
    def draw(self, screen):
        diff = 0
        if self.lives > 6:
            diff = 117*2
        elif self.lives > 3 and self.lives < 7:
            diff = 117
        
        if self.frame == 60:
            self.frame = 0
        else:
            self.frame += 1
            
        if self.is_alive:
            if self.frame <= 15:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (1 + diff, 72, 37, 66))
            elif self.frame > 15 and self.frame <= 30:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (40 + diff, 72, 37, 66))
            elif self.frame > 30 and self.frame <= 45:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (79 + diff, 72, 37, 66))
            elif self.frame > 45 and self.frame <= 60:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (40 + diff, 72, 37, 66))
        else:
            if self.frame <= 15:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (352, 72, 37, 66))
            elif self.frame > 15 and self.frame <= 30:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (391, 72, 37, 66))
            elif self.frame > 30 and self.frame <= 45:
                screen.blit(self.image, (self.rect.left, self.rect.top-6), (430, 72, 37, 66))
            elif self.frame > 45:
                self.marked = True
