# -*- coding: cp1252 -*-
'''
Created on 22 aug 2012

@author: Dan Torberg

Modul innehllande klassen som representerar Projektiler. Den har en update()-metod som flyttar objektet samt kollar om det kolliderat 
med antingen kanten eller ett annat objekt. Den har ven metoden draw() fr att rita ut objektet och metoderna detectBorder() samt 
detectCollision() fr att kontrollera kollisioner.
'''
import pygame, Enemy, Globals, Blood
from pygame.locals import *

class Bullet(pygame.sprite.Sprite):
    
    def __init__(self, place, ySpeed, origin):
        pygame.sprite.Sprite.__init__(self)
        self.image= Globals.load_image('images/bullet.png', -1)
        self.rect = pygame.Rect(place, (5, 3))
        self.Xspeed = 20
        self.Yspeed = ySpeed
        self.origin = origin
        
    def update(self, sprites, screen):
        self.rect = self.rect.move(self.Xspeed, self.Yspeed)
        self.detectBorder(sprites, screen)
        self.detectCollision(sprites)
        
    def draw(self, screen):
        screen.blit(self.image, self.rect.topleft)
    
    '''
    Metod som kontollerar om objektet har kolliderat med en kant och om s r fallet tar bort objektet ur spelet.
    '''    
    def detectBorder(self, sprites, screen):
        if self.rect.right > screen.get_width() or self.rect.left < 0:
            sprites.remove(self)
        if self.rect.bottom > screen.get_height() or self.rect.top < 0:
            sprites.remove(self)
    
    '''
    Metod som kontollerar om objektet har kolliderat med ett annat spelobjekt som tillhr klassen Enemy. Om s r fallet s 
    plockas objektet(self) ur spelet och metoden hit() anropas hos det fiendeobjekt som blev trffat
    '''  
    def detectCollision(self, sprites):

        for sprite in sprites:
            if isinstance(sprite, Enemy.Enemy):
                if self.rect.colliderect(sprite):
                    sprites.remove(self)
                    sprite.hit(self.origin)
                    blood = Blood.Blood(self.rect.topleft)
                    sprites.add(blood)
