/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.taongad.scene.Scene;

public class TwisterScene
extends Scene {
    Texture twisterRed;
    Texture twisterGreen;
    Texture twisterBlue;
    Pixmap twisterTilePixRed;
    Pixmap twisterTilePixGreen;
    Pixmap twisterTilePixBlue;
    Pixmap twisterPixRed;
    Pixmap twisterPixGreen;
    Pixmap twisterPixBlue;
    int[] twisterRedOffs;
    int[] twisterGreenOffs;
    int[] twisterBlueOffs;
    Texture star;
    List<Star> stars = new ArrayList<Star>();
    float lastSpawnTimeMSec;
    Random rng = new Random();
    final float STAR_SPAWN_INTERVAL = 10.0f;
    final float STAR_SPAWN_RATE = 0.8f;
    final float STAR_MIN_SPAWN_TIME = 500.0f;
    final int NUM_STARS_MAX = 500;
    Pixmap backBuffer;
    Texture backBufferTexture;
    final int BACKBUFFER_W = 256;
    final int BACKBUFFER_H = 144;

    @Override
    public void load() {
        this.batch = new SpriteBatch();
        this.disposables.add(this.batch);
        this.backBuffer = new Pixmap(256, 144, Pixmap.Format.RGB888);
        this.backBufferTexture = new Texture(this.backBuffer);
        this.disposables.add(this.backBufferTexture);
        this.twisterTilePixRed = new Pixmap(Gdx.files.internal("gfx/twister_red_rmk.png"));
        this.twisterPixRed = new Pixmap(this.twisterTilePixRed.getWidth() * 6, 144, Pixmap.Format.RGBA8888);
        this.twisterTilePixGreen = new Pixmap(Gdx.files.internal("gfx/twister_green_rmk.png"));
        this.twisterPixGreen = new Pixmap(this.twisterTilePixGreen.getWidth() * 6, 144, Pixmap.Format.RGBA8888);
        this.twisterTilePixBlue = new Pixmap(Gdx.files.internal("gfx/twister_blue_rmk.png"));
        this.twisterPixBlue = new Pixmap(this.twisterTilePixGreen.getWidth() * 6, 144, Pixmap.Format.RGBA8888);
        this.twisterRed = new Texture(this.twisterPixRed);
        this.twisterGreen = new Texture(this.twisterPixGreen);
        this.twisterBlue = new Texture(this.twisterPixBlue);
        this.disposables.add(this.twisterPixRed);
        this.disposables.add(this.twisterTilePixRed);
        this.disposables.add(this.twisterRed);
        this.disposables.add(this.twisterGreen);
        this.disposables.add(this.twisterBlue);
        Pixmap starPix = new Pixmap(5, 5, Pixmap.Format.RGBA8888);
        starPix.setColor(Color.WHITE);
        starPix.drawRectangle(1, 1, 3, 3);
        starPix.drawLine(2, 0, 2, 4);
        starPix.drawLine(0, 2, 4, 2);
        this.star = new Texture(starPix);
        starPix.dispose();
        this.disposables.add(this.star);
    }

    private void updateTwister(Pixmap targetPixmap, Pixmap twisterTilePixmap, float waveLength, float offset) {
        float timeScale = 3.0E-4f;
        float wave = MathUtils.sin((offset + this.time) * timeScale * (float)Math.PI);
        float speed = MathUtils.sin((offset + this.time) * timeScale * (float)Math.PI);
        float wave2 = MathUtils.sin((740.0f + this.time) * timeScale * (float)Math.PI);
        targetPixmap.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        targetPixmap.fill();
        int y = 0;
        while (y < targetPixmap.getHeight()) {
            wave = 0.5f + MathUtils.sin((this.time + (float)y * waveLength) * timeScale * (float)Math.PI) * 0.5f;
            wave = Math.abs(wave);
            wave2 = 0.5f + MathUtils.sin(((float)y + offset + this.time) * 6.0E-4f * (float)Math.PI) * 0.5f;
            wave2 = Math.abs(wave2);
            speed = MathUtils.sin(((float)y + this.time) * timeScale * (float)Math.PI % (float)Math.PI);
            speed = Math.abs(speed);
            targetPixmap.drawPixmap(twisterTilePixmap, (int)(wave2 * 100.0f) % 100, y, 0, (int)(wave * (5.0f * speed) * 30.0f) % 21, 20, 1);
            ++y;
        }
    }

    @Override
    public void draw(float deltaTimeMSec) {
        Gdx.gl.glClear(16384);
        this.time += deltaTimeMSec;
        this.updateTwisters();
        this.batch.begin();
        this.drawStarField();
        this.drawTwisters();
        this.batch.end();
    }

    private void drawStarField() {
        if (this.stars.size() < 500) {
            float spawnTime = this.time - this.lastSpawnTimeMSec;
            if (spawnTime > 500.0f) {
                this.stars.add(new Star(128.0f, 72.0f, this.time));
                this.lastSpawnTimeMSec = this.time;
            } else if (spawnTime > 10.0f && this.rng.nextFloat() < 0.8f) {
                this.stars.add(new Star((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, this.time));
                this.lastSpawnTimeMSec = this.time;
            }
        }
        int i = 0;
        while (i < this.stars.size()) {
            Star myStar = this.stars.get(i);
            myStar.draw(this.time);
            if (myStar.isDead(this.time)) {
                this.stars.remove(i);
            }
            ++i;
        }
    }

    private void updateTwisters() {
        this.updateTwister(this.twisterPixRed, this.twisterTilePixRed, 12.0f, 0.0f);
        this.updateTwister(this.twisterPixGreen, this.twisterTilePixGreen, 4.0f, 1200.0f);
        this.updateTwister(this.twisterPixBlue, this.twisterTilePixBlue, 7.0f, 2000.0f);
    }

    private void drawTwisters() {
        float timeScale = 3.0E-4f;
        float wave = MathUtils.sin(this.time * timeScale * (float)Math.PI);
        float wave2 = MathUtils.sin((this.time + 12000.0f) * timeScale * (float)Math.PI);
        float wave3 = MathUtils.sin((this.time + 7000.0f) * timeScale * (float)Math.PI);
        this.twisterRed.draw(this.twisterPixRed, 0, 0);
        this.twisterGreen.draw(this.twisterPixGreen, 0, 0);
        this.twisterBlue.draw(this.twisterPixBlue, 0, 0);
        float tint = 0.3f;
        float twisterWidth = 160.0f;
        this.batch.setColor(tint, tint, tint, 1.0f);
        this.batch.draw(this.twisterRed, 160.0f, 0.0f, twisterWidth * 6.0f, (float)Gdx.graphics.getHeight(), 0, 0, this.twisterPixRed.getWidth(), this.twisterPixRed.getHeight(), false, false);
        tint = 0.5f;
        this.batch.setColor(tint, tint, tint, 1.0f);
        this.batch.draw(this.twisterGreen, 160.0f, 0.0f, twisterWidth * 6.0f, (float)Gdx.graphics.getHeight(), 0, 0, this.twisterPixGreen.getWidth(), this.twisterPixGreen.getHeight(), false, false);
        this.batch.setColor(Color.WHITE);
        this.batch.draw(this.twisterBlue, 160.0f, 0.0f, twisterWidth * 6.0f, (float)Gdx.graphics.getHeight(), 0, 0, this.twisterPixBlue.getWidth(), this.twisterPixBlue.getHeight(), false, false);
    }

    class Star {
        Random rng = new Random();
        float x;
        float y;
        float speedX;
        float speedY;
        float startTime;
        float speed;
        static final float TIME_TO_LIVE_MSEC = 5000.0f;
        static final float STAR_MAX_SCALE = 8.0f;
        static final float SPEED_ACCELERATION = 0.12f;
        static final float MIN_STEP_TIME = 11.111111f;
        float lastUpdate;

        public Star(float x, float y, float startTime) {
            this.x = x;
            this.y = y;
            TwisterScene.this.lastSpawnTimeMSec = this.startTime = startTime;
            this.speed = 0.0f;
            float dirRandom = this.rng.nextFloat();
            float direction = dirRandom * ((float)Math.PI * 2);
            this.speedY = MathUtils.sin(direction);
            this.speedX = MathUtils.cos(direction);
        }

        public boolean isDead(float currentTimeMSec) {
            return currentTimeMSec - this.startTime >= 5000.0f;
        }

        public void draw(float currentTimeMSec) {
            if (currentTimeMSec - this.lastUpdate >= 11.111111f) {
                this.speed += 0.12f;
                this.x += this.speed * this.speedX;
                this.y += this.speed * this.speedY;
                this.lastUpdate = currentTimeMSec;
            }
            float scale = (currentTimeMSec - this.startTime) / 5000.0f * 8.0f;
            TwisterScene.this.batch.draw(TwisterScene.this.star, this.x, this.y, 2.0f, 2.0f, TwisterScene.this.star.getWidth(), TwisterScene.this.star.getHeight(), scale, scale, 0.0f, 0, 0, TwisterScene.this.star.getWidth(), TwisterScene.this.star.getHeight(), false, false);
        }
    }
}

