/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.scene.Scene;

public class StillScene
extends Scene {
    Texture darwin;
    Texture monkeys;
    Sound blip;

    @Override
    public void load() {
        this.batch = new SpriteBatch();
        this.darwin = new Texture(Gdx.files.internal("gfx/darwin.png"));
        this.disposables.add(this.darwin);
        this.monkeys = new Texture(Gdx.files.internal("gfx/taongad_monkies.png"));
        this.disposables.add(this.monkeys);
        this.blip = Gdx.audio.newSound(Gdx.files.internal("sfx/BombBeep2.wav"));
        this.disposables.add(this.blip);
        this.anim = new AnimationSequence();
        this.anim.addEvent(new DarwinBlip(14000.0f, 14400.0f));
    }

    @Override
    public void draw(float deltaTimeMSec) {
        this.batch.begin();
        this.batch.draw(this.monkeys, 0.0f, 0.0f);
        this.anim.update(deltaTimeMSec);
        this.batch.end();
    }

    class DarwinBlip
    extends AnimationEvent {
        boolean hasPlayed;

        public DarwinBlip(float startTime, float endTime) {
            super(startTime, endTime);
            this.hasPlayed = false;
        }

        @Override
        public void update(float deltaTimeMSec) {
            StillScene.this.batch.draw(StillScene.this.darwin, 0.0f, 0.0f);
            if (!this.hasPlayed) {
                StillScene.this.blip.play();
                this.hasPlayed = true;
            }
        }

        @Override
        public void draw() {
        }
    }
}

