/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import org.taongad.scene.Scene;

public class RotoZoomScene
extends Scene {
    Texture zoomTex;

    @Override
    public void load() {
        this.batch = new SpriteBatch(1);
        this.disposables.add(this.batch);
        Pixmap tileImage = new Pixmap(Gdx.files.internal("gfx/feynman.png"));
        int pixW = 2560;
        int pixH = 720;
        Pixmap zoomImage = new Pixmap(pixW, pixW, Pixmap.Format.RGBA8888);
        int w = tileImage.getWidth();
        int h = tileImage.getHeight();
        int xTile = 0;
        while (xTile * w <= zoomImage.getWidth()) {
            int yTile = 0;
            while (yTile * h <= zoomImage.getHeight()) {
                zoomImage.drawPixmap(tileImage, xTile * w, yTile * h);
                ++yTile;
            }
            ++xTile;
        }
        tileImage.dispose();
        this.zoomTex = new Texture(zoomImage);
        zoomImage.dispose();
        this.disposables.add(this.zoomTex);
    }

    @Override
    public void draw(float deltaTimeMSec) {
        Gdx.gl.glClear(16384);
        float timeScale = 3.0E-4f;
        float wave = MathUtils.sin(this.time * timeScale * (float)Math.PI % (float)Math.PI);
        int w = this.zoomTex.getWidth();
        int h = this.zoomTex.getHeight();
        float halfW = (float)w / 2.0f;
        float halfH = (float)h / 2.0f;
        this.time += deltaTimeMSec;
        this.batch.begin();
        float yRatio = 0.5625f;
        this.batch.draw(this.zoomTex, 640.0f - halfW, 320.0f - halfH * yRatio, halfW + 32.0f, halfH * yRatio + 24.0f * yRatio, w, h, 1.0f + wave * 13.0f, 1.0f + wave * 13.0f, this.time / 20.0f, 0, 0, w, h, false, false);
        this.batch.end();
    }
}

