/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import java.util.ArrayList;
import java.util.List;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.scene.Scene;

public class IntroScene
extends Scene {
    BitmapFont font;
    static final int DEMO_TEXT_OFFSET_Y = 460;
    static final int DEMO_TEXT_OFFSET_X = 210;
    static final int DEMO_TEXT_OFFSET_X_P1 = 330;
    static final int DEMO_TEXT_INSET = 10;
    static final int TEXT_ROW_HEIGHT = 120;
    static final String TEXT_ROW1_P1 = "Hello Birdie";
    static final String TEXT_ROW1_P2 = "Are you ready to";
    static final String TEXT_ROW2_P2 = "demo like in 1993?";
    static final int STOP_COUNTER_INIT_VAL = 10;
    static final int DEMO_TEXT_ROW1_P1_LEN = "Hello Birdie".length() + 1;
    static final int DEMO_TEXT_ROW1_P2_LEN = "Are you ready to".length() + 1;
    static final int DEMO_TEXT_ROW2_P2_LEN = "demo like in 1993?".length();
    static final int DEMO_TEXT_TOTAL_LEN = DEMO_TEXT_ROW1_P2_LEN + DEMO_TEXT_ROW2_P2_LEN;
    static final float STEP_TIME = 100.0f;
    int cursorPos = 0;
    int line1Pos = 0;
    int line2Pos = 0;
    float time = 0.0f;
    Sound blip;
    Screens screens;
    Texture background;

    @Override
    public void load() {
        this.batch = new SpriteBatch();
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/LCD-U___.TTF"));
        this.font = generator.generateFont(110);
        generator.dispose();
        this.disposables.add(this.font);
        this.background = new Texture(Gdx.files.internal("gfx/background.png"));
        this.blip = Gdx.audio.newSound(Gdx.files.internal("sfx/BombBeep2.wav"));
        this.disposables.add(this.blip);
        this.anim = new AnimationSequence();
        this.anim.addEvent(new StartUp(0.0f, 1500.0f));
        this.anim.addEvent(new HelloBirdie(1500.0f, 20000.0f));
    }

    private void setupScreens() {
        ArrayList<TextRow> rowsP1 = new ArrayList<TextRow>();
        ArrayList<Word> wordsP1R1 = new ArrayList<Word>();
        wordsP1R1.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/hello.wav")), "Hello"));
        wordsP1R1.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/birdie.wav")), "Birdie"));
        rowsP1.add(new TextRow(wordsP1R1));
        Page page1 = new Page(rowsP1, 330, 400);
        ArrayList<TextRow> rowsP2 = new ArrayList<TextRow>();
        ArrayList<Word> wordsP2R1 = new ArrayList<Word>();
        wordsP2R1.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/are.wav")), "Are"));
        wordsP2R1.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/you.wav")), "you"));
        wordsP2R1.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/ready.wav")), "ready"));
        wordsP2R1.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/to.wav")), "to"));
        ArrayList<Word> wordsP2R2 = new ArrayList<Word>();
        wordsP2R2.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/demo.wav")), "demo"));
        wordsP2R2.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/like.wav")), "like"));
        wordsP2R2.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/in.wav")), "in"));
        wordsP2R2.add(new Word(Gdx.audio.newSound(Gdx.files.internal("sfx/1993.wav")), "1993?"));
        rowsP2.add(new TextRow(wordsP2R1));
        rowsP2.add(new TextRow(wordsP2R2));
        Page page2 = new Page(rowsP2, 210, 460);
        ArrayList<Page> pages = new ArrayList<Page>();
        pages.add(page1);
        pages.add(page2);
        this.screens = new Screens(pages);
    }

    @Override
    public void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        this.anim.update(deltaTimeMSec);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.anim.draw();
        this.batch.end();
    }

    class HelloBirdie
    extends AnimationEvent {
        public HelloBirdie(float startTime, float endTime) {
            super(startTime, endTime);
            IntroScene.this.setupScreens();
            IntroScene.this.font.setColor(0.0f, 0.9f, 0.0f, 1.0f);
        }

        @Override
        public void update(float deltaTimeMSec) {
            if (IntroScene.this.time > 100.0f) {
                IntroScene.this.screens.step();
                IntroScene.this.time = 0.0f;
            }
        }

        @Override
        public void draw() {
            IntroScene.this.batch.draw(IntroScene.this.background, 0.0f, 0.0f);
            IntroScene.this.screens.draw();
        }
    }

    class Page {
        final List<TextRow> rows;
        final int TEXT_OFFSET_X;
        final int TEXT_OFFSET_Y;
        int stopCounter = 10;
        int currentRowIdx;
        String renderStr;
        boolean cursorToggle;

        public Page(List<TextRow> rows, int textPosX, int textPosY) {
            this.rows = rows;
            this.TEXT_OFFSET_X = textPosX;
            this.TEXT_OFFSET_Y = textPosY;
        }

        public boolean isDone() {
            return this.currentRowIdx >= this.rows.size();
        }

        public void step() {
            if (this.stopCounter > 0) {
                --this.stopCounter;
                boolean bl = this.cursorToggle = !this.cursorToggle;
                if (this.cursorToggle) {
                    IntroScene.this.blip.play();
                }
            } else {
                TextRow currentRow = this.rows.get(this.currentRowIdx);
                if (currentRow.isDone()) {
                    if (this.currentRowIdx >= this.rows.size()) {
                        return;
                    }
                    ++this.currentRowIdx;
                } else {
                    currentRow.step();
                }
            }
        }

        public void draw() {
            if (this.stopCounter > 0) {
                if (this.cursorToggle) {
                    IntroScene.this.font.draw(IntroScene.this.batch, "_", this.TEXT_OFFSET_X, this.TEXT_OFFSET_Y);
                } else {
                    IntroScene.this.font.draw(IntroScene.this.batch, "", this.TEXT_OFFSET_X, this.TEXT_OFFSET_Y);
                }
            } else {
                int i = 0;
                while (i < this.rows.size()) {
                    IntroScene.this.font.draw(IntroScene.this.batch, this.rows.get(i).getDrawStr(), this.TEXT_OFFSET_X, this.TEXT_OFFSET_Y - 120 * i);
                    ++i;
                }
            }
        }
    }

    class Screens {
        final int WAIT_TICKS_INIT = 20;
        final List<Page> pages;
        int waitTicks = 0;
        int currentPage;

        public Screens(List<Page> pages) {
            this.pages = pages;
            this.waitTicks = 20;
        }

        public boolean isDone() {
            return this.currentPage == this.pages.size() - 1;
        }

        public void step() {
            Page page = this.pages.get(this.currentPage);
            if (page.isDone()) {
                if (!this.isDone()) {
                    if (this.waitTicks <= 0) {
                        ++this.currentPage;
                    } else {
                        --this.waitTicks;
                    }
                }
            } else {
                page.step();
            }
        }

        public void draw() {
            this.pages.get(this.currentPage).draw();
        }
    }

    class StartUp
    extends AnimationEvent {
        float duration;
        float sliceHeight;
        float animTime;
        float timeToWiden;
        float timeToHeighten;
        float bgWidth;
        float bgHeight;
        float bgPosX;
        float bgPosY;

        public StartUp(float startTime, float endTime) {
            super(startTime, endTime);
            this.sliceHeight = 20.0f;
            this.animTime = 200.0f;
            this.timeToWiden = this.animTime / 4.0f;
            this.timeToHeighten = this.animTime - this.timeToWiden;
            this.bgHeight = this.sliceHeight;
            this.bgPosX = Gdx.graphics.getWidth() / 2;
            this.bgPosY = Gdx.graphics.getHeight() / 2;
        }

        @Override
        public void update(float deltaTimeMSec) {
            this.duration += deltaTimeMSec;
            float widthFactor = this.duration / this.timeToWiden > 1.0f ? 1.0f : this.duration / this.timeToWiden;
            this.bgPosX = (float)(Gdx.graphics.getWidth() / 2) - (float)(Gdx.graphics.getWidth() / 2) * widthFactor;
            this.bgWidth = (float)Gdx.graphics.getWidth() * widthFactor;
            float heightTime = this.duration - this.timeToWiden < 0.0f ? 0.0f : this.duration - this.timeToWiden;
            float heightFactor = heightTime / this.timeToHeighten > 1.0f ? 1.0f : heightTime / this.timeToHeighten;
            this.bgPosY = (float)(Gdx.graphics.getHeight() / 2) - (float)(Gdx.graphics.getHeight() / 2) * heightFactor;
            this.bgHeight = (float)Gdx.graphics.getHeight() * heightFactor;
        }

        @Override
        public void draw() {
            IntroScene.this.batch.draw(IntroScene.this.background, this.bgPosX, this.bgPosY - this.sliceHeight / 2.0f, this.bgWidth, this.bgHeight);
        }
    }

    class TextRow {
        int rowPos;
        boolean cursorToggle;
        List<Word> words;

        public TextRow(List<Word> words) {
            this.words = words;
        }

        public boolean isDone() {
            return this.words.get(this.words.size() - 1).isDone();
        }

        public void step() {
            if (!this.isDone()) {
                Word currentWord = this.words.get(this.rowPos);
                currentWord.step();
                if (currentWord.isDone() && this.rowPos != this.words.size() - 1) {
                    ++this.rowPos;
                }
            }
            this.cursorToggle = !(this.rowPos == 0 && this.words.get(this.rowPos).getPos() == 0 || this.rowPos == this.words.size() - 1 && this.words.get(this.rowPos).isDone());
        }

        public String getDrawStr() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.words.size()) {
                Word currentWord = this.words.get(i);
                if (currentWord.isDone()) {
                    sb.append(currentWord.getStr());
                    if (i != this.words.size() - 1) {
                        sb.append(" ");
                    }
                }
                ++i;
            }
            if (!this.words.get(this.rowPos).isDone()) {
                sb.append(this.words.get(this.rowPos).getStr());
            }
            if (this.cursorToggle) {
                return sb.append("_").toString();
            }
            return sb.toString();
        }
    }

    class Word {
        Sound voice;
        String text;
        int textPos;

        public Word(Sound voice, String text) {
            this.voice = voice;
            this.text = text;
        }

        public String getStr() {
            return this.text.substring(0, this.textPos);
        }

        public int getPos() {
            return this.textPos;
        }

        public boolean isDone() {
            return this.textPos >= this.text.length();
        }

        public void step() {
            if (!this.isDone()) {
                if (this.textPos == 0) {
                    this.voice.play();
                }
                ++this.textPos;
                IntroScene.this.blip.play();
            }
        }
    }
}

