/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.taongad.scene.Scene;
import org.taongad.utils.Ball;
import org.taongad.utils.MarchingSquare;
import org.taongad.utils.MarchingSquaresField;
import org.taongad.utils.Point;

public class BallsToTheWallScene
extends Scene {
    private Logger log;
    private Ball[] balls;
    private Ball[] rythm_balls;
    private SpriteBatch batch;
    private float total_time;
    private List<MarchingSquaresField> fields;
    private TextureRegion[] squares_gfx_grey;
    private TextureRegion squares_gfx_grey_1010_over_treshhold;
    private TextureRegion squares_gfx_grey_0101_over_treshhold;
    private Texture marching_squarez_grey_png;
    private TextureRegion[] squares_gfx_red;
    private TextureRegion squares_gfx_red_1010_over_treshhold;
    private TextureRegion squares_gfx_red_0101_over_treshhold;
    private Texture marching_squarez_red_png;
    private TextureRegion[] squares_gfx_blue;
    private TextureRegion squares_gfx_blue_1010_over_treshhold;
    private TextureRegion squares_gfx_blue_0101_over_treshhold;
    private Texture marching_squarez_blue_png;
    private TextureRegion[] squares_gfx_green;
    private TextureRegion squares_gfx_green_1010_over_treshhold;
    private TextureRegion squares_gfx_green_0101_over_treshhold;
    private Texture marching_squarez_green_png;
    private TextureRegion[] squares_gfx_yellow;
    private TextureRegion squares_gfx_yellow_1010_over_treshhold;
    private TextureRegion squares_gfx_yellow_0101_over_treshhold;
    private Texture marching_squarez_yellow_png;
    private static int RYTHM_BALLS_DELTA;
    private static int NUMBER_OF_SQUARES;
    private static float TRESHHOLD_DRAW;
    private static float TRESHHOLD_CALCULATE;
    private static int MARCHING_SQUARES_FIELD_STEP;
    private static int NUMBER_OF_BALLS;
    private static float BALLS_RADIE;
    private static float RYTHM_BALL_MAX_RADIUS;
    private static float RYTHM_BALL_MIN_RADIUS;
    private static boolean RYTHM_BALLS_IS_ACTIVE;
    private static float RYTHM_BALLS_RADIUS_DECREASE;
    private static Ball[] T;
    private static int COUNT;
    private static int BALL_TO_BOUNCE;

    static {
        NUMBER_OF_SQUARES = 16;
        MARCHING_SQUARES_FIELD_STEP = 8;
        TRESHHOLD_DRAW = 0.3f;
        TRESHHOLD_CALCULATE = 2.0f;
        NUMBER_OF_BALLS = 4;
        BALLS_RADIE = 0.9f;
        RYTHM_BALL_MAX_RADIUS = 1.0f;
        RYTHM_BALL_MIN_RADIUS = 0.2f;
        RYTHM_BALLS_IS_ACTIVE = true;
        RYTHM_BALLS_RADIUS_DECREASE = 0.009f;
        RYTHM_BALLS_DELTA = 27;
        T = new Ball[NUMBER_OF_BALLS + 4];
        COUNT = 12;
        BALL_TO_BOUNCE = 0;
    }

    @Override
    public void load() {
        this.log = Logger.getLogger(BallsToTheWallScene.class.getName());
        this.fields = new ArrayList<MarchingSquaresField>();
        this.fields.add(new MarchingSquaresField(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), MARCHING_SQUARES_FIELD_STEP, MARCHING_SQUARES_FIELD_STEP));
        this.marching_squarez_grey_png = new Texture(Gdx.files.internal("gfx/marching_squarez.png"));
        this.disposables.add(this.marching_squarez_grey_png);
        this.squares_gfx_grey = new TextureRegion[NUMBER_OF_SQUARES];
        this.squares_gfx_grey[1] = new TextureRegion(this.marching_squarez_grey_png, 2, 35, 8, 8);
        this.squares_gfx_grey[2] = new TextureRegion(this.marching_squarez_grey_png, 11, 35, 8, 8);
        this.squares_gfx_grey[4] = new TextureRegion(this.marching_squarez_grey_png, 20, 35, 8, 8);
        this.squares_gfx_grey[8] = new TextureRegion(this.marching_squarez_grey_png, 29, 35, 8, 8);
        this.squares_gfx_grey[12] = new TextureRegion(this.marching_squarez_grey_png, 2, 24, 8, 8);
        this.squares_gfx_grey[9] = new TextureRegion(this.marching_squarez_grey_png, 11, 24, 8, 8);
        this.squares_gfx_grey[3] = new TextureRegion(this.marching_squarez_grey_png, 20, 24, 8, 8);
        this.squares_gfx_grey[6] = new TextureRegion(this.marching_squarez_grey_png, 29, 24, 8, 8);
        this.squares_gfx_grey[14] = new TextureRegion(this.marching_squarez_grey_png, 2, 13, 8, 8);
        this.squares_gfx_grey[13] = new TextureRegion(this.marching_squarez_grey_png, 11, 13, 8, 8);
        this.squares_gfx_grey[11] = new TextureRegion(this.marching_squarez_grey_png, 20, 13, 8, 8);
        this.squares_gfx_grey[7] = new TextureRegion(this.marching_squarez_grey_png, 29, 13, 8, 8);
        this.squares_gfx_grey[15] = new TextureRegion(this.marching_squarez_grey_png, 52, 40, 8, 8);
        this.squares_gfx_grey[10] = new TextureRegion(this.marching_squarez_grey_png, 23, 54, 8, 8);
        this.squares_gfx_grey[5] = new TextureRegion(this.marching_squarez_grey_png, 32, 54, 8, 8);
        this.squares_gfx_grey_1010_over_treshhold = new TextureRegion(this.marching_squarez_grey_png, 4, 54, 8, 8);
        this.squares_gfx_grey_0101_over_treshhold = new TextureRegion(this.marching_squarez_grey_png, 14, 54, 8, 8);
        this.marching_squarez_blue_png = new Texture(Gdx.files.internal("gfx/marching_squarez_blue.png"));
        this.disposables.add(this.marching_squarez_blue_png);
        this.squares_gfx_blue = new TextureRegion[NUMBER_OF_SQUARES];
        this.squares_gfx_blue[1] = new TextureRegion(this.marching_squarez_blue_png, 2, 35, 8, 8);
        this.squares_gfx_blue[2] = new TextureRegion(this.marching_squarez_blue_png, 11, 35, 8, 8);
        this.squares_gfx_blue[4] = new TextureRegion(this.marching_squarez_blue_png, 20, 35, 8, 8);
        this.squares_gfx_blue[8] = new TextureRegion(this.marching_squarez_blue_png, 29, 35, 8, 8);
        this.squares_gfx_blue[12] = new TextureRegion(this.marching_squarez_blue_png, 2, 24, 8, 8);
        this.squares_gfx_blue[9] = new TextureRegion(this.marching_squarez_blue_png, 11, 24, 8, 8);
        this.squares_gfx_blue[3] = new TextureRegion(this.marching_squarez_blue_png, 20, 24, 8, 8);
        this.squares_gfx_blue[6] = new TextureRegion(this.marching_squarez_blue_png, 29, 24, 8, 8);
        this.squares_gfx_blue[14] = new TextureRegion(this.marching_squarez_blue_png, 2, 13, 8, 8);
        this.squares_gfx_blue[13] = new TextureRegion(this.marching_squarez_blue_png, 11, 13, 8, 8);
        this.squares_gfx_blue[11] = new TextureRegion(this.marching_squarez_blue_png, 20, 13, 8, 8);
        this.squares_gfx_blue[7] = new TextureRegion(this.marching_squarez_blue_png, 29, 13, 8, 8);
        this.squares_gfx_blue[15] = new TextureRegion(this.marching_squarez_blue_png, 52, 40, 8, 8);
        this.squares_gfx_blue[10] = new TextureRegion(this.marching_squarez_blue_png, 23, 54, 8, 8);
        this.squares_gfx_blue[5] = new TextureRegion(this.marching_squarez_blue_png, 32, 54, 8, 8);
        this.squares_gfx_blue_1010_over_treshhold = new TextureRegion(this.marching_squarez_blue_png, 4, 54, 8, 8);
        this.squares_gfx_blue_0101_over_treshhold = new TextureRegion(this.marching_squarez_blue_png, 14, 54, 8, 8);
        this.marching_squarez_red_png = new Texture(Gdx.files.internal("gfx/marching_squarez_red.png"));
        this.disposables.add(this.marching_squarez_red_png);
        this.squares_gfx_red = new TextureRegion[NUMBER_OF_SQUARES];
        this.squares_gfx_red[1] = new TextureRegion(this.marching_squarez_red_png, 2, 35, 8, 8);
        this.squares_gfx_red[2] = new TextureRegion(this.marching_squarez_red_png, 11, 35, 8, 8);
        this.squares_gfx_red[4] = new TextureRegion(this.marching_squarez_red_png, 20, 35, 8, 8);
        this.squares_gfx_red[8] = new TextureRegion(this.marching_squarez_red_png, 29, 35, 8, 8);
        this.squares_gfx_red[12] = new TextureRegion(this.marching_squarez_red_png, 2, 24, 8, 8);
        this.squares_gfx_red[9] = new TextureRegion(this.marching_squarez_red_png, 11, 24, 8, 8);
        this.squares_gfx_red[3] = new TextureRegion(this.marching_squarez_red_png, 20, 24, 8, 8);
        this.squares_gfx_red[6] = new TextureRegion(this.marching_squarez_red_png, 29, 24, 8, 8);
        this.squares_gfx_red[14] = new TextureRegion(this.marching_squarez_red_png, 2, 13, 8, 8);
        this.squares_gfx_red[13] = new TextureRegion(this.marching_squarez_red_png, 11, 13, 8, 8);
        this.squares_gfx_red[11] = new TextureRegion(this.marching_squarez_red_png, 20, 13, 8, 8);
        this.squares_gfx_red[7] = new TextureRegion(this.marching_squarez_red_png, 29, 13, 8, 8);
        this.squares_gfx_red[15] = new TextureRegion(this.marching_squarez_red_png, 52, 40, 8, 8);
        this.squares_gfx_red[10] = new TextureRegion(this.marching_squarez_red_png, 23, 54, 8, 8);
        this.squares_gfx_red[5] = new TextureRegion(this.marching_squarez_red_png, 32, 54, 8, 8);
        this.squares_gfx_red_1010_over_treshhold = new TextureRegion(this.marching_squarez_red_png, 4, 54, 8, 8);
        this.squares_gfx_red_0101_over_treshhold = new TextureRegion(this.marching_squarez_red_png, 14, 54, 8, 8);
        this.marching_squarez_yellow_png = new Texture(Gdx.files.internal("gfx/marching_squarez_yellow.png"));
        this.disposables.add(this.marching_squarez_yellow_png);
        this.squares_gfx_yellow = new TextureRegion[NUMBER_OF_SQUARES];
        this.squares_gfx_yellow[1] = new TextureRegion(this.marching_squarez_yellow_png, 2, 35, 8, 8);
        this.squares_gfx_yellow[2] = new TextureRegion(this.marching_squarez_yellow_png, 11, 35, 8, 8);
        this.squares_gfx_yellow[4] = new TextureRegion(this.marching_squarez_yellow_png, 20, 35, 8, 8);
        this.squares_gfx_yellow[8] = new TextureRegion(this.marching_squarez_yellow_png, 29, 35, 8, 8);
        this.squares_gfx_yellow[12] = new TextureRegion(this.marching_squarez_yellow_png, 2, 24, 8, 8);
        this.squares_gfx_yellow[9] = new TextureRegion(this.marching_squarez_yellow_png, 11, 24, 8, 8);
        this.squares_gfx_yellow[3] = new TextureRegion(this.marching_squarez_yellow_png, 20, 24, 8, 8);
        this.squares_gfx_yellow[6] = new TextureRegion(this.marching_squarez_yellow_png, 29, 24, 8, 8);
        this.squares_gfx_yellow[14] = new TextureRegion(this.marching_squarez_yellow_png, 2, 13, 8, 8);
        this.squares_gfx_yellow[13] = new TextureRegion(this.marching_squarez_yellow_png, 11, 13, 8, 8);
        this.squares_gfx_yellow[11] = new TextureRegion(this.marching_squarez_yellow_png, 20, 13, 8, 8);
        this.squares_gfx_yellow[7] = new TextureRegion(this.marching_squarez_yellow_png, 29, 13, 8, 8);
        this.squares_gfx_yellow[15] = new TextureRegion(this.marching_squarez_yellow_png, 52, 40, 8, 8);
        this.squares_gfx_yellow[10] = new TextureRegion(this.marching_squarez_yellow_png, 23, 54, 8, 8);
        this.squares_gfx_yellow[5] = new TextureRegion(this.marching_squarez_yellow_png, 32, 54, 8, 8);
        this.squares_gfx_yellow_1010_over_treshhold = new TextureRegion(this.marching_squarez_yellow_png, 4, 54, 8, 8);
        this.squares_gfx_yellow_0101_over_treshhold = new TextureRegion(this.marching_squarez_yellow_png, 14, 54, 8, 8);
        this.marching_squarez_green_png = new Texture(Gdx.files.internal("gfx/marching_squarez_green.png"));
        this.disposables.add(this.marching_squarez_green_png);
        this.squares_gfx_green = new TextureRegion[NUMBER_OF_SQUARES];
        this.squares_gfx_green[1] = new TextureRegion(this.marching_squarez_green_png, 2, 35, 8, 8);
        this.squares_gfx_green[2] = new TextureRegion(this.marching_squarez_green_png, 11, 35, 8, 8);
        this.squares_gfx_green[4] = new TextureRegion(this.marching_squarez_green_png, 20, 35, 8, 8);
        this.squares_gfx_green[8] = new TextureRegion(this.marching_squarez_green_png, 29, 35, 8, 8);
        this.squares_gfx_green[12] = new TextureRegion(this.marching_squarez_green_png, 2, 24, 8, 8);
        this.squares_gfx_green[9] = new TextureRegion(this.marching_squarez_green_png, 11, 24, 8, 8);
        this.squares_gfx_green[3] = new TextureRegion(this.marching_squarez_green_png, 20, 24, 8, 8);
        this.squares_gfx_green[6] = new TextureRegion(this.marching_squarez_green_png, 29, 24, 8, 8);
        this.squares_gfx_green[14] = new TextureRegion(this.marching_squarez_green_png, 2, 13, 8, 8);
        this.squares_gfx_green[13] = new TextureRegion(this.marching_squarez_green_png, 11, 13, 8, 8);
        this.squares_gfx_green[11] = new TextureRegion(this.marching_squarez_green_png, 20, 13, 8, 8);
        this.squares_gfx_green[7] = new TextureRegion(this.marching_squarez_green_png, 29, 13, 8, 8);
        this.squares_gfx_green[15] = new TextureRegion(this.marching_squarez_green_png, 52, 40, 8, 8);
        this.squares_gfx_green[10] = new TextureRegion(this.marching_squarez_green_png, 23, 54, 8, 8);
        this.squares_gfx_green[5] = new TextureRegion(this.marching_squarez_green_png, 32, 54, 8, 8);
        this.squares_gfx_green_1010_over_treshhold = new TextureRegion(this.marching_squarez_green_png, 4, 54, 8, 8);
        this.squares_gfx_green_0101_over_treshhold = new TextureRegion(this.marching_squarez_green_png, 14, 54, 8, 8);
        this.balls = new Ball[NUMBER_OF_BALLS];
        Vector3 min = new Vector3();
        Vector3 max = new Vector3(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), 0.0f);
        int i = 0;
        while (i < this.balls.length) {
            this.balls[i] = new Ball(min, max, BALLS_RADIE);
            ++i;
        }
        Vector3 pos = new Vector3();
        this.rythm_balls = new Ball[4];
        int corner = 140;
        pos.x = corner;
        pos.y = corner;
        this.rythm_balls[0] = new Ball(pos, RYTHM_BALL_MIN_RADIUS);
        this.rythm_balls[0].color = Color.RED;
        pos.x = Gdx.graphics.getWidth() - corner;
        pos.y = corner;
        this.rythm_balls[1] = new Ball(pos, RYTHM_BALL_MIN_RADIUS);
        this.rythm_balls[1].color = Color.GREEN;
        pos.x = Gdx.graphics.getWidth() - corner;
        pos.y = Gdx.graphics.getHeight() - corner;
        this.rythm_balls[2] = new Ball(pos, RYTHM_BALL_MIN_RADIUS);
        this.rythm_balls[2].color = Color.BLUE;
        pos.x = corner;
        pos.y = Gdx.graphics.getHeight() - corner;
        this.rythm_balls[3] = new Ball(pos, RYTHM_BALL_MIN_RADIUS);
        this.rythm_balls[3].color = Color.YELLOW;
        this.total_time = 0.0f;
        this.batch = new SpriteBatch();
    }

    private TextureRegion getSquareGraphics(int type, float treshhold, Color c) {
        if (c == Color.RED) {
            if (type == 5) {
                return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_red[type] : this.squares_gfx_red_0101_over_treshhold;
            }
            if (type == 10) {
                return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_red[type] : this.squares_gfx_red_1010_over_treshhold;
            }
            return this.squares_gfx_red[type];
        }
        if (c == Color.GREEN) {
            if (type == 5) {
                return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_green[type] : this.squares_gfx_green_0101_over_treshhold;
            }
            if (type == 10) {
                return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_green[type] : this.squares_gfx_green_1010_over_treshhold;
            }
            return this.squares_gfx_green[type];
        }
        if (c == Color.BLUE) {
            if (type == 5) {
                return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_blue[type] : this.squares_gfx_blue_0101_over_treshhold;
            }
            if (type == 10) {
                return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_blue[type] : this.squares_gfx_blue_1010_over_treshhold;
            }
            return this.squares_gfx_blue[type];
        }
        if (c == Color.YELLOW) {
            if (type == 5) {
                return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_yellow[type] : this.squares_gfx_yellow_0101_over_treshhold;
            }
            if (type == 10) {
                return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_yellow[type] : this.squares_gfx_yellow_1010_over_treshhold;
            }
            return this.squares_gfx_yellow[type];
        }
        if (type == 5) {
            return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_grey[type] : this.squares_gfx_grey_0101_over_treshhold;
        }
        if (type == 10) {
            return treshhold < TRESHHOLD_DRAW ? this.squares_gfx_grey[type] : this.squares_gfx_grey_1010_over_treshhold;
        }
        return this.squares_gfx_grey[type];
    }

    private void updatePoints() {
        Ball b;
        int i = 0;
        while (i < T.length) {
            BallsToTheWallScene.T[i] = null;
            ++i;
        }
        int ppp = 0;
        Object object = this.balls;
        int n = this.balls.length;
        int n2 = 0;
        while (n2 < n) {
            BallsToTheWallScene.T[ppp] = b = object[n2];
            ++ppp;
            ++n2;
        }
        object = this.rythm_balls;
        n = this.rythm_balls.length;
        n2 = 0;
        while (n2 < n) {
            b = object[n2];
            if (b.radius > RYTHM_BALL_MIN_RADIUS) {
                BallsToTheWallScene.T[ppp] = b;
                ++ppp;
            }
            ++n2;
        }
        for (MarchingSquaresField msf : this.fields) {
            msf.reset();
            for (Point p : msf.getPoints()) {
                Ball.VALUE_AT(p, T, TRESHHOLD_CALCULATE);
            }
        }
    }

    private void moveBalls() {
        int half_w = Gdx.graphics.getWidth() / 2;
        int half_h = Gdx.graphics.getHeight() / 2;
        int i = 0;
        Ball[] ballArray = this.balls;
        int n = this.balls.length;
        int n2 = 0;
        while (n2 < n) {
            Ball b = ballArray[n2];
            int k = ++i % 2 == 0 ? 1 : -1;
            b.pos.x = (float)half_w + (float)(i * 100) * MathUtils.sin((float)k * this.total_time / 1000.0f);
            b.pos.y = (float)half_h + (float)(i * 100) * MathUtils.cos((float)k * this.total_time / 1000.0f);
            ++n2;
        }
    }

    @Override
    public void draw(float deltaTimeMSec) {
        this.total_time += deltaTimeMSec;
        Gdx.gl.glClear(16384);
        this.batch.setBlendFunction(1, 1);
        this.updatePoints();
        this.moveBalls();
        this.updateRythmBalls();
        this.batch.begin();
        for (MarchingSquaresField msf : this.fields) {
            for (MarchingSquare ms : msf.getSquares()) {
                int type = ms.getType(TRESHHOLD_DRAW);
                TextureRegion t = this.getSquareGraphics(type, ms.center.sum, ms.tl.nearest_ball.color);
                if (t == null) continue;
                this.batch.draw(t, ms.bl.pos.x, ms.bl.pos.y);
            }
        }
        this.batch.end();
    }

    private void updateRythmBalls() {
        if (++COUNT > RYTHM_BALLS_DELTA) {
            COUNT = 0;
            this.rythm_balls[BallsToTheWallScene.BALL_TO_BOUNCE].radius = RYTHM_BALL_MAX_RADIUS;
            if (++BALL_TO_BOUNCE >= this.rythm_balls.length) {
                BALL_TO_BOUNCE = 0;
            }
        }
        Ball[] ballArray = this.rythm_balls;
        int n = this.rythm_balls.length;
        int n2 = 0;
        while (n2 < n) {
            Ball b = ballArray[n2];
            b.radius -= RYTHM_BALLS_RADIUS_DECREASE;
            ++n2;
        }
    }
}

