/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Pool;

public class TextureAttribute
extends MaterialAttribute {
    public static final int MAX_TEXTURE_UNITS = 16;
    public static final String diffuseTexture = "diffuseTexture";
    public static final String lightmapTexture = "lightmapTexture";
    public static final String specularTexture = "specularTexture";
    public Texture texture;
    public int unit;
    public int minFilter;
    public int magFilter;
    public int uWrap;
    public int vWrap;
    private static final Pool<TextureAttribute> pool = new Pool<TextureAttribute>(){

        @Override
        protected TextureAttribute newObject() {
            return new TextureAttribute();
        }
    };

    protected TextureAttribute() {
    }

    public TextureAttribute(Texture texture, int unit, String name, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, Texture.TextureWrap uWrap, Texture.TextureWrap vWrap) {
        this(texture, unit, name, minFilter.getGLEnum(), magFilter.getGLEnum(), uWrap.getGLEnum(), vWrap.getGLEnum());
    }

    public TextureAttribute(Texture texture, int unit, String name, int minFilter, int magFilter, int uWrap, int vWrap) {
        super(name);
        this.texture = texture;
        if (unit > 16) {
            throw new RuntimeException("16 is max texture units supported");
        }
        this.unit = unit;
        this.uWrap = uWrap;
        this.vWrap = vWrap;
        this.minFilter = minFilter;
        this.magFilter = magFilter;
    }

    public TextureAttribute(Texture texture, int unit, String name) {
        this(texture, unit, name, texture.getMinFilter(), texture.getMagFilter(), texture.getUWrap(), texture.getVWrap());
    }

    @Override
    public void bind() {
        this.texture.bind(this.unit);
        Gdx.gl.glTexParameterf(3553, 10241, this.minFilter);
        Gdx.gl.glTexParameterf(3553, 10240, this.magFilter);
        Gdx.gl.glTexParameterf(3553, 10242, this.uWrap);
        Gdx.gl.glTexParameterf(3553, 10243, this.vWrap);
    }

    @Override
    public void bind(ShaderProgram program) {
        this.texture.bind(this.unit);
        Gdx.gl.glTexParameterf(3553, 10241, this.minFilter);
        Gdx.gl.glTexParameterf(3553, 10240, this.magFilter);
        Gdx.gl.glTexParameterf(3553, 10242, this.uWrap);
        Gdx.gl.glTexParameterf(3553, 10243, this.vWrap);
        program.setUniformi(this.name, this.unit);
    }

    @Override
    public MaterialAttribute copy() {
        return new TextureAttribute(this.texture, this.unit, this.name, this.minFilter, this.magFilter, this.uWrap, this.vWrap);
    }

    @Override
    public void set(MaterialAttribute attr) {
        TextureAttribute texAttr = (TextureAttribute)attr;
        this.name = texAttr.name;
        this.texture = texAttr.texture;
        this.unit = texAttr.unit;
        this.magFilter = texAttr.magFilter;
        this.minFilter = texAttr.minFilter;
        this.uWrap = texAttr.uWrap;
        this.vWrap = texAttr.vWrap;
    }

    public boolean texturePortionEquals(TextureAttribute other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.texture == other.texture && this.unit == other.unit && this.minFilter == other.minFilter && this.magFilter == other.magFilter && this.uWrap == other.uWrap && this.vWrap == other.vWrap;
    }

    @Override
    public MaterialAttribute pooledCopy() {
        TextureAttribute attr = pool.obtain();
        attr.set(this);
        return attr;
    }

    @Override
    public void free() {
        if (this.isPooled) {
            pool.free(this);
        }
    }
}

