      uniform sampler2D     rubyTexture;
      uniform vec2          rubyTextureSize;
      uniform vec2          rubyInputSize;
      uniform float rubyFrameCount;

      #define TEX2D(c) texture2D(rubyTexture,(c))

      #define PI 3.14159265

      void main()
      {
        vec2 xy = gl_TexCoord[0].st;

        vec2 xyp = xy * (rubyTextureSize)  * 4.0001 * PI / 3.0;
        xyp.y = 1.0001 * xyp.y / 1.0 + 2.0 * PI / 3.0 * mod(int(rubyFrameCount),2);

        vec4 rgb = TEX2D(xy);

        mat3x3 rgb2yuv = mat3x3(0.299,-0.14713, 0.615,
                 0.587,-0.28886,-0.51499,
                 0.114, 0.436  ,-0.10001);

        vec3 yuv;
        yuv = rgb2yuv * rgb.rgb;

        float dx = PI/3.0;
        xyp.x = xyp.x * rubyInputSize.x/256.0;
        float c0 = yuv.x + yuv.y * sin(xyp.x+xyp.y) + yuv.z*cos(xyp.x+xyp.y);
        float c1 = yuv.x + yuv.y * sin(xyp.x+xyp.y+dx) + yuv.z * cos(xyp.x+xyp.y+dx);
        rgb = TEX2D(xy + vec2(1.0/rubyTextureSize.x * rubyInputSize.x / 512.0, 0.0));
        yuv = rgb2yuv * rgb.rgb;
        float c2 = yuv.x + yuv.y * sin(xyp.x+xyp.y+2.0*dx) + yuv.z * cos(xyp.x+xyp.y+2.0*dx);
        float c3 = yuv.x + yuv.y * sin(xyp.x+xyp.y+3.0*dx) + yuv.z * cos(xyp.x+xyp.y+3.0*dx);

        gl_FragColor = (vec4(c0,c1,c2,c3)+0.65)/2.3;
        
        gl_FragColor -= 0.05*clamp(sin(gl_FragColor*1.5)*gl_FragColor, 0.1, 0.9);
        
        
        //gl_FragColor = vec4(sin(xyp)*0.5 + 0.5, 0, 1.0);
        //gl_FragColor = vec4(1, 0, 0, 0);
        //gl_FragColor = vec4(xy,0,1);
        //gl_FragColor = vec4(1,0,1,1);
      }
 

    
    