#ifndef SONGDATA
#define SONGDATA

#include "defines.h"

static const unsigned char patterns[][16] = {
    {                   /**  0 -- off */
        OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF,OFF
    },
    {                   /**  1 */
        KEY(D, 4),
        KEY(F, 4),
        KEY(A, 4),
        KEY(C, 5),
        KEY(E, 5),
        KEY(D, 4),
        KEY(F, 4),
        KEY(A, 4),
        KEY(C, 5),
        KEY(E, 5),
        KEY(D, 4),
        KEY(F, 4),
        KEY(A, 4),
        KEY(C, 5),
        KEY(E, 5),
        OFF
    },
    {                   /**  2 */
        KEY(E, 4),
        KEY(G, 4),
        KEY(B, 4),
        KEY(C, 5),
        KEY(E, 5),
        KEY(E, 4),
        KEY(G, 4),
        KEY(B, 4),
        KEY(C, 5),
        KEY(E, 5),
        KEY(E, 4),
        KEY(G, 4),
        KEY(B, 4),
        KEY(C, 5),
        KEY(E, 5),
        OFF
    },
    {                   /**  3 */
        KEY(C, 4),
        KEY(E, 4),
        KEY(G, 4),
        KEY(C, 5),
        KEY(E, 5),
        KEY(C, 4),
        KEY(E, 4),
        KEY(G, 4),
        KEY(C, 5),
        KEY(E, 5),
        KEY(C, 4),
        KEY(E, 4),
        KEY(G, 4),
        KEY(C, 5),
        KEY(E, 5),
        OFF
    },
    {                   /**  4 */
        KEY(C, 4),
        KEY(E, 4),
        KEY(F, 4),
        KEY(A, 4),
        KEY(C, 5),
        KEY(C, 4),
        KEY(E, 4),
        KEY(F, 4),
        KEY(A, 4),
        KEY(C, 5),
        KEY(C, 4),
        KEY(E, 4),
        KEY(F, 4),
        KEY(A, 4),
        KEY(C, 5),
        OFF
    },
    "k---k---k---k---", /**  5 */
    "----s--s----s---", /**  6 */
    "-xox-xox-xox-xoo", /**  7 */
    {                   /**  8 */
        KEY(A, 2),HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD
    },
    {                   /**  9 */
        KEY(C, 3),HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD
    },
    {                   /*  10 */
        KEY(E, 2),HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD
    },
    {                   /*  11 */
        KEY(F, 2),HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD
    },
    "--00000000000000", /*  12 */
    "--0000000000-3-0", /*  13 */
    "----s-------s---", /*  14 */
    "--s--s--ss--s-ss", /*  15 */
    {                   /*  16 */
        KEY(A, 3),
        KEY(D, 4),
        KEY(F, 4),
        KEY(A, 4),
        KEY(D, 5)
    },
    {                   /*  17 */
        KEY(F, 3),
        KEY(A, 4),
        KEY(C, 4),
        KEY(E, 4),
        KEY(A, 4)
    },
    {                   /*  18 */
        KEY(G, 3),
        KEY(A, 3),
        KEY(C, 4),
        KEY(E, 4),
        KEY(G, 4)
    },
    {                   /*  19 */
        KEY(F, 4),
        KEY(A, 4),
        KEY(C, 5),
        KEY(E, 5),
        KEY(G, 5)
    },
    {                   /** 20 */
        KEY(F, 3),HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,KEY(E, 3),HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD
    },
    "--000000--000000", /** 21 */
    {                   /** 22 */
        KEY(D, 6),HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD,HOLD
    },
    "k--wk--wk--qk--q", /** 23 */
    "k-wqk-wqk-wqk-wq", /** 24 */
    "kwqwkwqwkwqwkwqw", /** 25 */
    "kkkkkkkkkkkkkkkk", /** 26 */
    "q---q---q---q---", /** 27 */
    "--o---o---o---o-", /** 28 */
    "s---s---s---s---", /** 29 */
    "sssss---s---s---", /*  30 */
    "sssss-s-s-s-s-s-", /*  31 */
    "c---c---c---c---", /*  32 */
    "111111111111----", /*  33 */
    "2222222222222222", /*  34 */
    "c---c---c---cccc", /*  35 */
    {                   /*  36 */
        1, 2, 3, 4, 5, 6, 7, 8, 0, 10, 0, 12, 0, 14, 0, 16
    },
    {                   /*  37 */
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (B, 4),
        KEY (B, 4),
        KEY (C, 5),
        KEY (C, 5),
    }, // --w-e-ry--7-i-t-
    {                   /*  38 */
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (C, 5),
        KEY (B, 4),
        KEY (B, 4),
        KEY (A, 4),
        KEY (A, 4),
    }, // --w-e-ry--7-i-t-
    {                   /*  39 */
        KEY (E, 4),
        KEY (E, 4),
        KEY (E, 4),
        KEY (E, 4),
        KEY (E, 4),
        KEY (E, 4),
        KEY (F, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (A, 4),
        KEY (AS,4),
        KEY (AS,4),
        KEY (C, 5),
        KEY (C, 5),
        KEY (G, 4),
        KEY (G, 4),
    }, // --w-e-ry--7-i-t-
    {                   /** 40 */
        KEY (F, 4),
        KEY (F, 4),
        KEY (F, 4),
        KEY (F, 4),
        KEY (E, 4),
        KEY (E, 4),
        KEY (E, 4),
        KEY (E, 4),
        KEY (C, 4),
        KEY (C, 4),
        KEY (C, 4),
        KEY (C, 4),
        KEY (A, 3),
        KEY (A, 3),
        KEY (A, 3),
        KEY (A, 3),
    }, // --w-e-ry--7-i-t-
    {                   /** 41 */
        1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 11, 12, 13, 14, 15, 16
    },
    {                   /** 42 */
        0, 0, 0, 0, 5, 6, 7, 8, 0, 10, 0, 12, 0, 14, 0, 16
    },
    "----------------", /** 43 */
    {                   /** 44 -- a melody */
        KEY(D, 4),
        KEY(F, 4),
        KEY(A, 4),
        KEY(C, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(D, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(D, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(D, 5),
        KEY(E, 5),
    },
    {                   /** 45 -- a better one */
        KEY(C, 6),
        HOLD,
        HOLD,
        HOLD,
        OFF,
        OFF,
        OFF,
        OFF,
        KEY(E, 6),
        HOLD,
        HOLD,
        HOLD,
        KEY(B, 5),
        HOLD,
        OFF,
        KEY(C, 6),
    },
    {                   /** 56 */
        OFF,
        OFF,
        KEY(G, 5),
        HOLD,
        OFF,
        OFF,
        OFF,
        OFF,
        OFF,
        OFF,
        KEY(C, 6),
        HOLD,
        OFF,
        KEY(E, 5),
        OFF,
        OFF,
    },
    {                   /** 57 */
        KEY(F, 5),
        OFF,
        OFF,
        KEY(C, 6),
        OFF,
        OFF,
        KEY(F, 5),
        OFF,
        OFF,
        OFF,
        OFF,
        OFF,
        OFF,
        OFF,
        OFF,
        OFF,
    },
    {                   /** 58 */
        KEY(A, 6),
        HOLD,
        HOLD,
        KEY(G, 6),
        HOLD,
        HOLD,
        KEY(F, 6),
        HOLD,
        HOLD,
        KEY(E, 6),
        HOLD,
        KEY(C, 6),
        HOLD,
        HOLD,
        KEY(A, 5),
        HOLD,
    },
    {                   /** 49 -- works better with that one synth now :3 */
        KEY(A, 4),
        KEY(A, 4),
        KEY(A, 4),
        KEY(A, 4),
        KEY(A, 4),
        KEY(A, 4),
        KEY(B, 4),
        KEY(B, 4),
        KEY(C, 5),
        KEY(C, 5),
        KEY(C, 5),
        KEY(C, 5),
        KEY(G, 5),
        KEY(G, 5),
        KEY(E, 5),
        KEY(E, 5),
    },
    {                   /*  50 */
        KEY(E, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(G, 4),
        KEY(G, 4),
        KEY(B, 4),
        KEY(B, 4),
        KEY(G, 4),
        KEY(G, 4),
        KEY(A, 4),
        KEY(A, 4),
        KEY(A, 4),
        KEY(A, 4),
    },
    {                   /*  51 */
        KEY(C, 5),
        KEY(C, 5),
        KEY(C, 5),
        KEY(C, 5),
        KEY(C, 5),
        KEY(C, 5),
        KEY(B, 4),
        KEY(B, 4),
        KEY(C, 5),
        KEY(C, 5),
        KEY(C, 5),
        KEY(C, 5),
        KEY(G, 5),
        KEY(G, 5),
        KEY(A, 5),
        KEY(A, 5),
    },
    {                   /*  52 */
        KEY(E, 6),
        KEY(E, 6),
        KEY(E, 6),
        KEY(C, 6),
        KEY(C, 6),
        KEY(C, 6),
        KEY(D, 5),
        KEY(D, 5),
        KEY(G, 5),
        KEY(G, 5),
        KEY(D, 5),
        KEY(D, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(E, 5),
        KEY(E, 5),
    },
    {                   /*  53 -- patterns for that synth */
        1, 1, 1, 1, 0, 0, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5
    },
    {                   /*  54 */
        0, 0, 0, 0, 0, 0, 6, 6, 7, 7, 8, 8, 7, 7, 7, 7
    },
    {                   /*  55 */
        6, 6, 6, 6, 0, 0, 5, 5, 4, 4, 4, 4, 3, 3, 3, 2
    },
    {                   /*  56 */
        2, 2, 0, 1, 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10
    },
    {                   /*  57 */
        KEY (A, 2),
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
    },
    {                   /*  58 */
        KEY (G, 2),
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
    },
    {                   /*  59 */
        KEY (C, 2),
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
    },
    {                   /** 60 */
        KEY (F, 2),
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
        HOLD,
    },
    {                   /** 61 -- some chords */
        KEY (C, 4),
        KEY (E, 4),
        KEY (G, 4),
        KEY (B, 4),
    },
    {                   /** 62 */
        KEY (C, 4),
        KEY (E, 4),
        KEY (G, 4),
        KEY (C, 5),
    },
    {                   /** 63 */
        KEY (D, 4),
        KEY (F, 4),
        KEY (A, 4),
        KEY (C, 5),
    },
    {                   /** 64 */
        KEY (C, 4),
        KEY (F, 4),
        KEY (A, 4),
        KEY (C, 5),
    },
    {                   /** 65 -- Voice, you're being difficult :c */
        KEY(A, 1),KEY(A, 2),KEY(A, 1),KEY(A, 2),KEY(A, 1),KEY(A, 2),KEY(A, 1),KEY(A, 2),KEY(A, 1),KEY(A, 2),KEY(A, 1),KEY(A, 2),KEY(A, 1),KEY(A, 2),KEY(A, 1),KEY(A, 2),//127,127,127,127,127,127,127,127,127,127,127,127,127,127,127
    },
    "ccccc-c-c-c-c-c-", /** 66 */
};


static const int kickorder[] = {
     5,  5,  5,  5,  23, 24, 25, 26,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 23, 24, 25, /*26,*/ 0,
     5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5, 23, 24, 25,  0,
    27, 27, 27, 27, 27, 27,  0,  0,
    0,
};

static const int snareorder[] = {
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  15,
    14, 14, 14, 14, 14, 14, 14, 15,
    14, 14, 14, 14, 14, 14, 14, /*15,*/ 0,
    29, 29, 29, 29, 30, 30, 30, 30,
    30, 30, 30, 30, 31, 31, 31, 15,
    14, 14, 14, 14, 14, 14, 14,  0,
    14, 14, 14, 14, 14, 14, 14, 29,
     0,  0,  0,  0,  0,  0,  0, 29,
    0,
};

static const int hatorder[] = {
     7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  /*7,*/  0,
     7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  0,
     7,  7,  7,  7,  7,  7,  7,  7,
     0,
};

static const int cborder[] = {
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 35,
     0,  0,  0,  0,  0,  0,  0,  0,
    32, 32, 32, 32, 32, 32, 32, 35,
     0,  0,  0,  0,  0,  0,  0,  0,
    32, 32, 32, 32, 32, 32, 32, 66,
     0,  0,  0,  0,  0,  0,  0,  0,
    0,
};

static const int pl_order[] = {
     0,  0,  0,  0,  0,  0,  0,  0,
     1,  1,  1,  1,  1,  1,  1,  1,
     0,  0,  0,  0,  0,  0,  0,  0,
     1,  2,  3,  4,  1,  2,  3,  /*4,*/  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     1,  2,  3,  4,  1,  2,  3,  4,
     1,  2,  3,  4,  1,  2,  3,  4,
     1,  2,  3,  4,  1,  2,  3,  4,
     1,  2,  3,  4,  1,  2,  3,  4,
     //~ 0,  0,  0,  0,  0,  0,  0,  0,
     0,
};

static const int bassorder[] = {
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  /*0,*/  0,
     8,  8, 10, 11,  8,  9, 10, 11,
     8,  9, 10, 11,  8,  9, 10, 20,
    57, 58, 59, 60, 57, 58, 59, 60,
    57, 58, 59, 60, 57, 58, 59,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
    0,
};

static const int wub_order[] = {
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    //~ 43, 43, 43, 43, 43, 43, 43, 43,
    //~ 43, 43, 43, 43, 43, 43, 43, 43,
    13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13,  0,
    21, 21, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21,  0,
    12, 12, 12, 12, 12, 12, 12, 12,
    0,
};

static const int pad_order[] = {
     1,  1,  1,  1,  1,  1,  18, 17,
     1,  1,  1,  1,  1,  1,  18, 17,
    16,  4, 18, 17, 16,  2,  3,  17,
    16,  4, 18, 17, 16,  2,  3,  /*17,*/  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     1,  2,  3,  4,  1,  2,  3,  4,
     0,
};

static const int padscorder[] = {
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    33, 33, 33, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 33, 33, 33, /*33,*/  0,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    34, 34, 34, 34, 34, 34, 34, 34,
    0,
};

/* these are the vowels */
static const int vocvorder[] = {
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  /*0,
    //~ 53, 54, 55, 56, 53, 54, 55, 56,
    53, 54, 55, 56, 53, 54, 55,*/ 42,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 41,
    53, 54, 55, 56, 53, 54, 55, 53,
    53, 54, 55, 56, 53, 54, 55,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
    0,
};

/* 
 * and THESE are the peevelin notes
 * never
 *     like,
 *          EVER
 * confuse them again, okay?
 */
static const int vockorder[] = {
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 40,
     //~ 0,  0,  0,  0,  0,  0,  0,  8,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 40,
    49, 50, 51, 52, 49, 50, 51, 52,
    49, 50, 51, 52, 49, 50, 51,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
    0,
};

/* 
 * Really, I am too tired to nam e st uff propelry
 */
static const int c2order[] = {
    0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,
   61, 62, 63, 64, 61, 62, 63, 64,
   61, 62, 63, 64, 61, 62, 63,  0,
    0,  0,  0,  0,  0,  0,  0,  0,
   0,
};

static const int vororder[] = {
    //~ 45, 46, 47, 48, 45, 46, 47, 48,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,
    45, 46, 47, 48, 45, 46, 47, 48,
     0,  0,  0,  0,  0,  0,  0,  0,
    0,
};

static const int songlength = (9*8)+1;

#endif
