//Joku shader-efekti juttu


var End = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

End.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
End.prototype.initScene = function(){
  
  //some min and max values
  this.minX = -TDEMO.width/2;
  this.maxX = TDEMO.width/2;
  this.minY = -TDEMO.height/2;
  this.maxY = TDEMO.height/2;
  
  //MAIN SCENE
  this.scene = new THREE.Scene();
  this.camera = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
  this.camera.position.z = 1;
  this.scene.add(this.camera);
  
  this.uniforms =  {
    time : {type : "f", value: 0.0},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)},
    phase : {type : "f", value: 1.0}
  };
  
  var planeMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniforms,
      vertexShader: document.getElementById( 'basic_vertex' ).textContent,
      fragmentShader: document.getElementById( 'ceiling_fragment' ).textContent
  });
  
  this.plane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), planeMaterial);  
  this.scene.add(this.plane);
  
  this.t1 = 7.2;
  this.phase = 1.0;
}

//rendering function
End.prototype.render = function(elapsedTime){
  TDEMO.renderer.render(this.scene, this.camera);
}

End.prototype.prepare = function(elapsedTime){
  this.startTime = elapsedTime;
}

//Operations tahta takes place before rendering in every cycle
End.prototype.animate = function(elapsedTime){

  /*if(this.phase == 1.0 && (elapsedTime-this.startTime) >= this.t1){
    this.phase = 2.0;
    this.uniforms.phase.value = 2.0;
  }
  if(this.phase == 1.0){*/
    this.uniforms.time.value = ((elapsedTime-this.startTime));
  //}
}

