//Joku shader-efekti juttu


var Tunneli = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

Tunneli.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Tunneli.prototype.initScene = function(){
  
  //MAIN SCENE
  this.scene = new THREE.Scene();
  this.camera = new THREE.PerspectiveCamera();
  this.camera.position.z = 500;
  this.scene.add(this.camera);
  
  var ambient = new THREE.AmbientLight(0xF8F8FF);
  this.scene.add(ambient);
  
  var pointLight = new THREE.PointLight(0xBF5FFF);
  pointLight.position.z = 100;
  this.scene.add(pointLight);
  
  this.scene.fog = new THREE.Fog( 0xCDCCFF, 20.0, 600 );
  //this.scene.fog = new THREE.Fog( 0xD9D9F3, 1.0, 500 );
  
  var skyMaterial = new THREE.MeshBasicMaterial({color : /*0xFAFFFF*/0x7171C6, side: THREE.BackSide});
  this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(800, 16, 16), skyMaterial);
  this.scene.add(this.skySphere);
  
  this.balls = new THREE.Object3D();
  this.scene.add(this.balls);
  
  var BALLS_AMOUNT = 38;
  var r = 100;
  var delta = 2*Math.PI/BALLS_AMOUNT;
  var alpha = 0;
  var deltaZ = 20;
  var z = 0;
  var ballMaterial = new THREE.MeshPhongMaterial({
    color : 0x5D478B,//0x525052,
    ambient : 0x304132,
    emissive : 0x7171C6,//0x855285,
    specular : 0x483D8B,//0xFF55FF
  });
  for(var i = 0; i < BALLS_AMOUNT; ++i){
   
    var ball = new THREE.Mesh(new THREE.SphereGeometry(18, 16, 16), ballMaterial);
    
    ball.position.y = Math.sin(alpha)*r;
    ball.position.x = Math.cos(alpha)*r;
    ball.position.z = z
    this.balls.add(ball);
    
    if(i != 0){
      var ball2 = ball.clone();
      ball2.position.y = Math.sin(-alpha)*r;
      ball2.position.x = Math.cos(-alpha)*r;
      this.balls.add(ball2);
    }
    z -= deltaZ;
    alpha += delta;
  }
  this.balls2 = this.balls.clone();
  this.balls2.position.z = z;
  this.balls2.rotation.y = Math.PI;
  this.scene.add(this.balls2);
  
  this.balls.rotation.z = Math.PI/3;
  this.balls2.rotation.z = -Math.PI/3;
  
  //kamera-ajoihin liittyvt muutujat
  this.phase = 1;
  this.initialZ = this.camera.position.z;
  //vaihe 1
  this.s1 = -700-this.initialZ;
  this.t1 = 15;
  this.v1 = this.s1/this.t1;
  //vaihe2
  this.s2 = Math.PI/4;
  this.t2 = 2;
  this.v2 = this.s2/this.t2;
  //vaihe2
  this.s3 = 50-(-700);
  this.t3 = this.duration-this.t1-this.t2-2;
  this.v3 = this.s3/this.t3;
  this.r3 = 2*Math.PI;
  this.vr3 = this.r3/this.t3;
  //vaihe4
  this.r4 = Math.PI/4;
  this.t4 = 2;
  this.v4 = this.r4/this.t4;
}

Tunneli.prototype.prepare = function(elapsedTime){
  this.startTime = elapsedTime;
}

//rendering function
Tunneli.prototype.render = function(elapsedTime){
  TDEMO.renderer.render(this.scene, this.camera);
}

//Operations that takes place before rendering in every cycle
Tunneli.prototype.animate = function(elapsedTime){

  if(this.phase == 1 && (elapsedTime-this.startTime) >= this.t1){
    this.phase = 2;
    this.camera.position.y = -10;
  }
  else if(this.phase == 2 && (elapsedTime-this.startTime) >= (this.t1+this.t2)){
    this.phase = 3;
    this.initialZ = this.camera.position.z;
    this.initialR = this.camera.rotation.y;
  }
  else if(this.phase ==3 && (elapsedTime-this.startTime) >=
    (this.t1+this.t2+this.t3)){
    this.phase = 4;
    this.initialR = this.camera.rotation.y;
  }
    
  if(this.phase == 1){
    this.balls.rotation.z += Math.PI/400;
    this.balls2.rotation.z -= Math.PI/400;
    this.camera.position.y = Math.sin(elapsedTime)*50;
    
    this.camera.position.z =
      this.initialZ+(this.v1*(elapsedTime-this.startTime));
  }
  else if(this.phase == 2){
    this.camera.rotation.y =
      (this.v2*(elapsedTime-this.t1 -this.startTime));
  }
  else if(this.phase ==3){
    this.camera.position.z =
      this.initialZ+(this.v3*(elapsedTime-this.t1-this.t2-this.startTime));
      
    this.camera.rotation.y =
      this.initialR+(this.vr3*(elapsedTime-this.t1-this.t2-this.startTime));
  }
  else{
    this.camera.rotation.y =
      this.initialR+(this.v4*(elapsedTime-this.t1-this.t2-this.t3-this.startTime));
  }
}

