﻿


// ReSharper disable InconsistentNaming

var game;
document.onreadystatechange = function (e) {
    if (document.readyState == "complete") {
        game = new AcceleratedRotation();
    }
};

function restartGame() {
    game.restartGame();
}

var AcceleratedRotation = function () {
    var c = document.getElementById("myCanvas");
    var ctx = c.getContext("2d");
    paper.setup(c);

    var acceleration = .4;
    var fixedPoint = { x: 300, y: 200 };

    var girl = new function () {
        var _that = this;

        this.position = { x: 900, y: 300 };

        var paperImageGirl = new paper.Raster({ source: "images/how-to-draw-miley-cyrus-on-a-wrecking-ball_1_000000018154_5.png", position: [_that.position.x, _that.position.y] });

        this.boy = null;
        //var boyList = [];
        //this.addToBoyList = function (newBoy) {
        //    var pathGroup = new paper.Group([newBoy]);
        //    pathGroup.position.y -= 28;
        //    boyList.push(pathGroup);
        //};

        var angleInterval = 0;
        var timer = setInterval(function () {
            angleInterval += 0.05;
            var currentAngle = paperImageGirl.matrix.rotation;
            paperImageGirl.rotate(Math.sin(angleInterval) * 30 - currentAngle - 16, [960, 160]);
            if (_that.boy) {
                _that.boy.rotate(Math.sin(angleInterval) * 30 - currentAngle - 16, [960, 160]);
            }
            //for (var b = 0; b < boyList.length; b++) {
            //    boyList[b].rotate(Math.sin(angleInterval) * 30 - currentAngle - 16, [960, 160]);
            //}
        }, 20);
        this.stopGirl = function () {
            clearInterval(timer);
        };
    };

    //var boy = function(pos, rotation) {
    //    var paperImageBoy = new paper.Raster({ source: "images/land_recreation_swings_park_clip_art.png", position: [pos.x, pos.y] });
    //    paperImageBoy.opacity = .5;
    //    paperImageBoy.rotate(rotation);
    //    return paperImageBoy;
    //};

    var mass = new function () {
        var _that = this;

        this.reset = function () {
            _that.angularSpeed = 0.05;
            velocity = { x: 0, y: 0 };
            position = { x: 300, y: 400 };
            _that.fixed = true;
            paperImage.rotate(-paperImage.matrix.rotation);
            paper.project.activeLayer.addChild(paperImage);
        };

        this.fixed = true;
        this.jump = function () {
            _that.fixed = false;
            var angleBetweenMassPositionAndFixedPoint = Math.atan2(mass.position.y - fixedPoint.y, mass.position.x - fixedPoint.x);
            velocity.x = -_that.angularSpeed * Math.cos(angleBetweenMassPositionAndFixedPoint) * _that.distanceToFixedPoint;
            velocity.y = (-_that.angularSpeed * Math.sin(angleBetweenMassPositionAndFixedPoint) * _that.distanceToFixedPoint);
        };

        this.mass = 2;
        this.angularSpeed = 0.05;
        var position = { x: 300, y: 400 };
        Object.defineProperty(this, "position", {
            get: function () {
                return position;
            },
            set: function (value) {
                position = value;
            }
        });
        var velocity = { x: 0, y: 0 };
        Object.defineProperty(this, "velocity", {
            get: function () {
                return velocity;
            },
            set: function (value) {
                velocity = value;
            }
        });
        Object.defineProperty(this, "speed", {
            get: function () {
                return Math.sqrt(velocity.x * velocity.x + velocity.y * velocity.y);
            }
        });
        Object.defineProperty(this, "distanceToFixedPoint", {
            get: function () {
                return Math.sqrt(Math.pow(position.x - fixedPoint.x, 2) + Math.pow(position.y - fixedPoint.y, 2));
            }
        });
        Object.defineProperty(this, "paperImage", {
            get: function () {
                return paperImage;
            }
        });

        this.getBoyClone = function () {
            return paperImage.clone();
        };

        var layingTimer;
        this.stopLaying = function () {
            if (layingTimer) clearInterval(layingTimer);
        };
        this.layBack = function () {
            if (layingTimer) clearInterval(layingTimer);
            layingTimer = setInterval(function () {
                paperImage.rotate(-1);
                console.log(paperImage.matrix.rotation);
            }, 10);
        };
        this.layFront = function () {
            if (layingTimer) clearInterval(layingTimer);
            layingTimer = setInterval(function () {
                paperImage.rotate(1);
                console.log(paperImage.matrix.rotation);
            }, 10);
        };

        //var paperObject = new paper.Shape.Circle(new paper.Point(position.x, position.y), 5);
        //paperObject.fillColor = 'red';

        var paperImage = new paper.Raster({ source: "images/land_recreation_swings_park_clip_art.png", position: [200, 200] });


        var paperVelocityObject = new paper.Path.Line(new paper.Point(position.x, position.y), new paper.Point(position.x + velocity.x, position.y + velocity.y));
        paperVelocityObject.strokeColor = 'green';

        //var paperTextAngularSpeed = new paper.PointText({ content: "0", point: [20, 40], fontSize: 30 });
        //var paperTextMaxAngularSpeed = new paper.PointText({ content: "0", point: [20, 80], fontSize: 30 });

        //var lastMaxSpeed = 0;
        //var lastSpeed;
        this.render = function () {
            //paperObject.position = new paper.Point(position.x, position.y);

            paperImage.position = new paper.Point(position.x + 10, position.y - 20);

            paperVelocityObject.remove();
            if (_that.fixed == true) {
                paperVelocityObject = new paper.Path.Line(new paper.Point(position.x, position.y), new paper.Point(fixedPoint.x, fixedPoint.y));
                paperVelocityObject.strokeColor = 'black';
            }
            //paperTextAngularSpeed.content = Math.round(Math.abs(_that.angularSpeed) * 500);

            //if (lastSpeed < Math.abs(_that.angularSpeed)) {
            //    lastMaxSpeed = Math.abs(_that.angularSpeed);
            //} else {
            //    paperTextMaxAngularSpeed.content = Math.round(lastMaxSpeed * 500);
            //}
            //lastSpeed = Math.abs(_that.angularSpeed);
        };

    };


    function rotate_point(pointX, pointY, originX, originY, angle) {
        var cos = Math.cos(angle);
        var sin = Math.sin(angle);
        return {
            x: cos * (pointX - originX) - sin * (pointY - originY) + originX,
            y: sin * (pointX - originX) + cos * (pointY - originY) + originY
        };
    }

    this.restartGame = function () {
        acceleration = 0.4;
        if (girl.boy) {
            girl.boy.remove();
            girl.boy = null;
        }
        mass.reset();
        isGameRunning = true;
    };

    var isGameRunning = true;
    var update = function () {
        if (isGameRunning == false) return;
        if (mass.fixed == true) {

            var angleBetweenMassPositionAndFixedPoint = Math.atan2(mass.position.y - fixedPoint.y, mass.position.x - fixedPoint.x);
            var tangentialAcceleration = acceleration * Math.cos(angleBetweenMassPositionAndFixedPoint);

            tangentialAcceleration += -accelerationAppliedByUser.x * Math.sin(angleBetweenMassPositionAndFixedPoint) + accelerationAppliedByUser.y * Math.cos(angleBetweenMassPositionAndFixedPoint);

            var angularAcceleration = tangentialAcceleration / mass.distanceToFixedPoint;

            mass.velocity.x += tangentialAcceleration * Math.cos(angleBetweenMassPositionAndFixedPoint);
            mass.velocity.y += tangentialAcceleration * Math.sin(angleBetweenMassPositionAndFixedPoint);

            mass.velocity.x *= Math.sin(angleBetweenMassPositionAndFixedPoint);
            mass.velocity.y *= -Math.cos(angleBetweenMassPositionAndFixedPoint);

            mass.angularSpeed += angularAcceleration; //tangentialSpeed / mass.distanceToFixedPoint;
            var tangentialSpeed = mass.velocity.x * Math.sin(angleBetweenMassPositionAndFixedPoint) + mass.velocity.y * Math.cos(angleBetweenMassPositionAndFixedPoint);

            var newPoint = rotate_point(mass.position.x, mass.position.y, fixedPoint.x, fixedPoint.y, mass.angularSpeed);

            mass.position.x = newPoint.x;
            mass.position.y = newPoint.y;

        } else {
            mass.velocity.y += acceleration / 3;

            mass.position.x += mass.velocity.x;
            mass.position.y += mass.velocity.y;

            if (mass.position.x > girl.position.x - 30 && mass.position.x < girl.position.x + 100) {
                if (mass.position.y > 180 && mass.position.y < 320) {
                    mass.velocity.x = 0;
                    mass.velocity.y = 0;

                    acceleration = 0;

                    var pathGroup = new paper.Group([mass.paperImage]);
                    pathGroup.transformContent = false;
                    //pathGroup.position.y -= 28;
                    girl.boy = pathGroup;

                    isGameRunning = false;

                    document.getElementById("soundScream").play();

                    //girl.addToBoyList(new boy(mass.position, mass.rotation));

                    //mass.position = { x: 0, y: 0 };

                    //girl.stopGirl();
                }
            } else if (mass.position.x > girl.position.x - 70 && mass.position.x < girl.position.x + 100) {
                if (mass.position.y > 300 && mass.position.y < 500) {
                    mass.velocity.x = 0;
                    mass.velocity.y = 0;

                    isGameRunning = true;
                    acceleration = 0.8;
                    //girl.stopGirl();
                }

            } else if (mass.position.x > 1300 || mass.position.x < -100 || mass.position.y > 1000) {
                if (mass.position.y > 300 && mass.position.y < 500) {
                    mass.velocity.x = 0;
                    mass.velocity.y = 0;

                    isGameRunning = false;
                    //girl.stopGirl();
                }

            }
        }



        //console.log(angleBetweenMassPositionAndFixedPoint / Math.PI * 180, tangentialAcceleration, angularAcceleration);
    };

    var fixedPointPaperObject = new paper.Shape.Circle(new paper.Point(fixedPoint.x, fixedPoint.y), 5);
    fixedPointPaperObject.fillColor = 'black';
    var render = function () {
        mass.render();

        fixedPointPaperObject.position = new paper.Point(fixedPoint.x, fixedPoint.y);

        paper.view.draw();
    };

    setInterval(function () {

        update();
        render();
    }, 10);

    var accelerationAppliedByUser = { x: 0, y: 0 };
    var accelerationToBeApplied = 0.07;

    var tool = new paper.Tool();
    tool.onMouseDown = function (event) {
        //if (MoBoard.boardActive == false) return;

        //event.point = getScaledPoint(event.point);
        //event.downPoint = getScaledPoint(event.downPoint);


    };
    tool.onMouseMove = function (event) {
        //event.point = getScaledPoint(event.point);
        //event.downPoint = getScaledPoint(event.downPoint);
    };
    tool.onMouseDrag = function (event) {
        //event.point = getScaledPoint(event.point);
        //event.downPoint = getScaledPoint(event.downPoint);
    };
    tool.onMouseUp = function (event) {
        //event.point = getScaledPoint(event.point);
        //event.downPoint = getScaledPoint(event.downPoint);
    };
    tool.onKeyDown = function (event) {
        switch (event.key) {
            case "left":
            case "a":
                console.log("sol");
                accelerationAppliedByUser.x = -accelerationToBeApplied;
                mass.layBack();
                break;
            case "right":
            case "d":
                console.log("sağ");
                accelerationAppliedByUser.x = accelerationToBeApplied;
                mass.layFront();
                break;
            case "up":
            case "w":
                console.log("up");
                accelerationAppliedByUser.y = -accelerationToBeApplied;
                break;
            case "down":
            case "s":
                console.log("down");
                accelerationAppliedByUser.y = accelerationToBeApplied;
                break;
            case "space":
                mass.jump();
            default:
        }

        //console.log(accelerationAppliedByUser);
    };
    tool.onKeyUp = function (event) {
        switch (event.key) {
            case "left":
            case "a":
                console.log("sol");
                accelerationAppliedByUser.x = 0;
                mass.stopLaying();
                break;
            case "right":
            case "d":
                console.log("sağ");
                accelerationAppliedByUser.x = 0;
                mass.stopLaying();
                break;
            case "up":
            case "w":
                console.log("up");
                accelerationAppliedByUser.y = 0;
                break;
            case "down":
            case "s":
                console.log("down");
                accelerationAppliedByUser.y = 0;
                break;
            default:
        }
        //console.log(accelerationAppliedByUser);
    };


}