(function(demo){
	var scene = new DemoScene(demo);
	
	scene.duration = 24;
	scene.scene = new THREE.Scene();
	
	var sphereRadius = 1600,
		shaderAttributes = {
			size: {	type: 'f', value: [] },
			customColor: { type: 'c', value: [] }
		},
		shaderUniforms = {
			amplitude: { type: "f", value: 1.0 },
			color:     { type: "c", value: new THREE.Color( 0xffffff ) },
			texture:   { type: "t", value: 0, texture: THREE.ImageUtils.loadTexture( "textures/sprites/spark1.png" ) },
		},
		camera = new THREE.PerspectiveCamera(85, demo.settings.viewport.aspect, 1, 4000),
		torusGeometry = new THREE.TorusGeometry(100, 30, 8, 24, Math.PI*2),
		torusMaterial = new THREE.MeshLambertMaterial({
			color: 0xffffff,
			wireframe: false
		}),
		particleGeometry = new THREE.Geometry(),
		particleMaterial = new THREE.ShaderMaterial({
			uniforms: 		shaderUniforms,
			attributes:     shaderAttributes,
			vertexShader:   document.getElementById('particle_vertex').textContent,
			fragmentShader: document.getElementById('particle_fragment').textContent,
	
			blending: 		THREE.AdditiveBlending,
			depthTest: 		true,
			transparent:	true
		}),
		light = new THREE.SpotLight( 0xffffff, 1.5 ),
		light2 = new THREE.AmbientLight(0x110022),
		meshArray = [];
	
	
	// Create torus instances
	for(var z = -10; z < 10; z++){
		for(var x = -10; x < 10; x++){
			var instance = new THREE.Mesh(torusGeometry, torusMaterial);
			instance.position.x = (.5 - Math.random()) * 2600;
			instance.position.y = (.5 - Math.random()) * 2600 - 400;
			instance.position.z = (.5 - Math.random()) * 2600 + 400;
			
			instance.rotation.x = (.5 - Math.random()) * 60;
			instance.rotation.y = (.5 - Math.random()) * 60;
			instance.rotation.z = (.5 - Math.random()) * 60;
			
			instance.castShadow = true;
			instance.receiveShadow = true;
			
			meshArray.push(instance);
			scene.scene.add(instance);
		}
	}
	
	
	// Create particles
	for(var i = 25000; i--;){
		var vertex = new THREE.Vector3();
		vertex.x = Math.random() * 2 - 1;
		vertex.y = Math.random() * 2 - 1;
		vertex.z = Math.random() * 2 - 1;
		vertex.multiplyScalar(sphereRadius);

		particleGeometry.vertices.push(vertex);
	}
	
	var sphere = new THREE.ParticleSystem(particleGeometry, particleMaterial),
		vertices = sphere.geometry.vertices,
		values_size = shaderAttributes.size.value,
		values_color = shaderAttributes.customColor.value;
		
	sphere.dynamic = true;
	
	
	for(var v = 0; v < vertices.length; v++) {
		values_size[v] = 40;
		values_color[v] = new THREE.Color(0x666666);
	}
	
	
	
	
	scene.camera = camera;
	
	
	
	light.castShadow = true;
	
	light.shadowCameraNear = 300;
	light.shadowCameraFar = camera.far;
	light.shadowCameraFov = 50;
	
	light.shadowBias = -0.00022;
	light.shadowDarkness = 0.9;
	
	light.shadowMapWidth = 1024;
	light.shadowMapHeight = 1024;
	
	
	
	
	scene.scene.add(camera);
	scene.scene.add(light);
	scene.scene.add(light2);
	scene.scene.add(sphere);
	
	scene.update = function(){
		var sceneTime = (this.demo.timing.elapsed - this.startTime);
		
		for(var i = meshArray.length; i--;){
			meshArray[i].scale.z = 1 + Math.sin((sceneTime + i * 140) / 460) * 0.2;
		}
		
		camera.position.x = Math.sin(sceneTime / 3400) * 100;
		camera.position.y = Math.cos((sceneTime + 4000) / 3400) * 100;
		camera.position.z = Math.sin((sceneTime  + 4900) / 3000) * 40;
		
		camera.rotation.x = sceneTime / 1400 * 0.18;
		camera.rotation.y = Math.sin(sceneTime / 1400) * 0.28;
		camera.rotation.z = Math.sin(sceneTime / 1400) * 0.48;
		
		light.position.x = Math.sin(sceneTime / 1400) * 400;
		light.position.y = Math.sin(sceneTime / 2400) * 400;
		light.position.z = Math.sin(sceneTime / 800) * 200;
		
		
		
		for(var i = shaderAttributes.size.value.length; i--;){
			shaderAttributes.size.value[i] = 40 * Math.sin(0.8 * i + sceneTime / 500);
		}

		shaderAttributes.size.needsUpdate = true;
	};
	
	demo.pushScene(scene);
})(demo);