(function(demo){
	var scene = new DemoScene(demo);
	
	scene.duration = 8;
	scene.scene = new THREE.Scene();
	
	
	var sphereRadius = 200,
		shaderAttributes = {
			size: {	type: 'f', value: [] },
			customColor: { type: 'c', value: [] }
		},
		shaderUniforms = {
			amplitude: { type: "f", value: 1.0 },
			color:     { type: "c", value: new THREE.Color( 0xffffff ) },
			texture:   { type: "t", value: 0, texture: THREE.ImageUtils.loadTexture( "textures/sprites/spark1.png" ) },
		},
		camera = new THREE.PerspectiveCamera(85, demo.settings.viewport.aspect, 1, 1000),
		geometry = new THREE.Geometry(),
		material = new THREE.ShaderMaterial({
			uniforms: 		shaderUniforms,
			attributes:     shaderAttributes,
			vertexShader:   document.getElementById('particle_vertex').textContent,
			fragmentShader: document.getElementById('particle_fragment').textContent,
	
			blending: 		THREE.AdditiveBlending,
			depthTest: 		false,
			transparent:	true
		});
	
	for(var i = 75000; i--;){
		var vertex = new THREE.Vector3();
		vertex.x = Math.random() * 2 - 1;
		vertex.y = Math.random() * 2 - 1;
		vertex.z = Math.random() * 2 - 1;
		vertex.multiplyScalar(sphereRadius);

		geometry.vertices.push(vertex);
	}
	
	var sphere = new THREE.ParticleSystem(geometry, material),
		vertices = sphere.geometry.vertices,
		values_size = shaderAttributes.size.value,
		values_color = shaderAttributes.customColor.value;
		
	sphere.dynamic = true;
	
	
	for(var v = 0; v < vertices.length; v++) {
		values_size[v] = 40;
		values_color[v] = new THREE.Color(0xddaaff);
//		values_color[v].setHSV( 0.5 + 0.1 * (v / vertices.length), 0.2, 1.0 );
	
	}
	
	
	
	camera.position.z = 230;
	scene.camera = camera;
	
	scene.scene.add(camera);
	scene.scene.add(sphere);
	
	scene.update = function(){
		var sceneTime = (this.demo.timing.elapsed - this.startTime);
		
		sphere.rotation.z = 0.0001 * sceneTime;
		sphere.rotation.x = 0.0001 * sceneTime;
		sphere.rotation.y = 0.0001 * sceneTime;
		
		for(var i = shaderAttributes.size.value.length; i--;){
			shaderAttributes.size.value[i] = 40 * Math.sin(0.8 * i + sceneTime / 500);
		}

		shaderAttributes.size.needsUpdate = true;
	};
	
	demo.pushScene(scene);
})(demo);