varying vec3 n;
varying vec3 op;
uniform sampler2D light;


void main(void)
{
	vec3 base = vec3(-0.617808, 0.301566, 0.613827);
	
	vec3 norm = normalize(n);
	vec2 tc = vec2((norm.x + 1.0) / 2.0, 1.0 - (norm.y + 1.0) / 2.0);
	vec3 lighting = texture2D(light, tc).rgb;
	vec3 col = vec3(130.0 / 255.0, 217.0 / 255.0, 245.0 / 255.0);
	if((length(base) + 0.003) < length(op))
		col = vec3(210.0 / 255.0, 234.0 / 255.0, 105.0 / 255.0);
	gl_FragData[0].rgb = col.rgb * lighting;
	gl_FragData[0].a = 1.0;

}

