/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.treebox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.TreeBox;
import de.lessvoid.nifty.controls.TreeItem;
import de.lessvoid.nifty.controls.TreeItemSelectedEvent;
import de.lessvoid.nifty.controls.treebox.TreeEntryModelClass;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class TreeBoxControl
extends AbstractController
implements TreeBox {
    private int indentWidth = 15;
    private TreeItem tree;
    private Nifty nifty;
    private Element element;
    private ListBox<TreeEntryModelClass> treeListBox;
    private boolean processingItemSelected;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(element);
        if (controlDefinitionAttributes.getAsInteger("indentWidth") != null) {
            this.indentWidth = controlDefinitionAttributes.getAsInteger("indentWidth");
        }
        this.nifty = nifty;
        this.element = element;
        this.setListBox("#listbox");
        if (this.tree != null) {
            this.addTreeItem(this.treeListBox, this.tree, 0, 0);
        }
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return true;
    }

    @Override
    public void setTree(TreeItem treeRoot) {
        this.tree = treeRoot;
        this.treeListBox.clear();
        if (this.treeListBox != null) {
            this.removeAbsoleteTreeItems(this.treeListBox, this.tree);
            this.addTreeItem(this.treeListBox, this.tree, 0, 0);
            this.getElement().layoutElements();
        }
    }

    @NiftyEventSubscriber(id="tree-box#listbox")
    public void onListBoxSelectionChanged(String id, ListBoxSelectionChangedEvent<TreeEntryModelClass> event) {
        if (!this.processingItemSelected) {
            this.processingItemSelected = true;
            TreeEntryModelClass selectedItem = event.getSelection().get(0);
            Integer selectedIndex = event.getSelectionIndices().get(0);
            TreeItem item = selectedItem.getTreeItem();
            if (!item.isLeaf() && selectedItem.isActiveItem()) {
                item.setExpanded(!item.isExpanded());
            }
            selectedItem.setActiveItem(true);
            this.setTree(this.tree);
            this.treeListBox.getItems().get(selectedIndex).setActiveItem(true);
            this.nifty.publishEvent(this.getId(), (NiftyEvent)new TreeItemSelectedEvent(this, item));
            this.treeListBox.refresh();
            this.processingItemSelected = false;
        }
    }

    private void setListBox(String name) {
        if (this.treeListBox == null) {
            this.treeListBox = (ListBox)this.element.findNiftyControl(name, ListBox.class);
        }
    }

    private int addTreeItem(ListBox<TreeEntryModelClass> treeListBox, TreeItem treeItem, int currentIndent, int itemIndex) {
        if (currentIndent != 0) {
            treeListBox.insertItem(new TreeEntryModelClass(this.indentWidth * currentIndent, treeItem), itemIndex);
            ++itemIndex;
        }
        if (treeItem.isExpanded()) {
            for (TreeItem childItem : treeItem.getTreeItems()) {
                itemIndex = this.addTreeItem(treeListBox, childItem, currentIndent + 1, itemIndex);
            }
        }
        return itemIndex;
    }

    private void removeAbsoleteTreeItems(ListBox<TreeEntryModelClass> treeListBox, TreeItem tree) {
        for (TreeEntryModelClass treeListEntry : treeListBox.getItems()) {
            treeListEntry.setActiveItem(false);
            if (tree.contains(treeListEntry.getTreeItem())) continue;
            treeListBox.removeItem(treeListEntry);
        }
    }
}

