/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.audio.AudioBuffer;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioStream;
import com.jme3.audio.SeekableStream;
import com.jme3.audio.plugins.CachedOggStream;
import com.jme3.audio.plugins.UncachedOggStream;
import com.jme3.util.BufferUtils;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.PhysicalOggStream;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OGGLoader
implements AssetLoader {
    private PhysicalOggStream oggStream;
    private LogicalOggStream loStream;
    private VorbisStream vorbisStream;
    private IdentificationHeader streamHdr;

    private int getOggTotalBytes(int dataBytesTotal) {
        int numSamples;
        if (this.oggStream instanceof CachedOggStream) {
            CachedOggStream cachedOggStream = (CachedOggStream)this.oggStream;
            numSamples = (int)cachedOggStream.getLastOggPage().getAbsoluteGranulePosition();
        } else {
            UncachedOggStream uncachedOggStream = (UncachedOggStream)this.oggStream;
            numSamples = (int)uncachedOggStream.getLastOggPage().getAbsoluteGranulePosition();
        }
        int totalBytes = numSamples * this.streamHdr.getChannels() * 2;
        return Math.min(totalBytes, dataBytesTotal);
    }

    private float computeStreamDuration() {
        if (this.oggStream instanceof UncachedOggStream) {
            return -1.0f;
        }
        int bytesPerSec = 2 * this.streamHdr.getChannels() * this.streamHdr.getSampleRate();
        int totalBytes = this.getOggTotalBytes(Integer.MAX_VALUE);
        return (float)totalBytes / (float)bytesPerSec;
    }

    private ByteBuffer readToBuffer() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int read = 0;
        try {
            while ((read = this.vorbisStream.readPcm(buf, 0, buf.length)) > 0) {
                baos.write(buf, 0, read);
            }
        }
        catch (EndOfOggStreamException ex) {
            // empty catch block
        }
        byte[] dataBytes = baos.toByteArray();
        OGGLoader.swapBytes(dataBytes, 0, dataBytes.length);
        int bytesToCopy = this.getOggTotalBytes(dataBytes.length);
        ByteBuffer data = BufferUtils.createByteBuffer((int)bytesToCopy);
        data.put(dataBytes, 0, bytesToCopy).flip();
        this.vorbisStream.close();
        this.loStream.close();
        this.oggStream.close();
        return data;
    }

    private static void swapBytes(byte[] b, int off, int len) {
        for (int i = off; i < off + len; i += 2) {
            byte tempByte = b[i];
            b[i] = b[i + 1];
            b[i + 1] = tempByte;
        }
    }

    private InputStream readToStream(boolean seekable, float streamDuration) {
        if (seekable) {
            return new SeekableJOggInputStream(this.vorbisStream, this.loStream, streamDuration);
        }
        return new JOggInputStream(this.vorbisStream);
    }

    private AudioData load(InputStream in, boolean readStream, boolean streamCache) throws IOException {
        this.oggStream = readStream && streamCache ? new CachedOggStream(in) : new UncachedOggStream(in);
        Collection streams = this.oggStream.getLogicalStreams();
        this.loStream = (LogicalOggStream)streams.iterator().next();
        this.vorbisStream = new VorbisStream(this.loStream);
        this.streamHdr = this.vorbisStream.getIdentificationHeader();
        if (!readStream) {
            AudioBuffer audioBuffer = new AudioBuffer();
            audioBuffer.setupFormat(this.streamHdr.getChannels(), 16, this.streamHdr.getSampleRate());
            audioBuffer.updateData(this.readToBuffer());
            return audioBuffer;
        }
        AudioStream audioStream = new AudioStream();
        audioStream.setupFormat(this.streamHdr.getChannels(), 16, this.streamHdr.getSampleRate());
        float streamDuration = this.computeStreamDuration();
        audioStream.updateData(this.readToStream(this.oggStream.isSeekable(), streamDuration), streamDuration);
        return audioStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        if (!(info.getKey() instanceof AudioKey)) {
            throw new IllegalArgumentException("Audio assets must be loaded using an AudioKey");
        }
        AudioKey key = (AudioKey)info.getKey();
        boolean readStream = key.isStream();
        boolean streamCache = key.useStreamCache();
        InputStream in = null;
        try {
            in = info.openStream();
            AudioData data = this.load(in, readStream, streamCache);
            if (data instanceof AudioStream) {
                in = null;
            }
            AudioData audioData = data;
            return audioData;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static class JOggInputStream
    extends InputStream {
        private boolean endOfStream = false;
        protected final VorbisStream vs;

        public JOggInputStream(VorbisStream vs) {
            this.vs = vs;
        }

        public int read() throws IOException {
            return 0;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            int bytesRead;
            if (this.endOfStream) {
                return -1;
            }
            int cnt = 0;
            assert (length % 2 == 0);
            for (bytesRead = 0; bytesRead < length; bytesRead += cnt) {
                cnt = this.vs.readPcm(buf, offset + bytesRead, length - bytesRead);
                if (cnt > 0) continue;
                System.out.println("Read " + cnt + " bytes");
                System.out.println("offset " + offset);
                System.out.println("bytesRead " + bytesRead);
                System.out.println("buf length " + length);
                for (int i = 0; i < bytesRead; ++i) {
                    System.out.print(buf[i]);
                }
                System.out.println("");
                System.out.println("EOS");
                this.endOfStream = true;
                break;
            }
            OGGLoader.swapBytes(buf, offset, bytesRead);
            return bytesRead;
        }

        public void close() throws IOException {
            this.vs.close();
        }
    }

    private static class SeekableJOggInputStream
    extends JOggInputStream
    implements SeekableStream {
        private LogicalOggStream los;
        private float duration;

        public SeekableJOggInputStream(VorbisStream vs, LogicalOggStream los, float duration) {
            super(vs);
            this.los = los;
            this.duration = duration;
        }

        public void setTime(float time) {
            System.out.println("--setTime--)");
            System.out.println("max granule : " + this.los.getMaximumGranulePosition());
            System.out.println("current granule : " + this.los.getTime());
            System.out.println("asked Time : " + time);
            System.out.println("new granule : " + time / this.duration * (float)this.los.getMaximumGranulePosition());
            System.out.println("new granule2 : " + time * (float)this.vs.getIdentificationHeader().getSampleRate());
            try {
                this.los.setTime((long)(time * (float)this.vs.getIdentificationHeader().getSampleRate()));
            }
            catch (IOException ex) {
                Logger.getLogger(OGGLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

